/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocypack;

import com.arangodb.internal.CollectionCache;
import com.arangodb.velocypack.VPackDeserializationContext;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackJsonDeserializer;
import com.arangodb.velocypack.VPackModule;
import com.arangodb.velocypack.VPackParserModule;
import com.arangodb.velocypack.VPackParserSetupContext;
import com.arangodb.velocypack.VPackSetupContext;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocypack.internal.util.NumberUtil;
import org.json.simple.JSONValue;

public class VPackDocumentModule
implements VPackModule,
VPackParserModule {
    private static final String ID = "_id";
    private final CollectionCache collectionCache;

    public VPackDocumentModule(CollectionCache collectionCache) {
        this.collectionCache = collectionCache;
    }

    public <C extends VPackSetupContext<C>> void setup(C context) {
        context.registerDeserializer(ID, String.class, (VPackDeserializer)new VPackDeserializer<String>(){

            public String deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
                String id;
                if (vpack.isCustom()) {
                    long idLong = NumberUtil.toLong((byte[])vpack.getBuffer(), (int)(vpack.getStart() + 1), (int)(vpack.getByteSize() - 1));
                    String collectionName = VPackDocumentModule.this.collectionCache.getCollectionName(idLong);
                    if (collectionName != null) {
                        VPackSlice key = parent.get("_key");
                        id = String.format("%s/%s", collectionName, key.getAsString());
                    } else {
                        id = null;
                    }
                } else {
                    id = vpack.getAsString();
                }
                return id;
            }
        });
    }

    public <C extends VPackParserSetupContext<C>> void setup(C context) {
        context.registerDeserializer(ID, ValueType.CUSTOM, new VPackJsonDeserializer(){

            public void deserialize(VPackSlice parent, String attribute, VPackSlice vpack, StringBuilder json) throws VPackException {
                String id;
                long idLong = NumberUtil.toLong((byte[])vpack.getBuffer(), (int)(vpack.getStart() + 1), (int)(vpack.getByteSize() - 1));
                String collectionName = VPackDocumentModule.this.collectionCache.getCollectionName(idLong);
                if (collectionName != null) {
                    VPackSlice key = parent.get("_key");
                    id = String.format("%s/%s", collectionName, key.getAsString());
                } else {
                    id = null;
                }
                json.append(JSONValue.toJSONString(id));
            }
        });
    }
}

