/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.Host;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.ConnectionPool;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.internal.util.ResponseUtils;
import com.arangodb.internal.velocystream.internal.Chunk;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.internal.velocystream.internal.VstConnection;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VstCommunication<R, C extends VstConnection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunication.class);
    protected static final AtomicLong mId = new AtomicLong(0L);
    protected final ArangoSerialization util;
    protected final ConnectionPool<C> connectionPool;
    protected final String user;
    protected final String password;
    protected final Integer chunksize;

    protected VstCommunication(Integer timeout, String user, String password, Boolean useSsl, SSLContext sslContext, ArangoSerialization util, Integer chunksize, ConnectionPool<C> connectionPool) {
        this.user = user;
        this.password = password;
        this.util = util;
        this.connectionPool = connectionPool;
        this.chunksize = chunksize != null ? chunksize : 30000;
    }

    protected synchronized void connect(C connection) {
        if (!((VstConnection)connection).isOpen()) {
            try {
                ((VstConnection)connection).open();
                if (this.user != null) {
                    this.authenticate(connection);
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ArangoDBException(e);
            }
        }
    }

    protected abstract void authenticate(C var1);

    public void disconnect() throws IOException {
        this.connectionPool.disconnect();
    }

    public R execute(Request request, HostHandle hostHandle) throws ArangoDBException {
        VstConnection connection = (VstConnection)this.connectionPool.connection(hostHandle);
        try {
            return this.execute(request, connection);
        }
        catch (ArangoDBException e) {
            if (e instanceof ArangoDBRedirectException) {
                String location = ((ArangoDBRedirectException)ArangoDBRedirectException.class.cast(e)).getLocation();
                Host host = HostUtils.createFromLocation(location);
                this.connectionPool.closeConnectionOnError(connection);
                return this.execute(request, (C)new HostHandle().setHost(host));
            }
            throw e;
        }
    }

    protected abstract R execute(Request var1, C var2) throws ArangoDBException;

    protected void checkError(Response response) throws ArangoDBException {
        ResponseUtils.checkError(this.util, response);
    }

    protected Response createResponse(Message message) throws VPackParserException {
        Response response = (Response)this.util.deserialize(message.getHead(), (Type)((Object)Response.class));
        if (message.getBody() != null) {
            response.setBody(message.getBody());
        }
        return response;
    }

    protected Message createMessage(Request request) throws VPackParserException {
        long id = mId.incrementAndGet();
        return new Message(id, this.util.serialize(request), request.getBody());
    }

    protected Collection<Chunk> buildChunks(Message message) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        VPackSlice head = message.getHead();
        int size = head.getByteSize();
        VPackSlice body = message.getBody();
        if (body != null) {
            size += body.getByteSize();
        }
        int n = size / this.chunksize;
        int numberOfChunks = size % this.chunksize != 0 ? n + 1 : n;
        int off = 0;
        int i = 0;
        while (size > 0) {
            int len = Math.min(this.chunksize, size);
            long messageLength = i == 0 && numberOfChunks > 1 ? (long)size : -1L;
            Chunk chunk = new Chunk(message.getId(), i, numberOfChunks, messageLength, off, len);
            size -= len;
            off += len;
            chunks.add(chunk);
            ++i;
        }
        return chunks;
    }
}

