/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.velocystream.internal.Chunk;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.internal.velocystream.internal.MessageStore;
import com.arangodb.internal.velocystream.internal.VstConnection;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.net.ssl.SSLContext;

public class ConnectionSync
extends VstConnection {
    private ConnectionSync(HostHandler hostHandler, Integer timeout, Long ttl, Boolean useSsl, SSLContext sslContext, MessageStore messageStore) {
        super(hostHandler, timeout, ttl, useSsl, sslContext, messageStore);
    }

    public Message write(final Message message, Collection<Chunk> chunks) throws ArangoDBException {
        FutureTask<Message> task = new FutureTask<Message>(new Callable<Message>(){

            @Override
            public Message call() throws Exception {
                return ConnectionSync.this.messageStore.get(message.getId());
            }
        });
        this.messageStore.storeMessage(message.getId(), task);
        super.writeIntern(message, chunks);
        try {
            return task.get();
        }
        catch (InterruptedException e) {
            throw new ArangoDBException(e);
        }
        catch (ExecutionException e) {
            throw new ArangoDBException(e);
        }
        catch (CancellationException e) {
            throw new ArangoDBException(e);
        }
    }

    public static class Builder {
        private MessageStore messageStore;
        private HostHandler hostHandler;
        private Integer timeout;
        private Long ttl;
        private Boolean useSsl;
        private SSLContext sslContext;

        public Builder messageStore(MessageStore messageStore) {
            this.messageStore = messageStore;
            return this;
        }

        public Builder hostHandler(HostHandler hostHandler) {
            this.hostHandler = hostHandler;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public ConnectionSync build() {
            return new ConnectionSync(this.hostHandler, this.timeout, this.ttl, this.useSsl, this.sslContext, this.messageStore);
        }
    }
}

