/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import java.util.Arrays;
import java.util.Collection;

public class TransactionOptions {
    private String action;
    private Object params;
    private final TransactionCollectionOptions collections = new TransactionCollectionOptions();
    private Integer lockTimeout;
    private Boolean waitForSync;
    private Long maxTransactionSize;
    private Long intermediateCommitCount;
    private Long intermediateCommitSize;

    protected String getAction() {
        return this.action;
    }

    protected TransactionOptions action(String action) {
        this.action = action;
        return this;
    }

    public Object getParams() {
        return this.params;
    }

    public TransactionOptions params(Object params) {
        this.params = params;
        return this;
    }

    public Integer getLockTimeout() {
        return this.lockTimeout;
    }

    public TransactionOptions lockTimeout(Integer lockTimeout) {
        this.lockTimeout = lockTimeout;
        return this;
    }

    public Boolean getWaitForSync() {
        return this.waitForSync;
    }

    public TransactionOptions waitForSync(Boolean waitForSync) {
        this.waitForSync = waitForSync;
        return this;
    }

    public TransactionOptions readCollections(String ... read) {
        this.collections.read(read);
        return this;
    }

    public TransactionOptions writeCollections(String ... write) {
        this.collections.write(write);
        return this;
    }

    public TransactionOptions allowImplicit(Boolean allowImplicit) {
        this.collections.allowImplicit(allowImplicit);
        return this;
    }

    public Long getMaxTransactionSize() {
        return this.maxTransactionSize;
    }

    public TransactionOptions maxTransactionSize(Long maxTransactionSize) {
        this.maxTransactionSize = maxTransactionSize;
        return this;
    }

    public Long getIntermediateCommitCount() {
        return this.intermediateCommitCount;
    }

    public TransactionOptions intermediateCommitCount(Long intermediateCommitCount) {
        this.intermediateCommitCount = intermediateCommitCount;
        return this;
    }

    public Long getIntermediateCommitSize() {
        return this.intermediateCommitSize;
    }

    public TransactionOptions intermediateCommitSize(Long intermediateCommitSize) {
        this.intermediateCommitSize = intermediateCommitSize;
        return this;
    }

    public static class TransactionCollectionOptions {
        private Collection<String> read;
        private Collection<String> write;
        private Boolean allowImplicit;

        public Collection<String> getRead() {
            return this.read;
        }

        public TransactionCollectionOptions read(String ... read) {
            this.read = Arrays.asList(read);
            return this;
        }

        public Collection<String> getWrite() {
            return this.write;
        }

        public TransactionCollectionOptions write(String ... write) {
            this.write = Arrays.asList(write);
            return this;
        }

        public Boolean getAllowImplicit() {
            return this.allowImplicit;
        }

        public TransactionCollectionOptions allowImplicit(Boolean allowImplicit) {
            this.allowImplicit = allowImplicit;
            return this;
        }
    }
}

