/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocypack;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.DocumentField;
import com.arangodb.entity.LogLevel;
import com.arangodb.entity.MinReplicationFactor;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.ArangoSearchCompression;
import com.arangodb.entity.arangosearch.ArangoSearchProperties;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.ConsolidationType;
import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.entity.arangosearch.PrimarySort;
import com.arangodb.entity.arangosearch.StoreValuesType;
import com.arangodb.entity.arangosearch.StoredValue;
import com.arangodb.internal.velocystream.internal.AuthenticationRequest;
import com.arangodb.model.CollectionSchema;
import com.arangodb.model.TraversalOptions;
import com.arangodb.model.arangosearch.ArangoSearchPropertiesOptions;
import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocystream.Request;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class VPackSerializers {
    public static final VPackSerializer<Request> REQUEST = (builder, attribute, value, context) -> {
        builder.add(attribute, ValueType.ARRAY);
        builder.add(Integer.valueOf(value.getVersion()));
        builder.add(Integer.valueOf(value.getType()));
        builder.add(value.getDatabase());
        builder.add(Integer.valueOf(value.getRequestType().getType()));
        builder.add(value.getRequest());
        builder.add(ValueType.OBJECT);
        for (Map.Entry<String, String> entry : value.getQueryParam().entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        builder.close();
        builder.add(ValueType.OBJECT);
        for (Map.Entry<String, String> entry : value.getHeaderParam().entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        builder.close();
        builder.close();
    };
    public static final VPackSerializer<AuthenticationRequest> AUTH_REQUEST = (builder, attribute, value, context) -> {
        builder.add(attribute, ValueType.ARRAY);
        builder.add(Integer.valueOf(value.getVersion()));
        builder.add(Integer.valueOf(value.getType()));
        builder.add(value.getEncryption());
        builder.add(value.getUser());
        builder.add(value.getPassword());
        builder.close();
    };
    public static final VPackSerializer<CollectionType> COLLECTION_TYPE = (builder, attribute, value, context) -> builder.add(attribute, Integer.valueOf(value.getType()));
    public static final VPackSerializer<BaseDocument> BASE_DOCUMENT = (builder, attribute, value, context) -> {
        HashMap<String, Object> doc = new HashMap<String, Object>(value.getProperties());
        doc.put(DocumentField.Type.ID.getSerializeName(), value.getId());
        doc.put(DocumentField.Type.KEY.getSerializeName(), value.getKey());
        doc.put(DocumentField.Type.REV.getSerializeName(), value.getRevision());
        context.serialize(builder, attribute, doc);
    };
    public static final VPackSerializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = (builder, attribute, value, context) -> {
        HashMap<String, Object> doc = new HashMap<String, Object>(value.getProperties());
        doc.put(DocumentField.Type.ID.getSerializeName(), value.getId());
        doc.put(DocumentField.Type.KEY.getSerializeName(), value.getKey());
        doc.put(DocumentField.Type.REV.getSerializeName(), value.getRevision());
        doc.put(DocumentField.Type.FROM.getSerializeName(), value.getFrom());
        doc.put(DocumentField.Type.TO.getSerializeName(), value.getTo());
        context.serialize(builder, attribute, doc);
    };
    public static final VPackSerializer<TraversalOptions.Order> TRAVERSAL_ORDER = (builder, attribute, value, context) -> {
        if (TraversalOptions.Order.preorder_expander == value) {
            builder.add(attribute, "preorder-expander");
        } else {
            builder.add(attribute, value.name());
        }
    };
    public static final VPackSerializer<LogLevel> LOG_LEVEL = (builder, attribute, value, context) -> builder.add(attribute, Integer.valueOf(value.getLevel()));
    public static final VPackSerializer<Permissions> PERMISSIONS = (builder, attribute, value, context) -> builder.add(attribute, value.toString().toLowerCase());
    public static final VPackSerializer<ReplicationFactor> REPLICATION_FACTOR = (builder, attribute, value, context) -> {
        Boolean satellite = value.getSatellite();
        if (Boolean.TRUE == satellite) {
            builder.add(attribute, "satellite");
        } else if (value.getReplicationFactor() != null) {
            builder.add(attribute, value.getReplicationFactor());
        }
    };
    public static final VPackSerializer<MinReplicationFactor> MIN_REPLICATION_FACTOR = (builder, attribute, value, context) -> {
        if (value.getMinReplicationFactor() != null) {
            builder.add(attribute, value.getMinReplicationFactor());
        }
    };
    public static final VPackSerializer<ViewType> VIEW_TYPE = (builder, attribute, value, context) -> {
        String type = value == ViewType.ARANGO_SEARCH ? "arangosearch" : value.name().toLowerCase();
        builder.add(attribute, type);
    };
    public static final VPackSerializer<ArangoSearchPropertiesOptions> ARANGO_SEARCH_PROPERTIES_OPTIONS = (builder, attribute, value, context) -> {
        builder.add(ValueType.OBJECT);
        context.serialize(builder, attribute, (Object)value.getProperties());
        builder.close();
    };
    public static final VPackSerializer<ArangoSearchProperties> ARANGO_SEARCH_PROPERTIES = (builder, attribute, value, context) -> {
        Collection<StoredValue> storedValues;
        ArangoSearchCompression arangoSearchCompression;
        Collection<PrimarySort> primarySorts;
        Long cleanupIntervalStep;
        Long commitIntervalMsec;
        Long consolidationIntervalMsec = value.getConsolidationIntervalMsec();
        if (consolidationIntervalMsec != null) {
            builder.add("consolidationIntervalMsec", consolidationIntervalMsec);
        }
        if ((commitIntervalMsec = value.getCommitIntervalMsec()) != null) {
            builder.add("commitIntervalMsec", commitIntervalMsec);
        }
        if ((cleanupIntervalStep = value.getCleanupIntervalStep()) != null) {
            builder.add("cleanupIntervalStep", cleanupIntervalStep);
        }
        context.serialize(builder, "consolidationPolicy", (Object)value.getConsolidationPolicy());
        Collection<CollectionLink> links = value.getLinks();
        if (!links.isEmpty()) {
            builder.add("links", ValueType.OBJECT);
            for (CollectionLink collectionLink : links) {
                StoreValuesType storeValues;
                Boolean trackListPositions;
                Boolean includeAllFields;
                builder.add(collectionLink.getName(), ValueType.OBJECT);
                Collection<String> analyzers = collectionLink.getAnalyzers();
                if (!analyzers.isEmpty()) {
                    builder.add("analyzers", ValueType.ARRAY);
                    for (String analyzer : analyzers) {
                        builder.add(analyzer);
                    }
                    builder.close();
                }
                if ((includeAllFields = collectionLink.getIncludeAllFields()) != null) {
                    builder.add("includeAllFields", includeAllFields);
                }
                if ((trackListPositions = collectionLink.getTrackListPositions()) != null) {
                    builder.add("trackListPositions", trackListPositions);
                }
                if ((storeValues = collectionLink.getStoreValues()) != null) {
                    builder.add("storeValues", storeValues.name().toLowerCase());
                }
                VPackSerializers.serializeFieldLinks(builder, collectionLink.getFields());
                builder.close();
            }
            builder.close();
        }
        if (!(primarySorts = value.getPrimarySort()).isEmpty()) {
            builder.add("primarySort", ValueType.ARRAY);
            for (PrimarySort primarySort : primarySorts) {
                builder.add(ValueType.OBJECT);
                builder.add("field", primarySort.getFieldName());
                builder.add("asc", primarySort.getAscending());
                builder.close();
            }
            builder.close();
        }
        if ((arangoSearchCompression = value.getPrimarySortCompression()) != null) {
            builder.add("primarySortCompression", arangoSearchCompression.getValue());
        }
        if (!(storedValues = value.getStoredValues()).isEmpty()) {
            builder.add("storedValues", ValueType.ARRAY);
            for (StoredValue storedValue : storedValues) {
                builder.add(ValueType.OBJECT);
                builder.add("fields", ValueType.ARRAY);
                for (String field : storedValue.getFields()) {
                    builder.add(field);
                }
                builder.close();
                builder.add("compression", storedValue.getCompression().getValue());
                builder.close();
            }
            builder.close();
        }
    };
    public static final VPackSerializer<ConsolidationType> CONSOLIDATE_TYPE = (builder, attribute, value, context) -> builder.add(attribute, value.toString().toLowerCase());
    public static final VPackSerializer<CollectionSchema> COLLECTION_VALIDATION = (builder, attribute, value, context) -> {
        VPackParser parser = new VPackParser.Builder().build();
        VPackSlice rule = parser.fromJson(value.getRule(), true);
        HashMap<String, String> doc = new HashMap<String, String>();
        doc.put("message", value.getMessage());
        doc.put("level", value.getLevel().getValue());
        doc.put("rule", (String)rule);
        context.serialize(builder, attribute, doc);
    };

    private static void serializeFieldLinks(VPackBuilder builder, Collection<FieldLink> links) {
        if (!links.isEmpty()) {
            builder.add("fields", ValueType.OBJECT);
            for (FieldLink fieldLink : links) {
                StoreValuesType storeValues;
                Boolean trackListPositions;
                Boolean includeAllFields;
                builder.add(fieldLink.getName(), ValueType.OBJECT);
                Collection<String> analyzers = fieldLink.getAnalyzers();
                if (!analyzers.isEmpty()) {
                    builder.add("analyzers", ValueType.ARRAY);
                    for (String analyzer : analyzers) {
                        builder.add(analyzer);
                    }
                    builder.close();
                }
                if ((includeAllFields = fieldLink.getIncludeAllFields()) != null) {
                    builder.add("includeAllFields", includeAllFields);
                }
                if ((trackListPositions = fieldLink.getTrackListPositions()) != null) {
                    builder.add("trackListPositions", trackListPositions);
                }
                if ((storeValues = fieldLink.getStoreValues()) != null) {
                    builder.add("storeValues", storeValues.name().toLowerCase());
                }
                VPackSerializers.serializeFieldLinks(builder, fieldLink.getFields());
                builder.close();
            }
            builder.close();
        }
    }
}

