/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.internal.util.ResponseUtils;
import com.arangodb.internal.velocystream.internal.Chunk;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.internal.velocystream.internal.VstConnection;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VstCommunication<R, C extends VstConnection>
implements Closeable {
    protected static final String ENCRYPTION_PLAIN = "plain";
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunication.class);
    protected static final AtomicLong mId = new AtomicLong(0L);
    protected final ArangoSerialization util;
    protected final String user;
    protected final String password;
    protected final Integer chunksize;
    protected final HostHandler hostHandler;

    protected VstCommunication(Integer timeout, String user, String password, Boolean useSsl, SSLContext sslContext, ArangoSerialization util, Integer chunksize, HostHandler hostHandler) {
        this.user = user;
        this.password = password;
        this.util = util;
        this.hostHandler = hostHandler;
        this.chunksize = chunksize != null ? chunksize : 30000;
    }

    protected synchronized C connect(HostHandle hostHandle, AccessType accessType) {
        Host host = this.hostHandler.get(hostHandle, accessType);
        while (true) {
            if (host == null) {
                this.hostHandler.reset();
                throw new ArangoDBException("Was not able to connect to any host");
            }
            VstConnection connection = (VstConnection)host.connection();
            if (connection.isOpen()) {
                return (C)connection;
            }
            try {
                connection.open();
                this.hostHandler.success();
                if (this.user != null) {
                    this.tryAuthenticate(connection);
                }
                this.hostHandler.confirm();
                return (C)connection;
            }
            catch (IOException e) {
                this.hostHandler.fail();
                if (hostHandle != null && hostHandle.getHost() != null) {
                    hostHandle.setHost(null);
                }
                Host failedHost = host;
                host = this.hostHandler.get(hostHandle, accessType);
                if (host != null) {
                    LOGGER.warn(String.format("Could not connect to %s", failedHost.getDescription()), (Throwable)e);
                    LOGGER.warn(String.format("Could not connect to %s or SSL Handshake failed. Try connecting to %s", failedHost.getDescription(), host.getDescription()));
                    continue;
                }
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ArangoDBException(e);
            }
            break;
        }
    }

    private void tryAuthenticate(C connection) {
        try {
            this.authenticate(connection);
        }
        catch (ArangoDBException authException) {
            ((VstConnection)connection).close();
            throw authException;
        }
    }

    protected abstract void authenticate(C var1);

    @Override
    public void close() throws IOException {
        this.hostHandler.close();
    }

    public R execute(Request request, HostHandle hostHandle) throws ArangoDBException {
        C connection = this.connect(hostHandle, RequestUtils.determineAccessType(request));
        return this.execute(request, connection);
    }

    protected abstract R execute(Request var1, C var2) throws ArangoDBException;

    protected void checkError(Response response) throws ArangoDBException {
        ResponseUtils.checkError(this.util, response);
    }

    protected Response createResponse(Message message) throws VPackParserException {
        Response response = (Response)this.util.deserialize(message.getHead(), (Type)((Object)Response.class));
        if (message.getBody() != null) {
            response.setBody(message.getBody());
        }
        return response;
    }

    protected final Message createMessage(Request request) throws VPackParserException {
        request.putHeaderParam("accept", "application/x-velocypack");
        request.putHeaderParam("content-type", "application/x-velocypack");
        long id = mId.incrementAndGet();
        return new Message(id, this.util.serialize(request), request.getBody());
    }

    protected Collection<Chunk> buildChunks(Message message) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        VPackSlice head = message.getHead();
        int size = head.getByteSize();
        VPackSlice body = message.getBody();
        if (body != null) {
            size += body.getByteSize();
        }
        int n = size / this.chunksize;
        int numberOfChunks = size % this.chunksize != 0 ? n + 1 : n;
        int off = 0;
        int i = 0;
        while (size > 0) {
            int len = Math.min(this.chunksize, size);
            long messageLength = i == 0 && numberOfChunks > 1 ? (long)size : -1L;
            Chunk chunk = new Chunk(message.getId(), i, numberOfChunks, messageLength, off, len);
            size -= len;
            off += len;
            chunks.add(chunk);
            ++i;
        }
        return chunks;
    }
}

