/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.entity.arangosearch;

import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.entity.arangosearch.StoreValuesType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class CollectionLink {
    private final String name;
    private final Collection<String> analyzers;
    private Boolean includeAllFields;
    private Boolean trackListPositions;
    private StoreValuesType storeValues;
    private final Collection<FieldLink> fields;

    private CollectionLink(String name) {
        this.name = name;
        this.fields = new ArrayList<FieldLink>();
        this.analyzers = new ArrayList<String>();
    }

    public static CollectionLink on(String name) {
        return new CollectionLink(name);
    }

    public CollectionLink analyzers(String ... analyzers) {
        this.analyzers.addAll(Arrays.asList(analyzers));
        return this;
    }

    public CollectionLink includeAllFields(Boolean includeAllFields) {
        this.includeAllFields = includeAllFields;
        return this;
    }

    public CollectionLink trackListPositions(Boolean trackListPositions) {
        this.trackListPositions = trackListPositions;
        return this;
    }

    public CollectionLink storeValues(StoreValuesType storeValues) {
        this.storeValues = storeValues;
        return this;
    }

    public CollectionLink fields(FieldLink ... fields) {
        this.fields.addAll(Arrays.asList(fields));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getAnalyzers() {
        return this.analyzers;
    }

    public Boolean getIncludeAllFields() {
        return this.includeAllFields;
    }

    public Boolean getTrackListPositions() {
        return this.trackListPositions;
    }

    public StoreValuesType getStoreValues() {
        return this.storeValues;
    }

    public Collection<FieldLink> getFields() {
        return this.fields;
    }
}

