/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal.velocystream;

import com.arangodb.async.internal.utils.CompletableFutureUtils;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.velocystream.internal.Chunk;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.internal.velocystream.internal.MessageStore;
import com.arangodb.internal.velocystream.internal.VstConnection;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public class VstConnectionAsync
extends VstConnection<CompletableFuture<Message>> {
    private VstConnectionAsync(HostDescription host, Integer timeout, Long ttl, Integer keepAliveInterval, Boolean useSsl, SSLContext sslContext, MessageStore messageStore) {
        super(host, timeout, ttl, keepAliveInterval, useSsl, sslContext, messageStore);
    }

    @Override
    public synchronized CompletableFuture<Message> write(Message message, Collection<Chunk> chunks) {
        CompletableFuture<Message> future = new CompletableFuture<Message>();
        FutureTask<Message> task = new FutureTask<Message>(() -> {
            try {
                future.complete(this.messageStore.get(message.getId()));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            return null;
        });
        this.messageStore.storeMessage(message.getId(), task);
        super.writeIntern(message, chunks);
        if (this.timeout == null || (long)this.timeout.intValue() == 0L) {
            return future;
        }
        return CompletableFutureUtils.orTimeout(future, this.timeout.intValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doKeepAlive() {
        ((CompletableFuture)this.sendKeepAlive()).join();
    }

    public static class Builder {
        private MessageStore messageStore;
        private HostDescription host;
        private Integer timeout;
        private Long ttl;
        private Integer keepAliveInterval;
        private Boolean useSsl;
        private SSLContext sslContext;

        public Builder messageStore(MessageStore messageStore) {
            this.messageStore = messageStore;
            return this;
        }

        public Builder host(HostDescription host) {
            this.host = host;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder keepAliveInterval(Integer keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public VstConnectionAsync build() {
            return new VstConnectionAsync(this.host, this.timeout, this.ttl, this.keepAliveInterval, this.useSsl, this.sslContext, this.messageStore);
        }
    }
}

