/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.internal.velocystream.VstCommunication;
import com.arangodb.internal.velocystream.internal.AuthenticationRequest;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.internal.velocystream.internal.VstConnectionSync;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VstCommunicationSync
extends VstCommunication<Response, VstConnectionSync> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunicationSync.class);

    protected VstCommunicationSync(HostHandler hostHandler, Integer timeout, String user, String password, Boolean useSsl, SSLContext sslContext, ArangoSerialization util, Integer chunksize, Integer maxConnections, Long ttl) {
        super(timeout, user, password, useSsl, sslContext, util, chunksize, hostHandler);
    }

    @Override
    protected Response execute(Request request, VstConnectionSync connection) throws ArangoDBException {
        try {
            Message requestMessage = this.createMessage(request);
            Message responseMessage = this.send(requestMessage, connection);
            Response response = this.createResponse(responseMessage);
            this.checkError(response);
            return response;
        }
        catch (VPackParserException e) {
            throw new ArangoDBException(e);
        }
        catch (ArangoDBRedirectException e) {
            String location = e.getLocation();
            HostDescription redirectHost = HostUtils.createFromLocation(location);
            this.hostHandler.closeCurrentOnError();
            this.hostHandler.fail();
            return (Response)this.execute(request, new HostHandle().setHost(redirectHost));
        }
    }

    private Message send(Message message, VstConnectionSync connection) throws ArangoDBException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Send Message (id=%s, head=%s, body=%s)", message.getId(), message.getHead(), message.getBody() != null ? message.getBody() : "{}"));
        }
        return connection.write(message, (Collection)this.buildChunks(message));
    }

    @Override
    protected void authenticate(VstConnectionSync connection) {
        Response response = this.execute((Request)new AuthenticationRequest(this.user, this.password != null ? this.password : "", "plain"), connection);
        this.checkError(response);
    }

    public static class Builder {
        private final HostHandler hostHandler;
        private Integer timeout;
        private Long connectionTtl;
        private String user;
        private String password;
        private Boolean useSsl;
        private SSLContext sslContext;
        private Integer chunksize;
        private Integer maxConnections;

        public Builder(HostHandler hostHandler) {
            this.hostHandler = hostHandler;
        }

        public Builder(Builder builder) {
            this(builder.hostHandler);
            this.timeout(builder.timeout).user(builder.user).password(builder.password).useSsl(builder.useSsl).sslContext(builder.sslContext).chunksize(builder.chunksize).maxConnections(builder.maxConnections);
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder chunksize(Integer chunksize) {
            this.chunksize = chunksize;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder connectionTtl(Long connectionTtl) {
            this.connectionTtl = connectionTtl;
            return this;
        }

        public VstCommunication<Response, VstConnectionSync> build(ArangoSerialization util) {
            return new VstCommunicationSync(this.hostHandler, this.timeout, this.user, this.password, this.useSsl, this.sslContext, util, this.chunksize, this.maxConnections, this.connectionTtl);
        }
    }
}

