/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.DocumentField;
import com.arangodb.entity.EdgeEntity;
import com.arangodb.entity.EdgeUpdateEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.InternalArangoGraph;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.model.EdgeCreateOptions;
import com.arangodb.model.EdgeDeleteOptions;
import com.arangodb.model.EdgeReplaceOptions;
import com.arangodb.model.EdgeUpdateOptions;
import com.arangodb.model.GraphDocumentReadOptions;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import java.lang.reflect.Type;
import java.util.HashMap;

public abstract class InternalArangoEdgeCollection<A extends InternalArangoDB<E>, D extends InternalArangoDatabase<A, E>, G extends InternalArangoGraph<A, D, E>, E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    private static final String PATH_API_GHARIAL = "/_api/gharial";
    private static final String EDGE = "edge";
    private static final String TRANSACTION_ID = "x-arango-trx-id";
    private final G graph;
    private final String name;

    protected InternalArangoEdgeCollection(G graph, String name) {
        super(((InternalArangoGraph)graph).executor, ((InternalArangoGraph)graph).util, ((InternalArangoGraph)graph).context);
        this.graph = graph;
        this.name = name;
    }

    public G graph() {
        return this.graph;
    }

    public String name() {
        return this.name;
    }

    protected <T> Request insertEdgeRequest(T value, EdgeCreateOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).dbName(), RequestType.POST, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE, this.name);
        EdgeCreateOptions params = options != null ? options : new EdgeCreateOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<EdgeEntity> insertEdgeResponseDeserializer(T value) {
        return response -> {
            VPackSlice body = response.getBody().get(EDGE);
            EdgeEntity doc = (EdgeEntity)this.util().deserialize(body, (Type)((Object)EdgeEntity.class));
            HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
            values.put(DocumentField.Type.ID, doc.getId());
            values.put(DocumentField.Type.KEY, doc.getKey());
            values.put(DocumentField.Type.REV, doc.getRev());
            this.executor.documentCache().setValues(value, values);
            return doc;
        };
    }

    protected Request getEdgeRequest(String key, GraphDocumentReadOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).dbName(), RequestType.GET, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE, DocumentUtil.createDocumentHandle(this.name, key));
        GraphDocumentReadOptions params = options != null ? options : new GraphDocumentReadOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        request.putHeaderParam("If-Match", params.getIfMatch());
        if (params.getAllowDirtyRead() == Boolean.TRUE) {
            RequestUtils.allowDirtyRead(request);
        }
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<T> getEdgeResponseDeserializer(Class<T> type) {
        return response -> this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(response.getBody().get(EDGE), type);
    }

    protected <T> Request replaceEdgeRequest(String key, T value, EdgeReplaceOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).dbName(), RequestType.PUT, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE, DocumentUtil.createDocumentHandle(this.name, key));
        EdgeReplaceOptions params = options != null ? options : new EdgeReplaceOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<EdgeUpdateEntity> replaceEdgeResponseDeserializer(T value) {
        return response -> {
            VPackSlice body = response.getBody().get(EDGE);
            EdgeUpdateEntity doc = (EdgeUpdateEntity)this.util().deserialize(body, (Type)((Object)EdgeUpdateEntity.class));
            HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
            values.put(DocumentField.Type.REV, doc.getRev());
            this.executor.documentCache().setValues(value, values);
            return doc;
        };
    }

    protected <T> Request updateEdgeRequest(String key, T value, EdgeUpdateOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).dbName(), RequestType.PATCH, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE, DocumentUtil.createDocumentHandle(this.name, key));
        EdgeUpdateOptions params = options != null ? options : new EdgeUpdateOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value, new ArangoSerializer.Options().serializeNullValues(true)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<EdgeUpdateEntity> updateEdgeResponseDeserializer(T value) {
        return response -> {
            VPackSlice body = response.getBody().get(EDGE);
            EdgeUpdateEntity doc = (EdgeUpdateEntity)this.util().deserialize(body, (Type)((Object)EdgeUpdateEntity.class));
            HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
            values.put(DocumentField.Type.REV, doc.getRev());
            this.executor.documentCache().setValues(value, values);
            return doc;
        };
    }

    protected Request deleteEdgeRequest(String key, EdgeDeleteOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).dbName(), RequestType.DELETE, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE, DocumentUtil.createDocumentHandle(this.name, key));
        EdgeDeleteOptions params = options != null ? options : new EdgeDeleteOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }
}

