/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.http;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.http.HttpConnection;
import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCommunication
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCommunication.class);
    private final HostHandler hostHandler;

    private HttpCommunication(HostHandler hostHandler) {
        this.hostHandler = hostHandler;
    }

    @Override
    public void close() throws IOException {
        this.hostHandler.close();
    }

    public Response execute(Request request, HostHandle hostHandle) throws ArangoDBException {
        return this.execute(request, hostHandle, 0);
    }

    private Response execute(Request request, HostHandle hostHandle, int attemptCount) throws ArangoDBException {
        AccessType accessType = RequestUtils.determineAccessType(request);
        Host host = this.hostHandler.get(hostHandle, accessType);
        try {
            while (true) {
                try {
                    HttpConnection connection = (HttpConnection)host.connection();
                    Response response = connection.execute(request);
                    this.hostHandler.success();
                    this.hostHandler.confirm();
                    return response;
                }
                catch (IOException e) {
                    this.hostHandler.fail(e);
                    if (hostHandle != null && hostHandle.getHost() != null) {
                        hostHandle.setHost(null);
                    }
                    Host failedHost = host;
                    host = this.hostHandler.get(hostHandle, accessType);
                    if (host != null) {
                        LOGGER.warn(String.format("Could not connect to %s", failedHost.getDescription()), (Throwable)e);
                        LOGGER.warn(String.format("Could not connect to %s. Try connecting to %s", failedHost.getDescription(), host.getDescription()));
                        continue;
                    }
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new ArangoDBException(e);
                }
                break;
            }
        }
        catch (ArangoDBException e) {
            if (e instanceof ArangoDBRedirectException && attemptCount < 3) {
                String location = ((ArangoDBRedirectException)e).getLocation();
                HostDescription redirectHost = HostUtils.createFromLocation(location);
                this.hostHandler.failIfNotMatch(redirectHost, e);
                return this.execute(request, new HostHandle().setHost(redirectHost), attemptCount + 1);
            }
            throw e;
        }
    }

    public static class Builder {
        private final HostHandler hostHandler;

        public Builder(HostHandler hostHandler) {
            this.hostHandler = hostHandler;
        }

        public Builder(Builder builder) {
            this(builder.hostHandler);
        }

        public HttpCommunication build(ArangoSerialization util) {
            return new HttpCommunication(this.hostHandler);
        }
    }
}

