/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.ReplicationFactor;
import java.util.Arrays;
import java.util.Collection;

public class GraphCreateOptions {
    private String name;
    private Collection<EdgeDefinition> edgeDefinitions;
    private Collection<String> orphanCollections;
    private Boolean isSmart;
    private SmartOptions options;

    protected String getName() {
        return this.name;
    }

    protected GraphCreateOptions name(String name) {
        this.name = name;
        return this;
    }

    public Collection<EdgeDefinition> getEdgeDefinitions() {
        return this.edgeDefinitions;
    }

    protected GraphCreateOptions edgeDefinitions(Collection<EdgeDefinition> edgeDefinitions) {
        this.edgeDefinitions = edgeDefinitions;
        return this;
    }

    public Collection<String> getOrphanCollections() {
        return this.orphanCollections;
    }

    public GraphCreateOptions orphanCollections(String ... orphanCollections) {
        this.orphanCollections = Arrays.asList(orphanCollections);
        return this;
    }

    public Boolean getIsSmart() {
        return this.isSmart;
    }

    public GraphCreateOptions isSmart(Boolean isSmart) {
        this.isSmart = isSmart;
        return this;
    }

    public Boolean getIsDisjoint() {
        return this.getOptions().getIsDisjoint();
    }

    public GraphCreateOptions isDisjoint(Boolean isDisjoint) {
        this.getOptions().setIsDisjoint(isDisjoint);
        return this;
    }

    public Integer getReplicationFactor() {
        return this.getOptions().replicationFactor.getReplicationFactor();
    }

    public GraphCreateOptions replicationFactor(Integer replicationFactor) {
        this.getOptions().replicationFactor.setReplicationFactor(replicationFactor);
        return this;
    }

    public Boolean getSatellite() {
        return this.getOptions().replicationFactor.getSatellite();
    }

    public GraphCreateOptions satellite(Boolean satellite) {
        this.getOptions().replicationFactor.setSatellite(satellite);
        return this;
    }

    public Integer getMinReplicationFactor() {
        return this.getOptions().getMinReplicationFactor();
    }

    public GraphCreateOptions minReplicationFactor(Integer minReplicationFactor) {
        this.getOptions().setMinReplicationFactor(minReplicationFactor);
        return this;
    }

    public Integer getNumberOfShards() {
        return this.getOptions().getNumberOfShards();
    }

    public GraphCreateOptions numberOfShards(Integer numberOfShards) {
        this.getOptions().setNumberOfShards(numberOfShards);
        return this;
    }

    public String getSmartGraphAttribute() {
        return this.getOptions().getSmartGraphAttribute();
    }

    public GraphCreateOptions smartGraphAttribute(String smartGraphAttribute) {
        this.getOptions().setSmartGraphAttribute(smartGraphAttribute);
        return this;
    }

    public Collection<String> getSatellites() {
        return this.getOptions().getSatellites();
    }

    public GraphCreateOptions satellites(String ... satellites) {
        this.getOptions().setSatellites(satellites);
        return this;
    }

    private SmartOptions getOptions() {
        if (this.options == null) {
            this.options = new SmartOptions();
        }
        return this.options;
    }

    public static class SmartOptions {
        private ReplicationFactor replicationFactor = new ReplicationFactor();
        private Integer minReplicationFactor;
        private Integer numberOfShards;
        private String smartGraphAttribute;
        private Boolean isDisjoint;
        private Collection<String> satellites;

        public Integer getReplicationFactor() {
            return this.replicationFactor.getReplicationFactor();
        }

        public void setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor.setReplicationFactor(replicationFactor);
        }

        public Boolean getSatellite() {
            return this.replicationFactor.getSatellite();
        }

        public void setSatellite(Boolean satellite) {
            this.replicationFactor.setSatellite(satellite);
        }

        public Integer getMinReplicationFactor() {
            return this.minReplicationFactor;
        }

        public void setMinReplicationFactor(Integer minReplicationFactor) {
            this.minReplicationFactor = minReplicationFactor;
        }

        public Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        public String getSmartGraphAttribute() {
            return this.smartGraphAttribute;
        }

        public void setSmartGraphAttribute(String smartGraphAttribute) {
            this.smartGraphAttribute = smartGraphAttribute;
        }

        public Boolean getIsDisjoint() {
            return this.isDisjoint;
        }

        public void setIsDisjoint(Boolean isDisjoint) {
            this.isDisjoint = isDisjoint;
        }

        public Collection<String> getSatellites() {
            return this.satellites;
        }

        public void setSatellites(String ... satellites) {
            this.satellites = Arrays.asList(satellites);
        }
    }
}

