/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.DbName;
import com.arangodb.entity.AqlFunctionEntity;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.DatabaseEntity;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.entity.PathEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryCachePropertiesEntity;
import com.arangodb.entity.QueryTrackingPropertiesEntity;
import com.arangodb.entity.StreamTransactionEntity;
import com.arangodb.entity.TransactionEntity;
import com.arangodb.entity.TraversalEntity;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.AnalyzerEntity;
import com.arangodb.entity.arangosearch.analyzer.SearchAnalyzer;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlFunctionDeleteOptions;
import com.arangodb.model.AqlFunctionGetOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.AqlQueryParseOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionsReadOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.StreamTransactionOptions;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.TraversalOptions;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.model.ViewCreateOptions;
import com.arangodb.model.arangosearch.AnalyzerDeleteOptions;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.model.arangosearch.ArangoSearchOptionsBuilder;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class InternalArangoDatabase<A extends InternalArangoDB<EXECUTOR>, EXECUTOR extends ArangoExecutor>
extends ArangoExecuteable<EXECUTOR> {
    protected static final String PATH_API_DATABASE = "/_api/database";
    private static final String PATH_API_VERSION = "/_api/version";
    private static final String PATH_API_ENGINE = "/_api/engine";
    private static final String PATH_API_CURSOR = "/_api/cursor";
    private static final String PATH_API_TRANSACTION = "/_api/transaction";
    private static final String PATH_API_BEGIN_STREAM_TRANSACTION = "/_api/transaction/begin";
    private static final String PATH_API_AQLFUNCTION = "/_api/aqlfunction";
    private static final String PATH_API_EXPLAIN = "/_api/explain";
    private static final String PATH_API_QUERY = "/_api/query";
    private static final String PATH_API_QUERY_CACHE = "/_api/query-cache";
    private static final String PATH_API_QUERY_CACHE_PROPERTIES = "/_api/query-cache/properties";
    private static final String PATH_API_QUERY_PROPERTIES = "/_api/query/properties";
    private static final String PATH_API_QUERY_CURRENT = "/_api/query/current";
    private static final String PATH_API_QUERY_SLOW = "/_api/query/slow";
    private static final String PATH_API_TRAVERSAL = "/_api/traversal";
    private static final String PATH_API_ADMIN_ROUTING_RELOAD = "/_admin/routing/reload";
    private static final String PATH_API_USER = "/_api/user";
    private static final String TRANSACTION_ID = "x-arango-trx-id";
    private final DbName dbName;
    private final A arango;

    protected InternalArangoDatabase(A arango, DbName dbName) {
        super(((InternalArangoDB)arango).executor, ((InternalArangoDB)arango).util, ((InternalArangoDB)arango).context);
        this.arango = arango;
        this.dbName = dbName;
    }

    public A arango() {
        return this.arango;
    }

    public DbName dbName() {
        return this.dbName;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getDatabaseResponseDeserializer() {
        return ((InternalArangoDB)this.arango).getDatabaseResponseDeserializer();
    }

    protected Request getAccessibleDatabasesRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_DATABASE, "user");
    }

    protected Request getVersionRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_VERSION);
    }

    protected Request getEngineRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_ENGINE);
    }

    protected Request createCollectionRequest(String name, CollectionCreateOptions options) {
        VPackSlice body = this.util().serialize(OptionsBuilder.build(options != null ? options : new CollectionCreateOptions(), name));
        return this.request(this.dbName, RequestType.POST, "/_api/collection").setBody(body);
    }

    protected Request getCollectionsRequest(CollectionsReadOptions options) {
        Request request = this.request(this.dbName, RequestType.GET, "/_api/collection");
        CollectionsReadOptions params = options != null ? options : new CollectionsReadOptions();
        request.putQueryParam("excludeSystem", params.getExcludeSystem());
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<CollectionEntity>> getCollectionsResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            return (Collection)this.util().deserialize(result, new Type<Collection<CollectionEntity>>(){}.getType());
        };
    }

    protected Request dropRequest() {
        return this.request(DbName.SYSTEM, RequestType.DELETE, PATH_API_DATABASE, this.dbName.get());
    }

    protected ArangoExecutor.ResponseDeserializer<Boolean> createDropResponseDeserializer() {
        return response -> response.getBody().get("result").getAsBoolean();
    }

    protected Request grantAccessRequest(String user, Permissions permissions) {
        return this.request(DbName.SYSTEM, RequestType.PUT, PATH_API_USER, user, "database", this.dbName.get()).setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request resetAccessRequest(String user) {
        return this.request(DbName.SYSTEM, RequestType.DELETE, PATH_API_USER, user, "database", this.dbName.get());
    }

    protected Request updateUserDefaultCollectionAccessRequest(String user, Permissions permissions) {
        return this.request(DbName.SYSTEM, RequestType.PUT, PATH_API_USER, user, "database", this.dbName.get(), "*").setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request getPermissionsRequest(String user) {
        return this.request(DbName.SYSTEM, RequestType.GET, PATH_API_USER, user, "database", this.dbName.get());
    }

    protected ArangoExecutor.ResponseDeserializer<Permissions> getPermissionsResponseDeserialzer() {
        return response -> {
            VPackSlice result;
            VPackSlice body = response.getBody();
            if (body != null && !(result = body.get("result")).isNone()) {
                return (Permissions)((Object)((Object)this.util().deserialize(result, (java.lang.reflect.Type)((Object)Permissions.class))));
            }
            return null;
        };
    }

    protected Request queryRequest(String query, Map<String, Object> bindVars, AqlQueryOptions options) {
        AqlQueryOptions opt = options != null ? options : new AqlQueryOptions();
        Request request = this.request(this.dbName, RequestType.POST, PATH_API_CURSOR).setBody(this.util().serialize(OptionsBuilder.build(opt, query, bindVars != null ? this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(bindVars, new ArangoSerializer.Options().serializeNullValues(true)) : null)));
        if (opt.getAllowDirtyRead() == Boolean.TRUE) {
            RequestUtils.allowDirtyRead(request);
        }
        request.putHeaderParam(TRANSACTION_ID, opt.getStreamTransactionId());
        return request;
    }

    protected Request queryNextRequest(String id, AqlQueryOptions options, Map<String, String> meta) {
        AqlQueryOptions opt;
        Request request = this.request(this.dbName, RequestType.POST, PATH_API_CURSOR, id);
        if (meta != null) {
            request.getHeaderParam().putAll(meta);
        }
        AqlQueryOptions aqlQueryOptions = opt = options != null ? options : new AqlQueryOptions();
        if (opt.getAllowDirtyRead() == Boolean.TRUE) {
            RequestUtils.allowDirtyRead(request);
        }
        request.putHeaderParam(TRANSACTION_ID, opt.getStreamTransactionId());
        return request;
    }

    protected Request queryCloseRequest(String id, AqlQueryOptions options, Map<String, String> meta) {
        AqlQueryOptions opt;
        Request request = this.request(this.dbName, RequestType.DELETE, PATH_API_CURSOR, id);
        if (meta != null) {
            request.getHeaderParam().putAll(meta);
        }
        AqlQueryOptions aqlQueryOptions = opt = options != null ? options : new AqlQueryOptions();
        if (opt.getAllowDirtyRead() == Boolean.TRUE) {
            RequestUtils.allowDirtyRead(request);
        }
        request.putHeaderParam(TRANSACTION_ID, opt.getStreamTransactionId());
        return request;
    }

    protected Request explainQueryRequest(String query, Map<String, Object> bindVars, AqlQueryExplainOptions options) {
        AqlQueryExplainOptions opt = options != null ? options : new AqlQueryExplainOptions();
        return this.request(this.dbName, RequestType.POST, PATH_API_EXPLAIN).setBody(this.util().serialize(OptionsBuilder.build(opt, query, bindVars != null ? this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(bindVars, new ArangoSerializer.Options().serializeNullValues(true)) : null)));
    }

    protected Request parseQueryRequest(String query) {
        return this.request(this.dbName, RequestType.POST, PATH_API_QUERY).setBody(this.util().serialize(OptionsBuilder.build(new AqlQueryParseOptions(), query)));
    }

    protected Request clearQueryCacheRequest() {
        return this.request(this.dbName, RequestType.DELETE, PATH_API_QUERY_CACHE);
    }

    protected Request getQueryCachePropertiesRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_QUERY_CACHE_PROPERTIES);
    }

    protected Request setQueryCachePropertiesRequest(QueryCachePropertiesEntity properties) {
        return this.request(this.dbName, RequestType.PUT, PATH_API_QUERY_CACHE_PROPERTIES).setBody(this.util().serialize(properties));
    }

    protected Request getQueryTrackingPropertiesRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_QUERY_PROPERTIES);
    }

    protected Request setQueryTrackingPropertiesRequest(QueryTrackingPropertiesEntity properties) {
        return this.request(this.dbName, RequestType.PUT, PATH_API_QUERY_PROPERTIES).setBody(this.util().serialize(properties));
    }

    protected Request getCurrentlyRunningQueriesRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_QUERY_CURRENT);
    }

    protected Request getSlowQueriesRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_QUERY_SLOW);
    }

    protected Request clearSlowQueriesRequest() {
        return this.request(this.dbName, RequestType.DELETE, PATH_API_QUERY_SLOW);
    }

    protected Request killQueryRequest(String id) {
        return this.request(this.dbName, RequestType.DELETE, PATH_API_QUERY, id);
    }

    protected Request createAqlFunctionRequest(String name, String code, AqlFunctionCreateOptions options) {
        return this.request(this.dbName, RequestType.POST, PATH_API_AQLFUNCTION).setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new AqlFunctionCreateOptions(), name, code)));
    }

    protected Request deleteAqlFunctionRequest(String name, AqlFunctionDeleteOptions options) {
        Request request = this.request(this.dbName, RequestType.DELETE, PATH_API_AQLFUNCTION, name);
        AqlFunctionDeleteOptions params = options != null ? options : new AqlFunctionDeleteOptions();
        request.putQueryParam("group", params.getGroup());
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Integer> deleteAqlFunctionResponseDeserializer() {
        return response -> {
            VPackSlice deletedCount;
            Integer count = null;
            VPackSlice body = response.getBody();
            if (body.isObject() && (deletedCount = body.get("deletedCount")).isInteger()) {
                count = deletedCount.getAsInt();
            }
            return count;
        };
    }

    protected Request getAqlFunctionsRequest(AqlFunctionGetOptions options) {
        Request request = this.request(this.dbName, RequestType.GET, PATH_API_AQLFUNCTION);
        AqlFunctionGetOptions params = options != null ? options : new AqlFunctionGetOptions();
        request.putQueryParam("namespace", params.getNamespace());
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<AqlFunctionEntity>> getAqlFunctionsResponseDeserializer() {
        return response -> {
            VPackSlice body = response.getBody();
            VPackSlice result = body.isArray() ? body : body.get("result");
            return (Collection)this.util().deserialize(result, new Type<Collection<AqlFunctionEntity>>(){}.getType());
        };
    }

    protected Request createGraphRequest(String name, Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return this.request(this.dbName, RequestType.POST, "/_api/gharial").setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new GraphCreateOptions(), name, edgeDefinitions)));
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> createGraphResponseDeserializer() {
        return response -> (GraphEntity)this.util().deserialize(response.getBody().get("graph"), (java.lang.reflect.Type)((Object)GraphEntity.class));
    }

    protected Request getGraphsRequest() {
        return this.request(this.dbName, RequestType.GET, "/_api/gharial");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<GraphEntity>> getGraphsResponseDeserializer() {
        return response -> (Collection)this.util().deserialize(response.getBody().get("graphs"), new Type<Collection<GraphEntity>>(){}.getType());
    }

    protected Request transactionRequest(String action, TransactionOptions options) {
        return this.request(this.dbName, RequestType.POST, PATH_API_TRANSACTION).setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new TransactionOptions(), action)));
    }

    protected <T> ArangoExecutor.ResponseDeserializer<T> transactionResponseDeserializer(Class<T> type) {
        return response -> {
            VPackSlice result;
            VPackSlice body = response.getBody();
            if (body != null && !(result = body.get("result")).isNone() && !result.isNull()) {
                return this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(result, type);
            }
            return null;
        };
    }

    protected Request beginStreamTransactionRequest(StreamTransactionOptions options) {
        return this.request(this.dbName, RequestType.POST, PATH_API_BEGIN_STREAM_TRANSACTION).setBody(this.util().serialize(options != null ? options : new StreamTransactionOptions()));
    }

    protected Request abortStreamTransactionRequest(String id) {
        return this.request(this.dbName, RequestType.DELETE, PATH_API_TRANSACTION, id);
    }

    protected Request getStreamTransactionsRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_TRANSACTION);
    }

    protected Request getStreamTransactionRequest(String id) {
        return this.request(this.dbName, RequestType.GET, PATH_API_TRANSACTION, id);
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<TransactionEntity>> transactionsResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("transactions");
            return (Collection)this.util().deserialize(result, new Type<Collection<TransactionEntity>>(){}.getType());
        };
    }

    protected Request commitStreamTransactionRequest(String id) {
        return this.request(this.dbName, RequestType.PUT, PATH_API_TRANSACTION, id);
    }

    protected ArangoExecutor.ResponseDeserializer<StreamTransactionEntity> streamTransactionResponseDeserializer() {
        return response -> (StreamTransactionEntity)this.util().deserialize(response.getBody().get("result"), (java.lang.reflect.Type)((Object)StreamTransactionEntity.class));
    }

    protected Request getInfoRequest() {
        return this.request(this.dbName, RequestType.GET, PATH_API_DATABASE, "current");
    }

    protected ArangoExecutor.ResponseDeserializer<DatabaseEntity> getInfoResponseDeserializer() {
        return response -> (DatabaseEntity)this.util().deserialize(response.getBody().get("result"), (java.lang.reflect.Type)((Object)DatabaseEntity.class));
    }

    protected Request executeTraversalRequest(TraversalOptions options) {
        return this.request(this.dbName, RequestType.POST, PATH_API_TRAVERSAL).setBody(this.util().serialize(options != null ? options : new TransactionOptions()));
    }

    protected <E, V> ArangoExecutor.ResponseDeserializer<TraversalEntity<V, E>> executeTraversalResponseDeserializer(Class<V> vertexClass, Class<E> edgeClass) {
        return response -> {
            TraversalEntity result = new TraversalEntity();
            VPackSlice visited = response.getBody().get("result").get("visited");
            result.setVertices(this.deserializeVertices(vertexClass, visited));
            ArrayList paths = new ArrayList();
            Iterator iterator = visited.get("paths").arrayIterator();
            while (iterator.hasNext()) {
                PathEntity path = new PathEntity();
                VPackSlice next = (VPackSlice)iterator.next();
                path.setEdges(this.deserializeEdges(edgeClass, next));
                path.setVertices(this.deserializeVertices(vertexClass, next));
                paths.add(path);
            }
            result.setPaths(paths);
            return result;
        };
    }

    protected <V> Collection<V> deserializeVertices(Class<V> vertexClass, VPackSlice vpack) throws VPackException {
        ArrayList vertices = new ArrayList();
        Iterator iterator = vpack.get("vertices").arrayIterator();
        while (iterator.hasNext()) {
            vertices.add(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize((VPackSlice)iterator.next(), vertexClass));
        }
        return vertices;
    }

    protected <E> Collection<E> deserializeEdges(Class<E> edgeClass, VPackSlice next) throws VPackException {
        ArrayList edges = new ArrayList();
        Iterator iteratorEdge = next.get("edges").arrayIterator();
        while (iteratorEdge.hasNext()) {
            edges.add(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize((VPackSlice)iteratorEdge.next(), edgeClass));
        }
        return edges;
    }

    protected Request reloadRoutingRequest() {
        return this.request(this.dbName, RequestType.POST, PATH_API_ADMIN_ROUTING_RELOAD);
    }

    protected Request getViewsRequest() {
        return this.request(this.dbName, RequestType.GET, "/_api/view");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<ViewEntity>> getViewsResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            return (Collection)this.util().deserialize(result, new Type<Collection<ViewEntity>>(){}.getType());
        };
    }

    protected Request createViewRequest(String name, ViewType type) {
        return this.request(this.dbName, RequestType.POST, "/_api/view").setBody(this.util().serialize(OptionsBuilder.build(new ViewCreateOptions(), name, type)));
    }

    protected Request createArangoSearchRequest(String name, ArangoSearchCreateOptions options) {
        return this.request(this.dbName, RequestType.POST, "/_api/view").setBody(this.util().serialize(ArangoSearchOptionsBuilder.build(options != null ? options : new ArangoSearchCreateOptions(), name)));
    }

    protected Request getAnalyzerRequest(String name) {
        return this.request(this.dbName, RequestType.GET, "/_api/analyzer", name);
    }

    protected Request getAnalyzersRequest() {
        return this.request(this.dbName, RequestType.GET, "/_api/analyzer");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<AnalyzerEntity>> getAnalyzersResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            return (Collection)this.util().deserialize(result, new Type<Collection<AnalyzerEntity>>(){}.getType());
        };
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<SearchAnalyzer>> getSearchAnalyzersResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            return (Collection)this.util().deserialize(result, new Type<Collection<SearchAnalyzer>>(){}.getType());
        };
    }

    protected Request createAnalyzerRequest(AnalyzerEntity options) {
        return this.request(this.dbName, RequestType.POST, "/_api/analyzer").setBody(this.util().serialize(options));
    }

    protected Request createAnalyzerRequest(SearchAnalyzer options) {
        return this.request(this.dbName, RequestType.POST, "/_api/analyzer").setBody(this.util().serialize(options));
    }

    protected Request deleteAnalyzerRequest(String name, AnalyzerDeleteOptions options) {
        Request request = this.request(this.dbName, RequestType.DELETE, "/_api/analyzer", name);
        request.putQueryParam("force", options != null ? options.getForce() : null);
        return request;
    }
}

