/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDBException;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CollectionPropertiesEntity;
import com.arangodb.entity.CollectionRevisionEntity;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentImportEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.InvertedIndexEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ShardEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.InternalArangoCollection;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.model.CollectionCountOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionPropertiesOptions;
import com.arangodb.model.CollectionTruncateOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentExistsOptions;
import com.arangodb.model.DocumentImportOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.HashIndexOptions;
import com.arangodb.model.InvertedIndexOptions;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.SkiplistIndexOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.model.ZKDIndexOptions;
import com.arangodb.velocypack.VPackSlice;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoCollectionImpl
extends InternalArangoCollection<ArangoDBImpl, ArangoDatabaseImpl, ArangoExecutorSync>
implements ArangoCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoCollection.class);

    protected ArangoCollectionImpl(ArangoDatabaseImpl db, String name) {
        super(db, name);
    }

    @Override
    public <T> DocumentCreateEntity<T> insertDocument(T value) throws ArangoDBException {
        return this.insertDocument(value, new DocumentCreateOptions());
    }

    @Override
    public <T> DocumentCreateEntity<T> insertDocument(T value, DocumentCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentRequest(value, options), this.insertDocumentResponseDeserializer(value, options));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentCreateEntity<T>> insertDocuments(Collection<T> values) throws ArangoDBException {
        return this.insertDocuments(values, new DocumentCreateOptions());
    }

    @Override
    public <T> MultiDocumentEntity<DocumentCreateEntity<T>> insertDocuments(Collection<T> values, DocumentCreateOptions options) throws ArangoDBException {
        DocumentCreateOptions params = options != null ? options : new DocumentCreateOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentsRequest(values, params), this.insertDocumentsResponseDeserializer(values, params));
    }

    @Override
    public DocumentImportEntity importDocuments(Collection<?> values) throws ArangoDBException {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    @Override
    public DocumentImportEntity importDocuments(Collection<?> values, DocumentImportOptions options) throws ArangoDBException {
        return (DocumentImportEntity)((ArangoExecutorSync)this.executor).execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public DocumentImportEntity importDocuments(String values) throws ArangoDBException {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    @Override
    public DocumentImportEntity importDocuments(String values, DocumentImportOptions options) throws ArangoDBException {
        return (DocumentImportEntity)((ArangoExecutorSync)this.executor).execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public <T> T getDocument(String key, Class<T> type) throws ArangoDBException {
        return this.getDocument(key, type, new DocumentReadOptions());
    }

    @Override
    public <T> T getDocument(String key, Class<T> type, DocumentReadOptions options) throws ArangoDBException {
        DocumentUtil.validateDocumentKey(key);
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getDocumentRequest(key, options), type);
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if (e.getErrorNum() != null && e.getErrorNum() == 1655) {
                throw e;
            }
            if (!(e.getResponseCode() == null || e.getResponseCode() != 404 && e.getResponseCode() != 304 && e.getResponseCode() != 412 || options != null && !options.isCatchException())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public <T> MultiDocumentEntity<T> getDocuments(Collection<String> keys, Class<T> type) throws ArangoDBException {
        return this.getDocuments(keys, type, new DocumentReadOptions());
    }

    @Override
    public <T> MultiDocumentEntity<T> getDocuments(Collection<String> keys, Class<T> type, DocumentReadOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getDocumentsRequest(keys, options), this.getDocumentsResponseDeserializer(type, options));
    }

    @Override
    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value) throws ArangoDBException {
        return this.replaceDocument(key, value, new DocumentReplaceOptions());
    }

    @Override
    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value, DocumentReplaceOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentRequest(key, value, options), this.replaceDocumentResponseDeserializer(value, options));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> replaceDocuments(Collection<T> values) throws ArangoDBException {
        return this.replaceDocuments(values, new DocumentReplaceOptions());
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> replaceDocuments(Collection<T> values, DocumentReplaceOptions options) throws ArangoDBException {
        DocumentReplaceOptions params = options != null ? options : new DocumentReplaceOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentsRequest(values, params), this.replaceDocumentsResponseDeserializer(values, params));
    }

    @Override
    public <T> DocumentUpdateEntity<T> updateDocument(String key, T value) throws ArangoDBException {
        return this.updateDocument(key, value, new DocumentUpdateOptions());
    }

    @Override
    public <T> DocumentUpdateEntity<T> updateDocument(String key, T value, DocumentUpdateOptions options) throws ArangoDBException {
        return this.updateDocument(key, value, options, value.getClass());
    }

    @Override
    public <T, U> DocumentUpdateEntity<U> updateDocument(String key, T value, DocumentUpdateOptions options, Class<U> returnType) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateDocumentRequest(key, value, options), this.updateDocumentResponseDeserializer(value, options, returnType));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> updateDocuments(Collection<T> values) throws ArangoDBException {
        return this.updateDocuments(values, new DocumentUpdateOptions());
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> updateDocuments(Collection<T> values, DocumentUpdateOptions options) throws ArangoDBException {
        return this.updateDocuments(values, options, values.isEmpty() ? null : values.iterator().next().getClass());
    }

    @Override
    public <T, U> MultiDocumentEntity<DocumentUpdateEntity<U>> updateDocuments(Collection<T> values, DocumentUpdateOptions options, Class<U> returnType) throws ArangoDBException {
        DocumentUpdateOptions params = options != null ? options : new DocumentUpdateOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.updateDocumentsRequest(values, params), this.updateDocumentsResponseDeserializer(returnType));
    }

    @Override
    public DocumentDeleteEntity<Void> deleteDocument(String key) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentRequest(key, new DocumentDeleteOptions()), this.deleteDocumentResponseDeserializer(Void.class));
    }

    @Override
    public <T> DocumentDeleteEntity<T> deleteDocument(String key, Class<T> type, DocumentDeleteOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentRequest(key, options), this.deleteDocumentResponseDeserializer(type));
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteDocuments(Collection<?> values) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentsRequest(values, new DocumentDeleteOptions()), this.deleteDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentDeleteEntity<T>> deleteDocuments(Collection<?> values, Class<T> type, DocumentDeleteOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(type));
    }

    @Override
    public Boolean documentExists(String key) {
        return this.documentExists(key, new DocumentExistsOptions());
    }

    @Override
    public Boolean documentExists(String key, DocumentExistsOptions options) throws ArangoDBException {
        try {
            ((ArangoExecutorSync)this.executor).execute(this.documentExistsRequest(key, options), (Type)((Object)VPackSlice.class));
            return true;
        }
        catch (ArangoDBException e) {
            if (e.getErrorNum() != null && e.getErrorNum() == 1655) {
                throw e;
            }
            if (!(e.getResponseCode() == null || e.getResponseCode() != 404 && e.getResponseCode() != 304 && e.getResponseCode() != 412 || options != null && !options.isCatchException())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public IndexEntity getIndex(String id) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.getIndexRequest(id), (Type)((Object)IndexEntity.class));
    }

    @Override
    public InvertedIndexEntity getInvertedIndex(String id) throws ArangoDBException {
        return (InvertedIndexEntity)((ArangoExecutorSync)this.executor).execute(this.getIndexRequest(id), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public String deleteIndex(String id) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteIndexRequest(id), this.deleteIndexResponseDeserializer());
    }

    @Override
    @Deprecated
    public IndexEntity ensureHashIndex(Iterable<String> fields, HashIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createHashIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    @Deprecated
    public IndexEntity ensureSkiplistIndex(Iterable<String> fields, SkiplistIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createSkiplistIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensurePersistentIndex(Iterable<String> fields, PersistentIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createPersistentIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public InvertedIndexEntity ensureInvertedIndex(InvertedIndexOptions options) throws ArangoDBException {
        return (InvertedIndexEntity)((ArangoExecutorSync)this.executor).execute(this.createInvertedIndexRequest(options), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public IndexEntity ensureGeoIndex(Iterable<String> fields, GeoIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createGeoIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    @Deprecated
    public IndexEntity ensureFulltextIndex(Iterable<String> fields, FulltextIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createFulltextIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureTtlIndex(Iterable<String> fields, TtlIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createTtlIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureZKDIndex(Iterable<String> fields, ZKDIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createZKDIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public Collection<IndexEntity> getIndexes() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getIndexesRequest(), this.getIndexesResponseDeserializer());
    }

    @Override
    public Collection<InvertedIndexEntity> getInvertedIndexes() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getIndexesRequest(), this.getInvertedIndexesResponseDeserializer());
    }

    @Override
    public boolean exists() throws ArangoDBException {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public CollectionEntity truncate() throws ArangoDBException {
        return this.truncate(null);
    }

    @Override
    public CollectionEntity truncate(CollectionTruncateOptions options) throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.truncateRequest(options), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionPropertiesEntity count() throws ArangoDBException {
        return this.count(null);
    }

    @Override
    public CollectionPropertiesEntity count(CollectionCountOptions options) throws ArangoDBException {
        return (CollectionPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.countRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionEntity create() throws ArangoDBException {
        return ((ArangoDatabaseImpl)this.db()).createCollection(this.name());
    }

    @Override
    public CollectionEntity create(CollectionCreateOptions options) throws ArangoDBException {
        return ((ArangoDatabaseImpl)this.db()).createCollection(this.name(), options);
    }

    @Override
    public void drop() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(null), (Type)((Object)Void.class));
    }

    @Override
    public void drop(boolean isSystem) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(isSystem), (Type)((Object)Void.class));
    }

    @Override
    public CollectionEntity load() throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.loadRequest(), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionEntity unload() throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.unloadRequest(), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionEntity getInfo() throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.getInfoRequest(), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionPropertiesEntity getProperties() throws ArangoDBException {
        return (CollectionPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getPropertiesRequest(), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionPropertiesEntity changeProperties(CollectionPropertiesOptions options) throws ArangoDBException {
        return (CollectionPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.changePropertiesRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public synchronized CollectionEntity rename(String newName) throws ArangoDBException {
        CollectionEntity result = (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.renameRequest(newName), (Type)((Object)CollectionEntity.class));
        this.name = result.getName();
        return result;
    }

    @Override
    public ShardEntity getResponsibleShard(Object value) throws ArangoDBException {
        return (ShardEntity)((ArangoExecutorSync)this.executor).execute(this.responsibleShardRequest(value), (Type)((Object)ShardEntity.class));
    }

    @Override
    public CollectionRevisionEntity getRevision() throws ArangoDBException {
        return (CollectionRevisionEntity)((ArangoExecutorSync)this.executor).execute(this.getRevisionRequest(), (Type)((Object)CollectionRevisionEntity.class));
    }

    @Override
    public void grantAccess(String user, Permissions permissions) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public void revokeAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    @Override
    public void resetAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.resetAccessRequest(user), (Type)((Object)Void.class));
    }

    @Override
    public Permissions getPermissions(String user) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }
}

