/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.QueueTimeMetrics;
import com.arangodb.entity.Entity;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.QueueTimeMetricsImpl;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class ArangoExecutor {
    private final DocumentCache documentCache;
    private final QueueTimeMetricsImpl qtMetrics;
    private final ArangoSerializationFactory util;
    private final String timeoutS;

    protected <T> T createResult(Type type, Response response) {
        if (type != Void.class && response.getBody() != null) {
            if (this.isInternal(type)) {
                return this.util.get(ArangoSerializationFactory.Serializer.INTERNAL).deserialize(response.getBody(), type);
            }
            return this.util.get(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(response.getBody(), type);
        }
        return null;
    }

    private boolean isInternal(Type type) {
        ParameterizedType pType;
        Type rawType;
        if (type instanceof ParameterizedType && (rawType = (pType = (ParameterizedType)type).getRawType()) instanceof Class && (Map.class.isAssignableFrom((Class)rawType) || Iterable.class.isAssignableFrom((Class)rawType))) {
            for (Type arg : pType.getActualTypeArguments()) {
                if (this.isInternal(arg)) continue;
                return false;
            }
            return true;
        }
        return type instanceof Class && Entity.class.isAssignableFrom((Class)type);
    }

    protected ArangoExecutor(ArangoSerializationFactory util, DocumentCache documentCache, QueueTimeMetricsImpl qtMetrics, int timeoutMs) {
        this.documentCache = documentCache;
        this.qtMetrics = qtMetrics;
        this.util = util;
        this.timeoutS = timeoutMs >= 1000 ? Integer.toString(timeoutMs / 1000) : null;
    }

    public DocumentCache documentCache() {
        return this.documentCache;
    }

    protected final void interceptResponse(Response response) {
        String queueTime = response.getMeta().get("X-Arango-Queue-Time-Seconds");
        if (queueTime != null) {
            this.qtMetrics.add(Double.parseDouble(queueTime));
        }
    }

    protected final Request interceptRequest(Request request) {
        request.putHeaderParam("X-Arango-Queue-Time-Seconds", this.timeoutS);
        return request;
    }

    public QueueTimeMetrics getQueueTimeMetrics() {
        return this.qtMetrics;
    }

    public static interface ResponseDeserializer<T> {
        public T deserialize(Response var1) throws VPackException;
    }
}

