/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoVertexCollection;
import com.arangodb.entity.VertexEntity;
import com.arangodb.entity.VertexUpdateEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoGraphImpl;
import com.arangodb.internal.InternalArangoVertexCollection;
import com.arangodb.model.GraphDocumentReadOptions;
import com.arangodb.model.VertexCreateOptions;
import com.arangodb.model.VertexDeleteOptions;
import com.arangodb.model.VertexReplaceOptions;
import com.arangodb.model.VertexUpdateOptions;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoVertexCollectionImpl
extends InternalArangoVertexCollection<ArangoDBImpl, ArangoDatabaseImpl, ArangoGraphImpl, ArangoExecutorSync>
implements ArangoVertexCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoVertexCollectionImpl.class);

    protected ArangoVertexCollectionImpl(ArangoGraphImpl graph, String name) {
        super(graph, name);
    }

    @Override
    public void drop() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public <T> VertexEntity insertVertex(T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertVertexRequest(value, new VertexCreateOptions()), this.insertVertexResponseDeserializer(value));
    }

    @Override
    public <T> VertexEntity insertVertex(T value, VertexCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertVertexRequest(value, options), this.insertVertexResponseDeserializer(value));
    }

    @Override
    public <T> T getVertex(String key, Class<T> type) throws ArangoDBException {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getVertexRequest(key, new GraphDocumentReadOptions()), this.getVertexResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> T getVertex(String key, Class<T> type, GraphDocumentReadOptions options) throws ArangoDBException {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getVertexRequest(key, options), this.getVertexResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> VertexUpdateEntity replaceVertex(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceVertexRequest(key, value, new VertexReplaceOptions()), this.replaceVertexResponseDeserializer(value));
    }

    @Override
    public <T> VertexUpdateEntity replaceVertex(String key, T value, VertexReplaceOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceVertexRequest(key, value, options), this.replaceVertexResponseDeserializer(value));
    }

    @Override
    public <T> VertexUpdateEntity updateVertex(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateVertexRequest(key, value, new VertexUpdateOptions()), this.updateVertexResponseDeserializer(value));
    }

    @Override
    public <T> VertexUpdateEntity updateVertex(String key, T value, VertexUpdateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateVertexRequest(key, value, options), this.updateVertexResponseDeserializer(value));
    }

    @Override
    public void deleteVertex(String key) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteVertexRequest(key, new VertexDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public void deleteVertex(String key, VertexDeleteOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteVertexRequest(key, options), (Type)((Object)Void.class));
    }
}

