/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDBMultipleException;
import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.HostSet;
import java.util.ArrayList;
import java.util.List;

public class FallbackHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private Host current;
    private Host lastSuccess;
    private int iterations;
    private final List<Throwable> lastFailExceptions;
    private boolean firstOpened;
    private HostSet hosts;

    public FallbackHostHandler(HostResolver resolver) {
        this.resolver = resolver;
        this.lastFailExceptions = new ArrayList<Throwable>();
        this.reset();
        this.hosts = resolver.resolve(true, false);
        this.current = this.lastSuccess = this.hosts.getHostsList().get(0);
        this.firstOpened = true;
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        if (this.current != this.lastSuccess || this.iterations < 3) {
            return this.current;
        }
        ArangoDBException e = new ArangoDBException("Cannot contact any host!", new ArangoDBMultipleException(new ArrayList<Throwable>(this.lastFailExceptions)));
        this.reset();
        throw e;
    }

    @Override
    public void success() {
        this.lastSuccess = this.current;
        this.reset();
    }

    @Override
    public void fail(Exception exception) {
        this.hosts = this.resolver.resolve(false, false);
        List<Host> hostList = this.hosts.getHostsList();
        int index = hostList.indexOf(this.current) + 1;
        boolean inBound = index < hostList.size();
        this.current = hostList.get(inBound ? index : 0);
        if (!inBound) {
            ++this.iterations;
        }
        this.lastFailExceptions.add(exception);
    }

    @Override
    public synchronized void failIfNotMatch(HostDescription host, Exception exception) {
        if (!host.equals(this.current.getDescription())) {
            this.fail(exception);
        }
    }

    @Override
    public void reset() {
        this.iterations = 0;
        this.lastFailExceptions.clear();
    }

    @Override
    public void confirm() {
        if (this.firstOpened) {
            this.hosts = this.resolver.resolve(false, false);
            this.firstOpened = false;
        }
    }

    @Override
    public void close() {
        this.hosts.close();
    }

    @Override
    public void closeCurrentOnError() {
        this.current.closeOnError();
    }

    @Override
    public synchronized void closeCurrentOnErrorIfNotMatch(HostDescription host) {
        if (!host.equals(this.current.getDescription())) {
            this.closeCurrentOnError();
        }
    }

    @Override
    public void setJwt(String jwt) {
        this.hosts.setJwt(jwt);
    }
}

