/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.HostSet;
import java.util.ArrayList;
import java.util.Collections;

public class RandomHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private final HostHandler fallback;
    private Host current;
    private HostSet hosts;

    public RandomHostHandler(HostResolver resolver, HostHandler fallback) {
        this.resolver = resolver;
        this.fallback = fallback;
        this.current = this.getRandomHost(true, false);
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        if (this.current == null) {
            this.current = this.getRandomHost(false, true);
        }
        return this.current;
    }

    @Override
    public void success() {
        this.fallback.success();
    }

    @Override
    public void fail(Exception exception) {
        this.fallback.fail(exception);
        this.current = this.fallback.get(null, null);
    }

    @Override
    public synchronized void failIfNotMatch(HostDescription host, Exception exception) {
        if (!host.equals(this.current.getDescription())) {
            this.fail(exception);
        }
    }

    private Host getRandomHost(boolean initial, boolean closeConnections) {
        this.hosts = this.resolver.resolve(initial, closeConnections);
        ArrayList<Host> hostList = new ArrayList<Host>(this.hosts.getHostsList());
        Collections.shuffle(hostList);
        return hostList.get(0);
    }

    @Override
    public void reset() {
        this.fallback.reset();
    }

    @Override
    public void confirm() {
    }

    @Override
    public void close() {
        this.hosts.close();
    }

    @Override
    public void closeCurrentOnError() {
        this.current.closeOnError();
    }

    @Override
    public synchronized void closeCurrentOnErrorIfNotMatch(HostDescription host) {
        if (!host.equals(this.current.getDescription())) {
            this.closeCurrentOnError();
        }
    }

    @Override
    public void setJwt(String jwt) {
        this.fallback.setJwt(jwt);
        this.hosts.setJwt(jwt);
    }
}

