/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.ErrorEntity;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.velocystream.Response;
import java.lang.reflect.Type;
import java.util.concurrent.TimeoutException;

public final class ResponseUtils {
    private static final int ERROR_STATUS = 300;
    private static final int ERROR_INTERNAL = 503;
    private static final String HEADER_ENDPOINT = "X-Arango-Endpoint";

    private ResponseUtils() {
    }

    public static void checkError(ArangoSerialization util, Response response) throws ArangoDBException {
        try {
            int responseCode = response.getResponseCode();
            if (responseCode >= 300) {
                if (responseCode == 503 && response.getMeta().containsKey(HEADER_ENDPOINT)) {
                    throw new ArangoDBRedirectException(String.format("Response Code: %s", responseCode), response.getMeta().get(HEADER_ENDPOINT));
                }
                if (response.getBody() != null) {
                    ErrorEntity errorEntity = (ErrorEntity)util.deserialize(response.getBody(), (Type)((Object)ErrorEntity.class));
                    ArangoDBException e = new ArangoDBException(errorEntity);
                    if (ArangoErrors.QUEUE_TIME_VIOLATED.equals(e.getErrorNum())) {
                        throw new ArangoDBException(new TimeoutException().initCause(e));
                    }
                    throw e;
                }
                throw new ArangoDBException(String.format("Response Code: %s", responseCode), responseCode);
            }
        }
        catch (VPackParserException e) {
            throw new ArangoDBException(e);
        }
    }
}

