/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoCursor;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoGraph;
import com.arangodb.ArangoRoute;
import com.arangodb.ArangoSearch;
import com.arangodb.ArangoView;
import com.arangodb.DbName;
import com.arangodb.SearchAlias;
import com.arangodb.entity.AqlExecutionExplainEntity;
import com.arangodb.entity.AqlFunctionEntity;
import com.arangodb.entity.AqlParseEntity;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CursorEntity;
import com.arangodb.entity.DatabaseEntity;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryCachePropertiesEntity;
import com.arangodb.entity.QueryEntity;
import com.arangodb.entity.QueryTrackingPropertiesEntity;
import com.arangodb.entity.StreamTransactionEntity;
import com.arangodb.entity.TransactionEntity;
import com.arangodb.entity.TraversalEntity;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.AnalyzerEntity;
import com.arangodb.entity.arangosearch.analyzer.SearchAnalyzer;
import com.arangodb.internal.ArangoCollectionImpl;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoGraphImpl;
import com.arangodb.internal.ArangoRouteImpl;
import com.arangodb.internal.ArangoSearchImpl;
import com.arangodb.internal.ArangoViewImpl;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.SearchAliasImpl;
import com.arangodb.internal.cursor.ArangoCursorImpl;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlFunctionDeleteOptions;
import com.arangodb.model.AqlFunctionGetOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionsReadOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.StreamTransactionOptions;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.TraversalOptions;
import com.arangodb.model.arangosearch.AnalyzerDeleteOptions;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.model.arangosearch.SearchAliasCreateOptions;
import com.arangodb.util.ArangoCursorInitializer;
import com.arangodb.velocypack.Type;
import com.arangodb.velocystream.Request;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ArangoDatabaseImpl
extends InternalArangoDatabase<ArangoDBImpl, ArangoExecutorSync>
implements ArangoDatabase {
    private ArangoCursorInitializer cursorInitializer;

    protected ArangoDatabaseImpl(ArangoDBImpl arangoDB, DbName name) {
        super(arangoDB, name);
    }

    @Override
    public ArangoDBVersion getVersion() throws ArangoDBException {
        return (ArangoDBVersion)((ArangoExecutorSync)this.executor).execute(this.getVersionRequest(), (java.lang.reflect.Type)((Object)ArangoDBVersion.class));
    }

    @Override
    public ArangoDBEngine getEngine() throws ArangoDBException {
        return (ArangoDBEngine)((ArangoExecutorSync)this.executor).execute(this.getEngineRequest(), (java.lang.reflect.Type)((Object)ArangoDBEngine.class));
    }

    @Override
    public boolean exists() throws ArangoDBException {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.ERROR_ARANGO_DATABASE_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public Collection<String> getAccessibleDatabases() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getAccessibleDatabasesRequest(), this.getDatabaseResponseDeserializer());
    }

    @Override
    public ArangoCollection collection(String name) {
        return new ArangoCollectionImpl(this, name);
    }

    @Override
    public CollectionEntity createCollection(String name) throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.createCollectionRequest(name, new CollectionCreateOptions()), (java.lang.reflect.Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionEntity createCollection(String name, CollectionCreateOptions options) throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.createCollectionRequest(name, options), (java.lang.reflect.Type)((Object)CollectionEntity.class));
    }

    @Override
    public Collection<CollectionEntity> getCollections() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getCollectionsRequest(new CollectionsReadOptions()), this.getCollectionsResponseDeserializer());
    }

    @Override
    public Collection<CollectionEntity> getCollections(CollectionsReadOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getCollectionsRequest(options), this.getCollectionsResponseDeserializer());
    }

    @Override
    public IndexEntity getIndex(String id) throws ArangoDBException {
        DocumentUtil.validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getIndex(split[1]);
    }

    @Override
    public String deleteIndex(String id) throws ArangoDBException {
        DocumentUtil.validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).deleteIndex(split[1]);
    }

    @Override
    public Boolean create() throws ArangoDBException {
        return ((ArangoDBImpl)this.arango()).createDatabase(this.dbName());
    }

    @Override
    public Boolean drop() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.dropRequest(), this.createDropResponseDeserializer());
    }

    @Override
    public void grantAccess(String user, Permissions permissions) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void grantAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.RW), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void revokeAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void resetAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.resetAccessRequest(user), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void grantDefaultCollectionAccess(String user, Permissions permissions) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public Permissions getPermissions(String user) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Map<String, Object> bindVars, AqlQueryOptions options, Class<T> type) throws ArangoDBException {
        Request request = this.queryRequest(query, bindVars, options);
        HostHandle hostHandle = new HostHandle();
        CursorEntity result = (CursorEntity)((ArangoExecutorSync)this.executor).execute(request, (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
        return this.createCursor(result, type, options, hostHandle);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Map<String, Object> bindVars, Class<T> type) throws ArangoDBException {
        return this.query(query, bindVars, null, type);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, AqlQueryOptions options, Class<T> type) throws ArangoDBException {
        return this.query(query, null, options, type);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> type) throws ArangoDBException {
        return this.query(query, null, null, type);
    }

    @Override
    public <T> ArangoCursor<T> cursor(String cursorId, Class<T> type) throws ArangoDBException {
        HostHandle hostHandle = new HostHandle();
        CursorEntity result = (CursorEntity)((ArangoExecutorSync)this.executor).execute(this.queryNextRequest(cursorId, null, null), (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
        return this.createCursor(result, type, null, hostHandle);
    }

    @Override
    public <T> ArangoCursor<T> cursor(String cursorId, Class<T> type, String nextBatchId) {
        HostHandle hostHandle = new HostHandle();
        CursorEntity result = (CursorEntity)((ArangoExecutorSync)this.executor).execute(this.queryNextByBatchIdRequest(cursorId, nextBatchId, null, null), (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
        return this.createCursor(result, type, null, hostHandle);
    }

    private <T> ArangoCursor<T> createCursor(CursorEntity result, Class<T> type, final AqlQueryOptions options, final HostHandle hostHandle) {
        ArangoCursorExecute execute = new ArangoCursorExecute(){

            @Override
            public CursorEntity next(String id, Map<String, String> meta, String nextBatchId) {
                Request request = nextBatchId == null ? ArangoDatabaseImpl.this.queryNextRequest(id, options, meta) : ArangoDatabaseImpl.this.queryNextByBatchIdRequest(id, nextBatchId, options, meta);
                return (CursorEntity)((ArangoExecutorSync)ArangoDatabaseImpl.this.executor).execute(request, (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
            }

            @Override
            public void close(String id, Map<String, String> meta) {
                ((ArangoExecutorSync)ArangoDatabaseImpl.this.executor).execute(ArangoDatabaseImpl.this.queryCloseRequest(id, options, meta), (java.lang.reflect.Type)((Object)Void.class), hostHandle);
            }
        };
        return this.cursorInitializer != null ? this.cursorInitializer.createInstance(this, execute, type, result) : new ArangoCursorImpl<T>(this, execute, type, result);
    }

    @Override
    public AqlExecutionExplainEntity explainQuery(String query, Map<String, Object> bindVars, AqlQueryExplainOptions options) throws ArangoDBException {
        return (AqlExecutionExplainEntity)((ArangoExecutorSync)this.executor).execute(this.explainQueryRequest(query, bindVars, options), (java.lang.reflect.Type)((Object)AqlExecutionExplainEntity.class));
    }

    @Override
    public AqlParseEntity parseQuery(String query) throws ArangoDBException {
        return (AqlParseEntity)((ArangoExecutorSync)this.executor).execute(this.parseQueryRequest(query), (java.lang.reflect.Type)((Object)AqlParseEntity.class));
    }

    @Override
    public void clearQueryCache() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.clearQueryCacheRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public QueryCachePropertiesEntity getQueryCacheProperties() throws ArangoDBException {
        return (QueryCachePropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getQueryCachePropertiesRequest(), (java.lang.reflect.Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public QueryCachePropertiesEntity setQueryCacheProperties(QueryCachePropertiesEntity properties) throws ArangoDBException {
        return (QueryCachePropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.setQueryCachePropertiesRequest(properties), (java.lang.reflect.Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public QueryTrackingPropertiesEntity getQueryTrackingProperties() throws ArangoDBException {
        return (QueryTrackingPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getQueryTrackingPropertiesRequest(), (java.lang.reflect.Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public QueryTrackingPropertiesEntity setQueryTrackingProperties(QueryTrackingPropertiesEntity properties) throws ArangoDBException {
        return (QueryTrackingPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.setQueryTrackingPropertiesRequest(properties), (java.lang.reflect.Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public Collection<QueryEntity> getCurrentlyRunningQueries() throws ArangoDBException {
        return (Collection)((ArangoExecutorSync)this.executor).execute(this.getCurrentlyRunningQueriesRequest(), new Type<Collection<QueryEntity>>(){}.getType());
    }

    @Override
    public Collection<QueryEntity> getSlowQueries() throws ArangoDBException {
        return (Collection)((ArangoExecutorSync)this.executor).execute(this.getSlowQueriesRequest(), new Type<Collection<QueryEntity>>(){}.getType());
    }

    @Override
    public void clearSlowQueries() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.clearSlowQueriesRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void killQuery(String id) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.killQueryRequest(id), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void createAqlFunction(String name, String code, AqlFunctionCreateOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.createAqlFunctionRequest(name, code, options), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public Integer deleteAqlFunction(String name, AqlFunctionDeleteOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteAqlFunctionRequest(name, options), this.deleteAqlFunctionResponseDeserializer());
    }

    @Override
    public Collection<AqlFunctionEntity> getAqlFunctions(AqlFunctionGetOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getAqlFunctionsRequest(options), this.getAqlFunctionsResponseDeserializer());
    }

    @Override
    public ArangoGraph graph(String name) {
        return new ArangoGraphImpl(this, name);
    }

    @Override
    public GraphEntity createGraph(String name, Collection<EdgeDefinition> edgeDefinitions) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.createGraphRequest(name, edgeDefinitions, new GraphCreateOptions()), this.createGraphResponseDeserializer());
    }

    @Override
    public GraphEntity createGraph(String name, Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.createGraphRequest(name, edgeDefinitions, options), this.createGraphResponseDeserializer());
    }

    @Override
    public Collection<GraphEntity> getGraphs() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getGraphsRequest(), this.getGraphsResponseDeserializer());
    }

    @Override
    public <T> T transaction(String action, Class<T> type, TransactionOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.transactionRequest(action, options), this.transactionResponseDeserializer(type));
    }

    @Override
    public StreamTransactionEntity beginStreamTransaction(StreamTransactionOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.beginStreamTransactionRequest(options), this.streamTransactionResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity abortStreamTransaction(String id) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.abortStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity getStreamTransaction(String id) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public Collection<TransactionEntity> getStreamTransactions() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getStreamTransactionsRequest(), this.transactionsResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity commitStreamTransaction(String id) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.commitStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public DatabaseEntity getInfo() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    @Override
    public <V, E> TraversalEntity<V, E> executeTraversal(Class<V> vertexClass, Class<E> edgeClass, TraversalOptions options) throws ArangoDBException {
        Request request = this.executeTraversalRequest(options);
        return ((ArangoExecutorSync)this.executor).execute(request, this.executeTraversalResponseDeserializer(vertexClass, edgeClass));
    }

    @Override
    public <T> T getDocument(String id, Class<T> type) throws ArangoDBException {
        DocumentUtil.validateDocumentId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getDocument(split[1], type);
    }

    @Override
    public <T> T getDocument(String id, Class<T> type, DocumentReadOptions options) throws ArangoDBException {
        DocumentUtil.validateDocumentId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getDocument(split[1], type, options);
    }

    @Override
    public void reloadRouting() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.reloadRoutingRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    protected ArangoDatabaseImpl setCursorInitializer(ArangoCursorInitializer cursorInitializer) {
        this.cursorInitializer = cursorInitializer;
        return this;
    }

    @Override
    public ArangoRoute route(String ... path) {
        return new ArangoRouteImpl(this, String.join((CharSequence)"/", path), Collections.emptyMap());
    }

    @Override
    public Collection<ViewEntity> getViews() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getViewsRequest(), this.getViewsResponseDeserializer());
    }

    @Override
    public ArangoView view(String name) {
        return new ArangoViewImpl(this, name);
    }

    @Override
    public ArangoSearch arangoSearch(String name) {
        return new ArangoSearchImpl(this, name);
    }

    @Override
    public SearchAlias searchAlias(String name) {
        return new SearchAliasImpl(this, name);
    }

    @Override
    public ViewEntity createView(String name, ViewType type) throws ArangoDBException {
        return (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.createViewRequest(name, type), (java.lang.reflect.Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity createArangoSearch(String name, ArangoSearchCreateOptions options) throws ArangoDBException {
        return (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.createArangoSearchRequest(name, options), (java.lang.reflect.Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity createSearchAlias(String name, SearchAliasCreateOptions options) throws ArangoDBException {
        return (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.createSearchAliasRequest(name, options), (java.lang.reflect.Type)((Object)ViewEntity.class));
    }

    @Override
    public AnalyzerEntity createAnalyzer(AnalyzerEntity options) throws ArangoDBException {
        return (AnalyzerEntity)((ArangoExecutorSync)this.executor).execute(this.createAnalyzerRequest(options), (java.lang.reflect.Type)((Object)AnalyzerEntity.class));
    }

    @Override
    public SearchAnalyzer createSearchAnalyzer(SearchAnalyzer analyzer) throws ArangoDBException {
        return (SearchAnalyzer)((ArangoExecutorSync)this.executor).execute(this.createAnalyzerRequest(analyzer), (java.lang.reflect.Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public AnalyzerEntity getAnalyzer(String name) throws ArangoDBException {
        return (AnalyzerEntity)((ArangoExecutorSync)this.executor).execute(this.getAnalyzerRequest(name), (java.lang.reflect.Type)((Object)AnalyzerEntity.class));
    }

    @Override
    public SearchAnalyzer getSearchAnalyzer(String name) throws ArangoDBException {
        return (SearchAnalyzer)((ArangoExecutorSync)this.executor).execute(this.getAnalyzerRequest(name), (java.lang.reflect.Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public Collection<AnalyzerEntity> getAnalyzers() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getAnalyzersRequest(), this.getAnalyzersResponseDeserializer());
    }

    @Override
    public Collection<SearchAnalyzer> getSearchAnalyzers() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getAnalyzersRequest(), this.getSearchAnalyzersResponseDeserializer());
    }

    @Override
    public void deleteAnalyzer(String name) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteAnalyzerRequest(name, null), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void deleteAnalyzer(String name, AnalyzerDeleteOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteAnalyzerRequest(name, options), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void deleteSearchAnalyzer(String name) throws ArangoDBException {
        this.deleteAnalyzer(name);
    }

    @Override
    public void deleteSearchAnalyzer(String name, AnalyzerDeleteOptions options) throws ArangoDBException {
        this.deleteAnalyzer(name, options);
    }
}

