/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.DbName;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.ErrorEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.InvertedIndexEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.model.CollectionCountOptions;
import com.arangodb.model.CollectionPropertiesOptions;
import com.arangodb.model.CollectionRenameOptions;
import com.arangodb.model.CollectionTruncateOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentExistsOptions;
import com.arangodb.model.DocumentImportOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.HashIndexOptions;
import com.arangodb.model.ImportType;
import com.arangodb.model.InvertedIndexOptions;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.SkiplistIndexOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.model.ZKDIndexOptions;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public abstract class InternalArangoCollection<A extends InternalArangoDB<E>, D extends InternalArangoDatabase<A, E>, E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    private static final String COLLECTION = "collection";
    protected static final String PATH_API_COLLECTION = "/_api/collection";
    private static final String PATH_API_DOCUMENT = "/_api/document";
    private static final String PATH_API_INDEX = "/_api/index";
    private static final String PATH_API_IMPORT = "/_api/import";
    private static final String PATH_API_USER = "/_api/user";
    private static final String MERGE_OBJECTS = "mergeObjects";
    private static final String REFILL_INDEX_CACHES = "refillIndexCaches";
    private static final String IGNORE_REVS = "ignoreRevs";
    private static final String RETURN_NEW = "returnNew";
    private static final String NEW = "new";
    private static final String RETURN_OLD = "returnOld";
    private static final String OVERWRITE = "overwrite";
    private static final String OVERWRITE_MODE = "overwriteMode";
    private static final String OLD = "old";
    private static final String SILENT = "silent";
    private static final String TRANSACTION_ID = "x-arango-trx-id";
    private final D db;
    protected volatile String name;

    protected InternalArangoCollection(D db, String name) {
        super(((InternalArangoDatabase)db).executor, ((InternalArangoDatabase)db).util, ((InternalArangoDatabase)db).context);
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected <T> Request insertDocumentRequest(T value, DocumentCreateOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_DOCUMENT, this.name);
        DocumentCreateOptions params = options != null ? options : new DocumentCreateOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(OVERWRITE, params.getOverwrite());
        request.putQueryParam(OVERWRITE_MODE, params.getOverwriteMode() != null ? params.getOverwriteMode().getValue() : null);
        request.putQueryParam(MERGE_OBJECTS, params.getMergeObjects());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<DocumentCreateEntity<T>> insertDocumentResponseDeserializer(T value, DocumentCreateOptions options) {
        return response -> {
            VPackSlice oldDoc;
            VPackSlice body = response.getBody();
            DocumentCreateEntity doc = (DocumentCreateEntity)this.util().deserialize(body, (Type)((Object)DocumentCreateEntity.class));
            VPackSlice newDoc = body.get(NEW);
            if (newDoc.isObject()) {
                doc.setNew(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(newDoc, value.getClass()));
            }
            if ((oldDoc = body.get(OLD)).isObject()) {
                doc.setOld(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, value.getClass()));
            }
            if (options == null || Boolean.TRUE != options.getSilent()) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("_id", doc.getId());
                values.put("_key", doc.getKey());
                values.put("_rev", doc.getRev());
                this.executor.documentCache().setValues(value, values);
            }
            return doc;
        };
    }

    protected <T> Request insertDocumentsRequest(Collection<T> values, DocumentCreateOptions params) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_DOCUMENT, this.name);
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(OVERWRITE, params.getOverwrite());
        request.putQueryParam(OVERWRITE_MODE, params.getOverwriteMode() != null ? params.getOverwriteMode().getValue() : null);
        request.putQueryParam(MERGE_OBJECTS, params.getMergeObjects());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(values, new ArangoSerializer.Options().serializeNullValues(false).stringAsJson(true)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentCreateEntity<T>>> insertDocumentsResponseDeserializer(Collection<T> values, DocumentCreateOptions params) {
        return response -> {
            Class<?> type = null;
            if (Boolean.TRUE == params.getReturnNew() && !values.isEmpty()) {
                type = values.iterator().next().getClass();
            }
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentCreateEntity> docs = new ArrayList<DocumentCreateEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            VPackSlice body = response.getBody();
            if (body.isArray()) {
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice oldDoc;
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)this.util().deserialize(next, (Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentCreateEntity doc = (DocumentCreateEntity)this.util().deserialize(next, (Type)((Object)DocumentCreateEntity.class));
                    VPackSlice newDoc = next.get(NEW);
                    if (newDoc.isObject()) {
                        doc.setNew(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(newDoc, type));
                    }
                    if ((oldDoc = next.get(OLD)).isObject()) {
                        doc.setOld(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected Request importDocumentsRequest(String values, DocumentImportOptions options) {
        return this.importDocumentsRequest(options).putQueryParam("type", (Object)ImportType.auto).setBody(this.util().serialize(values));
    }

    protected Request importDocumentsRequest(Collection<?> values, DocumentImportOptions options) {
        return this.importDocumentsRequest(options).putQueryParam("type", (Object)ImportType.list).setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(values, new ArangoSerializer.Options().serializeNullValues(false).stringAsJson(true)));
    }

    protected Request importDocumentsRequest(DocumentImportOptions options) {
        DocumentImportOptions params = options != null ? options : new DocumentImportOptions();
        return this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_IMPORT).putQueryParam(COLLECTION, this.name).putQueryParam("waitForSync", params.getWaitForSync()).putQueryParam("fromPrefix", params.getFromPrefix()).putQueryParam("toPrefix", params.getToPrefix()).putQueryParam(OVERWRITE, params.getOverwrite()).putQueryParam("onDuplicate", (Object)params.getOnDuplicate()).putQueryParam("complete", params.getComplete()).putQueryParam("details", params.getDetails());
    }

    protected Request getDocumentRequest(String key, DocumentReadOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.GET, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentReadOptions params = options != null ? options : new DocumentReadOptions();
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        if (params.getAllowDirtyRead() == Boolean.TRUE) {
            RequestUtils.allowDirtyRead(request);
        }
        return request;
    }

    protected Request getDocumentsRequest(Collection<String> keys, DocumentReadOptions options) {
        DocumentReadOptions params = options != null ? options : new DocumentReadOptions();
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PUT, PATH_API_DOCUMENT, this.name).putQueryParam("onlyget", true).putHeaderParam("If-None-Match", params.getIfNoneMatch()).putHeaderParam("If-Match", params.getIfMatch()).setBody(this.util().serialize(keys)).putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        if (params.getAllowDirtyRead() == Boolean.TRUE) {
            RequestUtils.allowDirtyRead(request);
        }
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<T>> getDocumentsResponseDeserializer(Class<T> type, DocumentReadOptions options) {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            boolean potentialDirtyRead = Boolean.parseBoolean(response.getMeta().get("X-Arango-Potential-Dirty-Read"));
            multiDocument.setPotentialDirtyRead(potentialDirtyRead);
            ArrayList docs = new ArrayList();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            VPackSlice body = response.getBody();
            Iterator iterator = body.arrayIterator();
            while (iterator.hasNext()) {
                VPackSlice next = (VPackSlice)iterator.next();
                if (next.get("error").isTrue()) {
                    ErrorEntity error = (ErrorEntity)this.util().deserialize(next, (Type)((Object)ErrorEntity.class));
                    errors.add(error);
                    documentsAndErrors.add(error);
                    continue;
                }
                Object doc = this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(next, type);
                docs.add(doc);
                documentsAndErrors.add(doc);
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected <T> Request replaceDocumentRequest(String key, T value, DocumentReplaceOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PUT, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentReplaceOptions params = options != null ? options : new DocumentReplaceOptions();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<DocumentUpdateEntity<T>> replaceDocumentResponseDeserializer(T value, DocumentReplaceOptions options) {
        return response -> {
            VPackSlice oldDoc;
            VPackSlice body = response.getBody();
            DocumentUpdateEntity doc = (DocumentUpdateEntity)this.util().deserialize(body, (Type)((Object)DocumentUpdateEntity.class));
            VPackSlice newDoc = body.get(NEW);
            if (newDoc.isObject()) {
                doc.setNew(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(newDoc, value.getClass()));
            }
            if ((oldDoc = body.get(OLD)).isObject()) {
                doc.setOld(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, value.getClass()));
            }
            if (options == null || Boolean.TRUE != options.getSilent()) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("_rev", doc.getRev());
                this.executor.documentCache().setValues(value, values);
            }
            return doc;
        };
    }

    protected <T> Request replaceDocumentsRequest(Collection<T> values, DocumentReplaceOptions params) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PUT, PATH_API_DOCUMENT, this.name);
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(values, new ArangoSerializer.Options().serializeNullValues(false).stringAsJson(true)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>> replaceDocumentsResponseDeserializer(Collection<T> values, DocumentReplaceOptions params) {
        return response -> {
            Class<?> type = null;
            if (!(Boolean.TRUE != params.getReturnNew() && Boolean.TRUE != params.getReturnOld() || values.isEmpty())) {
                type = values.iterator().next().getClass();
            }
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentUpdateEntity> docs = new ArrayList<DocumentUpdateEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            VPackSlice body = response.getBody();
            if (body.isArray()) {
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice oldDoc;
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)this.util().deserialize(next, (Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentUpdateEntity doc = (DocumentUpdateEntity)this.util().deserialize(next, (Type)((Object)DocumentUpdateEntity.class));
                    VPackSlice newDoc = next.get(NEW);
                    if (newDoc.isObject()) {
                        doc.setNew(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(newDoc, type));
                    }
                    if ((oldDoc = next.get(OLD)).isObject()) {
                        doc.setOld(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected <T> Request updateDocumentRequest(String key, T value, DocumentUpdateOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PATCH, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentUpdateOptions params = options != null ? options : new DocumentUpdateOptions();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(MERGE_OBJECTS, params.getMergeObjects());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value, new ArangoSerializer.Options().serializeNullValues(params.getSerializeNull() == null || params.getSerializeNull() != false)));
        return request;
    }

    protected <T, U> ArangoExecutor.ResponseDeserializer<DocumentUpdateEntity<U>> updateDocumentResponseDeserializer(T value, DocumentUpdateOptions options, Class<U> returnType) {
        return response -> {
            VPackSlice oldDoc;
            VPackSlice body = response.getBody();
            DocumentUpdateEntity doc = (DocumentUpdateEntity)this.util().deserialize(body, (Type)((Object)DocumentUpdateEntity.class));
            VPackSlice newDoc = body.get(NEW);
            if (newDoc.isObject()) {
                doc.setNew(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(newDoc, returnType));
            }
            if ((oldDoc = body.get(OLD)).isObject()) {
                doc.setOld(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, returnType));
            }
            if (options == null || Boolean.TRUE != options.getSilent()) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("_rev", doc.getRev());
                this.executor.documentCache().setValues(value, values);
            }
            return doc;
        };
    }

    protected <T> Request updateDocumentsRequest(Collection<T> values, DocumentUpdateOptions params) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PATCH, PATH_API_DOCUMENT, this.name);
        Boolean keepNull = params.getKeepNull();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("keepNull", keepNull);
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(MERGE_OBJECTS, params.getMergeObjects());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(values, new ArangoSerializer.Options().serializeNullValues(params.getSerializeNull() == null || params.getSerializeNull() != false).stringAsJson(true)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>> updateDocumentsResponseDeserializer(Class<T> returnType) {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentUpdateEntity> docs = new ArrayList<DocumentUpdateEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            VPackSlice body = response.getBody();
            if (body.isArray()) {
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice oldDoc;
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)this.util().deserialize(next, (Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentUpdateEntity doc = (DocumentUpdateEntity)this.util().deserialize(next, (Type)((Object)DocumentUpdateEntity.class));
                    VPackSlice newDoc = next.get(NEW);
                    if (newDoc.isObject()) {
                        doc.setNew(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(newDoc, returnType));
                    }
                    if ((oldDoc = next.get(OLD)).isObject()) {
                        doc.setOld(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, returnType));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected Request deleteDocumentRequest(String key, DocumentDeleteOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.DELETE, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentDeleteOptions params = options != null ? options : new DocumentDeleteOptions();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<DocumentDeleteEntity<T>> deleteDocumentResponseDeserializer(Class<T> type) {
        return response -> {
            VPackSlice body = response.getBody();
            DocumentDeleteEntity doc = (DocumentDeleteEntity)this.util().deserialize(body, (Type)((Object)DocumentDeleteEntity.class));
            VPackSlice oldDoc = body.get(OLD);
            if (oldDoc.isObject()) {
                doc.setOld(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
            }
            return doc;
        };
    }

    protected <T> Request deleteDocumentsRequest(Collection<T> keys, DocumentDeleteOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.DELETE, PATH_API_DOCUMENT, this.name);
        DocumentDeleteOptions params = options != null ? options : new DocumentDeleteOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(REFILL_INDEX_CACHES, params.getRefillIndexCaches());
        request.setBody(this.util().serialize(keys));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentDeleteEntity<T>>> deleteDocumentsResponseDeserializer(Class<T> type) {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentDeleteEntity> docs = new ArrayList<DocumentDeleteEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            VPackSlice body = response.getBody();
            if (body.isArray()) {
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)this.util().deserialize(next, (Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentDeleteEntity doc = (DocumentDeleteEntity)this.util().deserialize(next, (Type)((Object)DocumentDeleteEntity.class));
                    VPackSlice oldDoc = next.get(OLD);
                    if (oldDoc.isObject()) {
                        doc.setOld(this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected Request documentExistsRequest(String key, DocumentExistsOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.HEAD, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentExistsOptions params = options != null ? options : new DocumentExistsOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        return request;
    }

    protected Request getIndexRequest(String id) {
        return this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.GET, PATH_API_INDEX, this.createIndexId(id));
    }

    protected Request deleteIndexRequest(String id) {
        return this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.DELETE, PATH_API_INDEX, this.createIndexId(id));
    }

    protected ArangoExecutor.ResponseDeserializer<String> deleteIndexResponseDeserializer() {
        return response -> response.getBody().get("id").getAsString();
    }

    private String createIndexId(String id) {
        String index;
        if (id.matches("[^/]+/[^/]+")) {
            index = id;
        } else if (id.matches("[^/]+")) {
            index = this.name + "/" + id;
        } else {
            throw new ArangoDBException(String.format("index id %s is not valid.", id));
        }
        return index;
    }

    @Deprecated
    protected Request createHashIndexRequest(Iterable<String> fields, HashIndexOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new HashIndexOptions(), fields)));
        return request;
    }

    @Deprecated
    protected Request createSkiplistIndexRequest(Iterable<String> fields, SkiplistIndexOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new SkiplistIndexOptions(), fields)));
        return request;
    }

    protected Request createPersistentIndexRequest(Iterable<String> fields, PersistentIndexOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new PersistentIndexOptions(), fields)));
        return request;
    }

    protected Request createInvertedIndexRequest(InvertedIndexOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.util().serialize(options));
        return request;
    }

    protected Request createGeoIndexRequest(Iterable<String> fields, GeoIndexOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new GeoIndexOptions(), fields)));
        return request;
    }

    @Deprecated
    protected Request createFulltextIndexRequest(Iterable<String> fields, FulltextIndexOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new FulltextIndexOptions(), fields)));
        return request;
    }

    protected Request createTtlIndexRequest(Iterable<String> fields, TtlIndexOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new TtlIndexOptions(), fields)));
        return request;
    }

    protected Request createZKDIndexRequest(Iterable<String> fields, ZKDIndexOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new ZKDIndexOptions().fieldValueTypes(ZKDIndexOptions.FieldValueTypes.DOUBLE), fields)));
        return request;
    }

    protected Request getIndexesRequest() {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.GET, PATH_API_INDEX);
        request.putQueryParam(COLLECTION, this.name);
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<IndexEntity>> getIndexesResponseDeserializer() {
        return response -> {
            ArrayList indexes = new ArrayList();
            Iterator it = response.getBody().get("indexes").arrayIterator();
            while (it.hasNext()) {
                VPackSlice idx = (VPackSlice)it.next();
                if ("inverted".equals(idx.get("type").getAsString())) continue;
                indexes.add(this.util().deserialize(idx, (Type)((Object)IndexEntity.class)));
            }
            return indexes;
        };
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<InvertedIndexEntity>> getInvertedIndexesResponseDeserializer() {
        return response -> {
            ArrayList indexes = new ArrayList();
            Iterator it = response.getBody().get("indexes").arrayIterator();
            while (it.hasNext()) {
                VPackSlice idx = (VPackSlice)it.next();
                if (!"inverted".equals(idx.get("type").getAsString())) continue;
                indexes.add(this.util().deserialize(idx, (Type)((Object)InvertedIndexEntity.class)));
            }
            return indexes;
        };
    }

    protected Request truncateRequest(CollectionTruncateOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PUT, PATH_API_COLLECTION, this.name, "truncate");
        CollectionTruncateOptions params = options != null ? options : new CollectionTruncateOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        return request;
    }

    protected Request countRequest(CollectionCountOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.GET, PATH_API_COLLECTION, this.name, "count");
        CollectionCountOptions params = options != null ? options : new CollectionCountOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        return request;
    }

    protected Request dropRequest(Boolean isSystem) {
        return this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.DELETE, PATH_API_COLLECTION, this.name).putQueryParam("isSystem", isSystem);
    }

    protected Request loadRequest() {
        return this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PUT, PATH_API_COLLECTION, this.name, "load");
    }

    protected Request unloadRequest() {
        return this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PUT, PATH_API_COLLECTION, this.name, "unload");
    }

    protected Request getInfoRequest() {
        return this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.GET, PATH_API_COLLECTION, this.name);
    }

    protected Request getPropertiesRequest() {
        return this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.GET, PATH_API_COLLECTION, this.name, "properties");
    }

    protected Request changePropertiesRequest(CollectionPropertiesOptions options) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PUT, PATH_API_COLLECTION, this.name, "properties");
        request.setBody(this.util().serialize(options != null ? options : new CollectionPropertiesOptions()));
        return request;
    }

    protected Request renameRequest(String newName) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PUT, PATH_API_COLLECTION, this.name, "rename");
        request.setBody(this.util().serialize(OptionsBuilder.build(new CollectionRenameOptions(), newName)));
        return request;
    }

    protected <T> Request responsibleShardRequest(T value) {
        Request request = this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.PUT, PATH_API_COLLECTION, this.name, "responsibleShard");
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected Request getRevisionRequest() {
        return this.request(((InternalArangoDatabase)this.db).dbName(), RequestType.GET, PATH_API_COLLECTION, this.name, "revision");
    }

    protected Request grantAccessRequest(String user, Permissions permissions) {
        return this.request(DbName.SYSTEM, RequestType.PUT, PATH_API_USER, user, "database", ((InternalArangoDatabase)this.db).dbName().get(), this.name).setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request resetAccessRequest(String user) {
        return this.request(DbName.SYSTEM, RequestType.DELETE, PATH_API_USER, user, "database", ((InternalArangoDatabase)this.db).dbName().get(), this.name);
    }

    protected Request getPermissionsRequest(String user) {
        return this.request(DbName.SYSTEM, RequestType.GET, PATH_API_USER, user, "database", ((InternalArangoDatabase)this.db).dbName().get(), this.name);
    }

    protected ArangoExecutor.ResponseDeserializer<Permissions> getPermissionsResponseDeserialzer() {
        return response -> {
            VPackSlice result;
            VPackSlice body = response.getBody();
            if (body != null && !(result = body.get("result")).isNone()) {
                return (Permissions)((Object)((Object)this.util().deserialize(result, (Type)((Object)Permissions.class))));
            }
            return null;
        };
    }
}

