/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.DbName;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoContext;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogLevelOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class InternalArangoDB<E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    private static final String PATH_API_ADMIN_LOG = "/_admin/log";
    private static final String PATH_API_ADMIN_LOG_ENTRIES = "/_admin/log/entries";
    private static final String PATH_API_ADMIN_LOG_LEVEL = "/_admin/log/level";
    private static final String PATH_API_ROLE = "/_admin/server/role";
    private static final String PATH_API_SERVER_ID = "/_admin/server/id";
    private static final String PATH_ENDPOINTS = "/_api/cluster/endpoints";
    private static final String PATH_API_USER = "/_api/user";
    private static final String PATH_API_QUERY_RULES = "/_api/query/rules";

    protected InternalArangoDB(E executor, ArangoSerializationFactory util, ArangoContext context) {
        super(executor, util, context);
    }

    protected Request getRoleRequest() {
        return this.request(DbName.SYSTEM, RequestType.GET, PATH_API_ROLE);
    }

    protected Request getServerIdRequest() {
        return this.request(DbName.SYSTEM, RequestType.GET, PATH_API_SERVER_ID);
    }

    protected ArangoExecutor.ResponseDeserializer<ServerRole> getRoleResponseDeserializer() {
        return response -> (ServerRole)((Object)((Object)this.util().deserialize(response.getBody().get("role"), (java.lang.reflect.Type)((Object)ServerRole.class))));
    }

    protected ArangoExecutor.ResponseDeserializer<String> getServerIdResponseDeserializer() {
        return response -> (String)this.util().deserialize(response.getBody().get("id"), (java.lang.reflect.Type)((Object)String.class));
    }

    protected Request createDatabaseRequest(DBCreateOptions options) {
        Request request = this.request(DbName.SYSTEM, RequestType.POST, "/_api/database");
        request.setBody(this.util().serialize(options));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Boolean> createDatabaseResponseDeserializer() {
        return response -> response.getBody().get("result").getAsBoolean();
    }

    protected Request getDatabasesRequest(DbName dbName) {
        return this.request(dbName, RequestType.GET, "/_api/database");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getDatabaseResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            return (Collection)this.util().deserialize(result, new Type<Collection<String>>(){}.getType());
        };
    }

    protected Request getAccessibleDatabasesForRequest(DbName dbName, String user) {
        return this.request(dbName, RequestType.GET, PATH_API_USER, user, "database");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getAccessibleDatabasesForResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            ArrayList dbs = new ArrayList();
            Iterator iterator = result.objectIterator();
            while (iterator.hasNext()) {
                dbs.add(((Map.Entry)iterator.next()).getKey());
            }
            return dbs;
        };
    }

    protected Request createUserRequest(DbName dbName, String user, String passwd, UserCreateOptions options) {
        Request request = this.request(dbName, RequestType.POST, PATH_API_USER);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new UserCreateOptions(), user, passwd)));
        return request;
    }

    protected Request deleteUserRequest(DbName dbName, String user) {
        return this.request(dbName, RequestType.DELETE, PATH_API_USER, user);
    }

    protected Request getUsersRequest(DbName dbName) {
        return this.request(dbName, RequestType.GET, PATH_API_USER);
    }

    protected Request getUserRequest(DbName dbName, String user) {
        return this.request(dbName, RequestType.GET, PATH_API_USER, user);
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<UserEntity>> getUsersResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            return (Collection)this.util().deserialize(result, new Type<Collection<UserEntity>>(){}.getType());
        };
    }

    protected Request updateUserRequest(DbName dbName, String user, UserUpdateOptions options) {
        Request request = this.request(dbName, RequestType.PATCH, PATH_API_USER, user);
        request.setBody(this.util().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected Request replaceUserRequest(DbName dbName, String user, UserUpdateOptions options) {
        Request request = this.request(dbName, RequestType.PUT, PATH_API_USER, user);
        request.setBody(this.util().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected Request updateUserDefaultDatabaseAccessRequest(String user, Permissions permissions) {
        return this.request(DbName.SYSTEM, RequestType.PUT, PATH_API_USER, user, "database", "*").setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request updateUserDefaultCollectionAccessRequest(String user, Permissions permissions) {
        return this.request(DbName.SYSTEM, RequestType.PUT, PATH_API_USER, user, "database", "*", "*").setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request getLogsRequest(LogOptions options) {
        LogOptions params = options != null ? options : new LogOptions();
        return this.request(DbName.SYSTEM, RequestType.GET, PATH_API_ADMIN_LOG).putQueryParam("upto", (Object)params.getUpto()).putQueryParam("level", (Object)params.getLevel()).putQueryParam("start", params.getStart()).putQueryParam("size", params.getSize()).putQueryParam("offset", params.getOffset()).putQueryParam("search", params.getSearch()).putQueryParam("sort", (Object)params.getSort());
    }

    protected Request getLogEntriesRequest(LogOptions options) {
        LogOptions params = options != null ? options : new LogOptions();
        return this.request(DbName.SYSTEM, RequestType.GET, PATH_API_ADMIN_LOG_ENTRIES).putQueryParam("upto", (Object)params.getUpto()).putQueryParam("level", (Object)params.getLevel()).putQueryParam("start", params.getStart()).putQueryParam("size", params.getSize()).putQueryParam("offset", params.getOffset()).putQueryParam("search", params.getSearch()).putQueryParam("sort", (Object)params.getSort());
    }

    protected Request getLogLevelRequest(LogLevelOptions options) {
        return this.request(DbName.SYSTEM, RequestType.GET, PATH_API_ADMIN_LOG_LEVEL).putQueryParam("serverId", options.getServerId());
    }

    protected Request setLogLevelRequest(LogLevelEntity entity, LogLevelOptions options) {
        return this.request(DbName.SYSTEM, RequestType.PUT, PATH_API_ADMIN_LOG_LEVEL).putQueryParam("serverId", options.getServerId()).setBody(this.util().serialize(entity));
    }

    protected Request getQueryOptimizerRulesRequest() {
        return this.request(DbName.SYSTEM, RequestType.GET, PATH_API_QUERY_RULES);
    }
}

