/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.cursor;

import com.arangodb.ArangoCursor;
import com.arangodb.ArangoIterator;
import com.arangodb.Consumer;
import com.arangodb.entity.CursorEntity;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.cursor.AbstractArangoIterable;
import com.arangodb.internal.cursor.ArangoCursorIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoCursorImpl<T>
extends AbstractArangoIterable<T>
implements ArangoCursor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ArangoCursorImpl.class);
    private final Class<T> type;
    protected final ArangoCursorIterator<T> iterator;
    private final String id;
    private final ArangoCursorExecute execute;
    private final boolean pontentialDirtyRead;
    private final boolean allowRetry;

    public ArangoCursorImpl(InternalArangoDatabase<?, ?> db, ArangoCursorExecute execute, Class<T> type, CursorEntity result) {
        this.execute = execute;
        this.type = type;
        this.iterator = this.createIterator(this, db, execute, result);
        this.id = result.getId();
        this.pontentialDirtyRead = Boolean.parseBoolean(result.getMeta().get("X-Arango-Potential-Dirty-Read"));
        this.allowRetry = result.getNextBatchId() != null;
    }

    protected ArangoCursorIterator<T> createIterator(ArangoCursor<T> cursor, InternalArangoDatabase<?, ?> db, ArangoCursorExecute execute, CursorEntity result) {
        return new ArangoCursorIterator<T>(cursor, execute, db, result);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Integer getCount() {
        return this.iterator.getResult().getCount();
    }

    @Override
    public CursorEntity.Stats getStats() {
        CursorEntity.Extras extra = this.iterator.getResult().getExtra();
        return extra != null ? extra.getStats() : null;
    }

    @Override
    public Collection<CursorEntity.Warning> getWarnings() {
        CursorEntity.Extras extra = this.iterator.getResult().getExtra();
        return extra != null ? extra.getWarnings() : null;
    }

    @Override
    public boolean isCached() {
        Boolean cached = this.iterator.getResult().getCached();
        return Boolean.TRUE == cached;
    }

    @Override
    public void close() {
        if (this.getId() != null && (this.allowRetry || this.iterator.getResult().getHasMore().booleanValue())) {
            this.execute.close(this.id, this.iterator.getResult().getMeta());
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public List<T> asListRemaining() {
        ArrayList<T> remaining = new ArrayList<T>();
        while (this.hasNext()) {
            remaining.add(this.next());
        }
        try {
            this.close();
        }
        catch (Exception e) {
            LOG.warn("Could not close cursor: ", (Throwable)e);
        }
        return remaining;
    }

    @Override
    public boolean isPotentialDirtyRead() {
        return this.pontentialDirtyRead;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArangoIterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public void foreach(Consumer<? super T> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    @Override
    public String getNextBatchId() {
        return this.iterator.getResult().getNextBatchId();
    }
}

