/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.http;

import com.arangodb.ArangoDBException;
import com.arangodb.DbName;
import com.arangodb.Protocol;
import com.arangodb.internal.http.CURLLogger;
import com.arangodb.internal.http.HttpCommunication;
import com.arangodb.internal.http.HttpDeleteWithBody;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.util.IOUtils;
import com.arangodb.internal.util.ResponseUtils;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
implements Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCommunication.class);
    private static final ContentType CONTENT_TYPE_APPLICATION_JSON_UTF8 = ContentType.create((String)"application/json", (String)"utf-8");
    private static final ContentType CONTENT_TYPE_VPACK = ContentType.create((String)"application/x-velocypack");
    private static final int MAX_JSON_LENGTH = 0x1FFFFFFD;
    private static final String X_ARANGO_DRIVER = "JavaDriver/6.25.0 (JVM/" + System.getProperty("java.specification.version") + ")";
    private final PoolingHttpClientConnectionManager cm;
    private final CloseableHttpClient client;
    private final String user;
    private final String password;
    private volatile String jwt = null;
    private final ArangoSerialization util;
    private final Boolean useSsl;
    private final Protocol contentType;
    private final HostDescription host;

    private HttpConnection(HostDescription host, Integer timeout, String user, String password, Boolean useSsl, SSLContext sslContext, HostnameVerifier hostnameVerifier, ArangoSerialization util, Protocol contentType, Long ttl, String httpCookieSpec, HttpRequestRetryHandler httpRequestRetryHandler) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.useSsl = useSsl;
        this.util = util;
        this.contentType = contentType;
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        if (Boolean.TRUE == useSsl) {
            registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(sslContext != null ? sslContext : SSLContexts.createSystemDefault(), hostnameVerifier != null ? hostnameVerifier : SSLConnectionSocketFactory.getDefaultHostnameVerifier()));
        } else {
            registryBuilder.register("http", (Object)new PlainConnectionSocketFactory());
        }
        this.cm = new PoolingHttpClientConnectionManager(registryBuilder.build());
        this.cm.setDefaultMaxPerRoute(1);
        this.cm.setMaxTotal(1);
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        if (timeout != null && timeout >= 0) {
            requestConfig.setConnectTimeout(timeout.intValue());
            requestConfig.setConnectionRequestTimeout(timeout.intValue());
            requestConfig.setSocketTimeout(timeout.intValue());
        }
        if (httpCookieSpec != null && httpCookieSpec.length() > 1) {
            requestConfig.setCookieSpec(httpCookieSpec);
        }
        ConnectionKeepAliveStrategy keepAliveStrategy = (response, context) -> this.getKeepAliveDuration(response);
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig.build()).setConnectionManager((HttpClientConnectionManager)this.cm).setKeepAliveStrategy(keepAliveStrategy).setRetryHandler((HttpRequestRetryHandler)(httpRequestRetryHandler != null ? httpRequestRetryHandler : new DefaultHttpRequestRetryHandler()));
        if (ttl != null) {
            builder.setConnectionTimeToLive(ttl.longValue(), TimeUnit.MILLISECONDS);
        }
        this.client = builder.build();
    }

    private long getKeepAliveDuration(HttpResponse response) {
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 30000L;
    }

    @Override
    public void close() throws IOException {
        this.cm.shutdown();
        this.client.close();
    }

    private static String buildUrl(String baseUrl, Request request) {
        StringBuilder sb = new StringBuilder().append(baseUrl);
        DbName dbName = request.getDbName();
        if (dbName != null && !dbName.get().isEmpty()) {
            sb.append("/_db/").append(dbName.getEncoded());
        }
        sb.append(request.getRequest());
        if (!request.getQueryParam().isEmpty()) {
            if (request.getRequest().contains("?")) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            String paramString = URLEncodedUtils.format(HttpConnection.toList(request.getQueryParam()), (String)"utf-8");
            sb.append(paramString);
        }
        return sb.toString();
    }

    private HttpRequestBase buildHttpRequestBase(Request request, String url) {
        HttpHead httpRequest;
        switch (request.getRequestType()) {
            case POST: {
                httpRequest = this.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPost(url), request);
                break;
            }
            case PUT: {
                httpRequest = this.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPut(url), request);
                break;
            }
            case PATCH: {
                httpRequest = this.requestWithBody((HttpEntityEnclosingRequestBase)new HttpPatch(url), request);
                break;
            }
            case DELETE: {
                httpRequest = this.requestWithBody(new HttpDeleteWithBody(url), request);
                break;
            }
            case HEAD: {
                httpRequest = new HttpHead(url);
                break;
            }
            default: {
                httpRequest = new HttpGet(url);
            }
        }
        return httpRequest;
    }

    private HttpRequestBase requestWithBody(HttpEntityEnclosingRequestBase httpRequest, Request request) {
        VPackSlice body = request.getBody();
        if (body != null) {
            if (this.contentType == Protocol.HTTP_VPACK) {
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity(Arrays.copyOfRange(body.getBuffer(), body.getStart(), body.getStart() + body.getByteSize()), CONTENT_TYPE_VPACK));
            } else {
                String json = body.toString();
                if (json.length() > 0x1FFFFFFD) {
                    LOGGER.warn("Json string length is greater than safe threshold (536870909). This could cause memory allocation errors.");
                }
                httpRequest.setEntity((HttpEntity)new StringEntity(json, CONTENT_TYPE_APPLICATION_JSON_UTF8));
            }
        }
        return httpRequest;
    }

    private String buildBaseUrl(HostDescription host) {
        return (Boolean.TRUE == this.useSsl ? "https://" : "http://") + host.getHost() + ":" + host.getPort();
    }

    private static List<NameValuePair> toList(Map<String, String> parameters) {
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>(parameters.size());
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            if (param.getValue() == null) continue;
            paramList.add((NameValuePair)new BasicNameValuePair(param.getKey(), param.getValue()));
        }
        return paramList;
    }

    public Response execute(Request request) throws ArangoDBException, IOException {
        String url = HttpConnection.buildUrl(this.buildBaseUrl(this.host), request);
        HttpRequestBase httpRequest = this.buildHttpRequestBase(request, url);
        httpRequest.setHeader("User-Agent", "Mozilla/5.0 (compatible; ArangoDB-JavaDriver/1.1; +http://mt.orz.at/)");
        httpRequest.setHeader("x-arango-driver", X_ARANGO_DRIVER);
        if (this.contentType == Protocol.HTTP_VPACK) {
            httpRequest.setHeader("Accept", "application/x-velocypack");
        }
        HttpConnection.addHeader(request, httpRequest);
        UsernamePasswordCredentials credentials = null;
        if (this.jwt != null) {
            httpRequest.addHeader("Authorization", "Bearer " + this.jwt);
        } else if (this.user != null) {
            credentials = new UsernamePasswordCredentials(this.user, this.password != null ? this.password : "");
            try {
                httpRequest.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)httpRequest, null));
            }
            catch (AuthenticationException e) {
                throw new ArangoDBException(e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            CURLLogger.log(url, request, (Credentials)credentials, this.jwt, this.util);
        }
        Response response = this.buildResponse(this.client.execute((HttpUriRequest)httpRequest));
        this.checkError(response);
        return response;
    }

    private static void addHeader(Request request, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> header : request.getHeaderParam().entrySet()) {
            httpRequest.addHeader(header.getKey(), header.getValue());
        }
    }

    public Response buildResponse(CloseableHttpResponse httpResponse) throws UnsupportedOperationException, IOException {
        Response response = new Response();
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null && entity.getContent() != null) {
            Object content;
            if (this.contentType == Protocol.HTTP_VPACK) {
                content = IOUtils.toByteArray(entity.getContent());
                if (((byte[])content).length > 0) {
                    response.setBody(new VPackSlice(content));
                }
            } else {
                content = IOUtils.toString(entity.getContent());
                if (!content.isEmpty()) {
                    response.setBody(this.util.serialize(content, new ArangoSerializer.Options().stringAsJson(true).serializeNullValues(true)));
                }
            }
        }
        Header[] headers = httpResponse.getAllHeaders();
        Map<String, String> meta = response.getMeta();
        for (Header header : headers) {
            meta.put(header.getName(), header.getValue());
        }
        return response;
    }

    protected void checkError(Response response) throws ArangoDBException {
        ResponseUtils.checkError(this.util, response);
    }

    @Override
    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public static class Builder {
        private String user;
        private String password;
        private ArangoSerialization util;
        private Boolean useSsl;
        private String httpCookieSpec;
        private Protocol contentType;
        private HostDescription host;
        private Long ttl;
        private SSLContext sslContext;
        private HostnameVerifier hostnameVerifier;
        private Integer timeout;
        private HttpRequestRetryHandler httpRequestRetryHandler;

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder serializationUtil(ArangoSerialization util) {
            this.util = util;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder httpCookieSpec(String httpCookieSpec) {
            this.httpCookieSpec = httpCookieSpec;
            return this;
        }

        public Builder contentType(Protocol contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder host(HostDescription host) {
            this.host = host;
            return this;
        }

        public Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder httpRequestRetryHandler(HttpRequestRetryHandler httpRequestRetryHandler) {
            this.httpRequestRetryHandler = httpRequestRetryHandler;
            return this;
        }

        public HttpConnection build() {
            return new HttpConnection(this.host, this.timeout, this.user, this.password, this.useSsl, this.sslContext, this.hostnameVerifier, this.util, this.contentType, this.ttl, this.httpCookieSpec, this.httpRequestRetryHandler);
        }
    }
}

