/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.ConnectionPool;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.velocystream.internal.VstConnection;
import com.arangodb.internal.velocystream.internal.VstConnectionSync;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolImpl
implements ConnectionPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPoolImpl.class);
    private final HostDescription host;
    private final int maxConnections;
    private final List<Connection> connections;
    private int current;
    private final ConnectionFactory factory;
    private volatile String jwt = null;

    public ConnectionPoolImpl(HostDescription host, Integer maxConnections, ConnectionFactory factory) {
        this.host = host;
        this.maxConnections = maxConnections;
        this.factory = factory;
        this.connections = new ArrayList<Connection>();
        this.current = 0;
    }

    @Override
    public Connection createConnection(HostDescription host) {
        Connection c = this.factory.create(host);
        c.setJwt(this.jwt);
        return c;
    }

    @Override
    public synchronized Connection connection() {
        Connection connection;
        if (this.connections.size() < this.maxConnections) {
            connection = this.createConnection(this.host);
            this.connections.add(connection);
            ++this.current;
        } else {
            int index = Math.floorMod(this.current++, this.connections.size());
            connection = this.connections.get(index);
        }
        if (connection instanceof VstConnectionSync) {
            LOGGER.debug("Return Connection " + ((VstConnection)connection).getConnectionName());
        }
        return connection;
    }

    @Override
    public void setJwt(String jwt) {
        this.jwt = jwt;
        for (Connection connection : this.connections) {
            connection.setJwt(jwt);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        for (Connection connection : this.connections) {
            connection.close();
        }
        this.connections.clear();
    }

    public String toString() {
        return "ConnectionPoolImpl [host=" + this.host + ", maxConnections=" + this.maxConnections + ", connections=" + this.connections.size() + ", current=" + this.current + ", factory=" + this.factory.getClass().getSimpleName() + "]";
    }
}

