/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.internal.net.Host;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostSet.class);
    private final ArrayList<Host> hosts = new ArrayList();
    private volatile String jwt = null;

    public HostSet() {
    }

    public HostSet(List<Host> hosts) {
        for (Host host : hosts) {
            this.addHost(host);
        }
    }

    public List<Host> getHostsList() {
        return Collections.unmodifiableList(this.hosts);
    }

    public void addHost(Host newHost) {
        if (this.hosts.contains(newHost)) {
            LOGGER.debug("Host" + newHost + " already in Set");
            for (Host host : this.hosts) {
                if (!host.equals(newHost)) continue;
                host.setMarkforDeletion(false);
            }
        } else {
            newHost.setJwt(this.jwt);
            this.hosts.add(newHost);
            LOGGER.debug("Added Host " + newHost + " - now " + this.hosts.size() + " Hosts in List");
        }
    }

    public void close() {
        LOGGER.debug("Close all Hosts in Set");
        for (Host host : this.hosts) {
            try {
                LOGGER.debug("Try to close Host " + host);
                host.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error during closing the Host " + host, (Throwable)e);
            }
        }
    }

    public void markAllForDeletion() {
        for (Host host : this.hosts) {
            host.setMarkforDeletion(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllMarkedForDeletion() {
        LOGGER.debug("Clear all Hosts in Set with markForDeletion");
        Iterator<Host> iterable = this.hosts.iterator();
        while (iterable.hasNext()) {
            Host host = iterable.next();
            if (!host.isMarkforDeletion()) continue;
            try {
                LOGGER.debug("Try to close Host " + host);
                host.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error during closing the Host " + host, (Throwable)e);
            }
            finally {
                iterable.remove();
            }
        }
    }

    public void clear() {
        LOGGER.debug("Clear all Hosts in Set");
        this.close();
        this.hosts.clear();
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
        for (Host h : this.hosts) {
            h.setJwt(jwt);
        }
    }
}

