/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocypack;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.InvertedIndexPrimarySort;
import com.arangodb.entity.LogLevel;
import com.arangodb.entity.MinReplicationFactor;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.ArangoSearchCompression;
import com.arangodb.entity.arangosearch.ArangoSearchProperties;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.ConsolidationType;
import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.entity.arangosearch.PrimarySort;
import com.arangodb.entity.arangosearch.SearchAliasIndex;
import com.arangodb.entity.arangosearch.SearchAliasProperties;
import com.arangodb.entity.arangosearch.StoreValuesType;
import com.arangodb.entity.arangosearch.StoredValue;
import com.arangodb.internal.velocystream.internal.AuthenticationRequest;
import com.arangodb.internal.velocystream.internal.JwtAuthenticationRequest;
import com.arangodb.model.CollectionSchema;
import com.arangodb.model.TraversalOptions;
import com.arangodb.model.ZKDIndexOptions;
import com.arangodb.model.arangosearch.ArangoSearchPropertiesOptions;
import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocystream.Request;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class VPackSerializers {
    public static final VPackSerializer<Request> REQUEST = (builder, attribute, value, context) -> {
        builder.add(attribute, ValueType.ARRAY);
        builder.add(Integer.valueOf(value.getVersion()));
        builder.add(Integer.valueOf(value.getType()));
        builder.add(value.getDbName().get());
        builder.add(Integer.valueOf(value.getRequestType().getType()));
        builder.add(value.getRequest());
        builder.add(ValueType.OBJECT);
        for (Map.Entry<String, String> entry : value.getQueryParam().entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        builder.close();
        builder.add(ValueType.OBJECT);
        for (Map.Entry<String, String> entry : value.getHeaderParam().entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        builder.close();
        builder.close();
    };
    public static final VPackSerializer<AuthenticationRequest> AUTH_REQUEST = (builder, attribute, value, context) -> {
        builder.add(attribute, ValueType.ARRAY);
        builder.add(Integer.valueOf(value.getVersion()));
        builder.add(Integer.valueOf(value.getType()));
        builder.add(value.getEncryption());
        builder.add(value.getUser());
        builder.add(value.getPassword());
        builder.close();
    };
    public static final VPackSerializer<JwtAuthenticationRequest> JWT_AUTH_REQUEST = (builder, attribute, value, context) -> {
        builder.add(attribute, ValueType.ARRAY);
        builder.add(Integer.valueOf(value.getVersion()));
        builder.add(Integer.valueOf(value.getType()));
        builder.add(value.getEncryption());
        builder.add(value.getToken());
        builder.close();
    };
    public static final VPackSerializer<CollectionType> COLLECTION_TYPE = (builder, attribute, value, context) -> builder.add(attribute, Integer.valueOf(value.getType()));
    public static final VPackSerializer<BaseDocument> BASE_DOCUMENT = (builder, attribute, value, context) -> {
        HashMap<String, Object> doc = new HashMap<String, Object>(value.getProperties());
        doc.put("_id", value.getId());
        doc.put("_key", value.getKey());
        doc.put("_rev", value.getRevision());
        context.serialize(builder, attribute, doc);
    };
    public static final VPackSerializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = (builder, attribute, value, context) -> {
        HashMap<String, Object> doc = new HashMap<String, Object>(value.getProperties());
        doc.put("_id", value.getId());
        doc.put("_key", value.getKey());
        doc.put("_rev", value.getRevision());
        doc.put("_from", value.getFrom());
        doc.put("_to", value.getTo());
        context.serialize(builder, attribute, doc);
    };
    public static final VPackSerializer<TraversalOptions.Order> TRAVERSAL_ORDER = (builder, attribute, value, context) -> {
        if (TraversalOptions.Order.preorder_expander == value) {
            builder.add(attribute, "preorder-expander");
        } else {
            builder.add(attribute, value.name());
        }
    };
    public static final VPackSerializer<LogLevel> LOG_LEVEL = (builder, attribute, value, context) -> builder.add(attribute, Integer.valueOf(value.getLevel()));
    public static final VPackSerializer<Permissions> PERMISSIONS = (builder, attribute, value, context) -> builder.add(attribute, value.toString().toLowerCase(Locale.ENGLISH));
    public static final VPackSerializer<ReplicationFactor> REPLICATION_FACTOR = (builder, attribute, value, context) -> {
        Boolean satellite = value.getSatellite();
        if (Boolean.TRUE == satellite) {
            builder.add(attribute, "satellite");
        } else if (value.getReplicationFactor() != null) {
            builder.add(attribute, value.getReplicationFactor());
        }
    };
    public static final VPackSerializer<MinReplicationFactor> MIN_REPLICATION_FACTOR = (builder, attribute, value, context) -> {
        if (value.getMinReplicationFactor() != null) {
            builder.add(attribute, value.getMinReplicationFactor());
        }
    };
    public static final VPackSerializer<ViewType> VIEW_TYPE = (builder, attribute, value, context) -> {
        if (value == ViewType.ARANGO_SEARCH) {
            builder.add(attribute, "arangosearch");
        } else if (value == ViewType.SEARCH_ALIAS) {
            builder.add(attribute, "search-alias");
        } else {
            throw new IllegalArgumentException();
        }
    };
    public static final VPackSerializer<ArangoSearchPropertiesOptions> ARANGO_SEARCH_PROPERTIES_OPTIONS = (builder, attribute, value, context) -> {
        builder.add(ValueType.OBJECT);
        context.serialize(builder, attribute, (Object)value.getProperties());
        builder.close();
    };
    public static final VPackSerializer<ArangoSearchProperties> ARANGO_SEARCH_PROPERTIES = (builder, attribute, value, context) -> {
        Collection<String> optimizeTopK;
        Collection<StoredValue> storedValues;
        ArangoSearchCompression arangoSearchCompression;
        Collection<PrimarySort> primarySorts;
        Collection<CollectionLink> links;
        Boolean primaryKeyCache;
        Long cleanupIntervalStep;
        Long commitIntervalMsec;
        Long consolidationIntervalMsec = value.getConsolidationIntervalMsec();
        if (consolidationIntervalMsec != null) {
            builder.add("consolidationIntervalMsec", consolidationIntervalMsec);
        }
        if ((commitIntervalMsec = value.getCommitIntervalMsec()) != null) {
            builder.add("commitIntervalMsec", commitIntervalMsec);
        }
        if ((cleanupIntervalStep = value.getCleanupIntervalStep()) != null) {
            builder.add("cleanupIntervalStep", cleanupIntervalStep);
        }
        context.serialize(builder, "consolidationPolicy", (Object)value.getConsolidationPolicy());
        Boolean primarySortCache = value.getPrimarySortCache();
        if (primarySortCache != null) {
            builder.add("primarySortCache", primarySortCache);
        }
        if ((primaryKeyCache = value.getPrimaryKeyCache()) != null) {
            builder.add("primaryKeyCache", primaryKeyCache);
        }
        if (!(links = value.getLinks()).isEmpty()) {
            builder.add("links", ValueType.OBJECT);
            for (CollectionLink collectionLink : links) {
                Boolean cache;
                Boolean inBackground;
                StoreValuesType storeValues;
                Boolean trackListPositions;
                Object includeAllFields;
                builder.add(collectionLink.getName(), ValueType.OBJECT);
                Collection<String> analyzers = collectionLink.getAnalyzers();
                if (!analyzers.isEmpty()) {
                    builder.add("analyzers", ValueType.ARRAY);
                    for (String analyzer : analyzers) {
                        builder.add(analyzer);
                    }
                    builder.close();
                }
                if ((includeAllFields = collectionLink.getIncludeAllFields()) != null) {
                    builder.add("includeAllFields", (Boolean)includeAllFields);
                }
                if ((trackListPositions = collectionLink.getTrackListPositions()) != null) {
                    builder.add("trackListPositions", trackListPositions);
                }
                if ((storeValues = collectionLink.getStoreValues()) != null) {
                    builder.add("storeValues", storeValues.name().toLowerCase(Locale.ENGLISH));
                }
                if ((inBackground = collectionLink.getInBackground()) != null) {
                    builder.add("inBackground", inBackground);
                }
                if ((cache = collectionLink.getCache()) != null) {
                    builder.add("cache", cache);
                }
                VPackSerializers.serializeFieldLinks(builder, collectionLink.getFields());
                VPackSerializers.serializeNested(builder, collectionLink.getNested());
                builder.close();
            }
            builder.close();
        }
        if (!(primarySorts = value.getPrimarySort()).isEmpty()) {
            builder.add("primarySort", ValueType.ARRAY);
            for (PrimarySort primarySort : primarySorts) {
                builder.add(ValueType.OBJECT);
                builder.add("field", primarySort.getFieldName());
                builder.add("asc", primarySort.getAscending());
                builder.close();
            }
            builder.close();
        }
        if ((arangoSearchCompression = value.getPrimarySortCompression()) != null) {
            builder.add("primarySortCompression", arangoSearchCompression.getValue());
        }
        if (!(storedValues = value.getStoredValues()).isEmpty()) {
            builder.add("storedValues", ValueType.ARRAY);
            for (StoredValue storedValue : storedValues) {
                context.serialize(builder, null, (Object)storedValue);
            }
            builder.close();
        }
        if (!(optimizeTopK = value.getOptimizeTopK()).isEmpty()) {
            builder.add("optimizeTopK", ValueType.ARRAY);
            for (String o : optimizeTopK) {
                context.serialize(builder, null, (Object)o);
            }
            builder.close();
        }
    };
    public static final VPackSerializer<SearchAliasProperties> SEARCH_ALIAS_PROPERTIES = (builder, attribute, value, context) -> {
        Collection<SearchAliasIndex> indexes = value.getIndexes();
        builder.add("indexes", ValueType.ARRAY);
        for (SearchAliasIndex index : indexes) {
            context.serialize(builder, null, (Object)index);
        }
        builder.close();
    };
    public static final VPackSerializer<SearchAliasIndex> SEARCH_ALIAS_INDEX = (builder, attribute, value, context) -> {
        builder.add(ValueType.OBJECT);
        builder.add("collection", value.getCollection());
        builder.add("index", value.getIndex());
        context.serialize(builder, "operation", (Object)value.getOperation());
        builder.close();
    };
    public static final VPackSerializer<StoredValue> STORED_VALUE = (builder, attribute, value, context) -> {
        builder.add(ValueType.OBJECT);
        builder.add("fields", ValueType.ARRAY);
        for (String field : value.getFields()) {
            builder.add(field);
        }
        builder.close();
        if (value.getCompression() != null) {
            builder.add("compression", value.getCompression().getValue());
        }
        if (value.getCache() != null) {
            builder.add("cache", value.getCache());
        }
        builder.close();
    };
    public static final VPackSerializer<InvertedIndexPrimarySort.Field> PRIMARY_SORT_FIELD = (builder, attribute, value, context) -> {
        builder.add(ValueType.OBJECT);
        builder.add("field", value.getField());
        builder.add("direction", value.getDirection().toString());
        builder.close();
    };
    public static final VPackSerializer<ConsolidationType> CONSOLIDATE_TYPE = (builder, attribute, value, context) -> builder.add(attribute, value.toString().toLowerCase(Locale.ENGLISH));
    public static final VPackSerializer<CollectionSchema> COLLECTION_VALIDATION = (builder, attribute, value, context) -> {
        VPackParser parser = new VPackParser.Builder().build();
        VPackSlice rule = value.getRule() != null ? parser.fromJson(value.getRule(), true) : null;
        HashMap<String, String> doc = new HashMap<String, String>();
        doc.put("message", value.getMessage());
        doc.put("level", value.getLevel() != null ? value.getLevel().getValue() : null);
        doc.put("rule", (String)rule);
        context.serialize(builder, attribute, doc);
    };
    public static final VPackSerializer<ZKDIndexOptions.FieldValueTypes> ZKD_FIELD_VALUE_TYPES = (builder, attribute, value, context) -> builder.add(attribute, value.name().toLowerCase(Locale.ENGLISH));

    private static void serializeFieldLinks(VPackBuilder builder, Collection<FieldLink> links) {
        if (!links.isEmpty()) {
            builder.add("fields", ValueType.OBJECT);
            VPackSerializers.serializeFields(builder, links);
            builder.close();
        }
    }

    private static void serializeNested(VPackBuilder builder, Collection<FieldLink> nested) {
        if (!nested.isEmpty()) {
            builder.add("nested", ValueType.OBJECT);
            VPackSerializers.serializeFields(builder, nested);
            builder.close();
        }
    }

    private static void serializeFields(VPackBuilder builder, Collection<FieldLink> links) {
        for (FieldLink fieldLink : links) {
            Boolean cache;
            Boolean inBackground;
            StoreValuesType storeValues;
            Boolean trackListPositions;
            Boolean includeAllFields;
            builder.add(fieldLink.getName(), ValueType.OBJECT);
            Collection<String> analyzers = fieldLink.getAnalyzers();
            if (!analyzers.isEmpty()) {
                builder.add("analyzers", ValueType.ARRAY);
                for (String analyzer : analyzers) {
                    builder.add(analyzer);
                }
                builder.close();
            }
            if ((includeAllFields = fieldLink.getIncludeAllFields()) != null) {
                builder.add("includeAllFields", includeAllFields);
            }
            if ((trackListPositions = fieldLink.getTrackListPositions()) != null) {
                builder.add("trackListPositions", trackListPositions);
            }
            if ((storeValues = fieldLink.getStoreValues()) != null) {
                builder.add("storeValues", storeValues.name().toLowerCase(Locale.ENGLISH));
            }
            if ((inBackground = fieldLink.getInBackground()) != null) {
                builder.add("inBackground", inBackground);
            }
            if ((cache = fieldLink.getCache()) != null) {
                builder.add("cache", cache);
            }
            VPackSerializers.serializeFieldLinks(builder, fieldLink.getFields());
            VPackSerializers.serializeNested(builder, fieldLink.getNested());
            builder.close();
        }
    }
}

