/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.Entity;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Response;
import java.lang.reflect.Type;

public abstract class ArangoExecutor {
    private final DocumentCache documentCache;
    private final ArangoSerializationFactory util;

    protected <T> T createResult(Type type, Response response) {
        if (type != Void.class && response.getBody() != null) {
            if (type instanceof Class && Entity.class.isAssignableFrom((Class)type)) {
                return this.util.get(ArangoSerializationFactory.Serializer.INTERNAL).deserialize(response.getBody(), type);
            }
            return this.util.get(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(response.getBody(), type);
        }
        return null;
    }

    protected ArangoExecutor(ArangoSerializationFactory util, DocumentCache documentCache) {
        this.documentCache = documentCache;
        this.util = util;
    }

    public DocumentCache documentCache() {
        return this.documentCache;
    }

    public static interface ResponseDeserializer<T> {
        public T deserialize(Response var1) throws VPackException;
    }
}

