/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import com.arangodb.internal.net.AccessType;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;

public final class RequestUtils {
    public static final String HEADER_ALLOW_DIRTY_READ = "X-Arango-Allow-Dirty-Read";

    private RequestUtils() {
    }

    public static Request allowDirtyRead(Request request) {
        return request.putHeaderParam(HEADER_ALLOW_DIRTY_READ, "true");
    }

    public static AccessType determineAccessType(Request request) {
        if (request.getHeaderParam().containsKey(HEADER_ALLOW_DIRTY_READ)) {
            return AccessType.DIRTY_READ;
        }
        if (request.getRequestType() == RequestType.GET) {
            return AccessType.READ;
        }
        return AccessType.WRITE;
    }
}

