/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.entity.ErrorEntity;

public class ArangoDBException
extends RuntimeException {
    private static final long serialVersionUID = 6165638002614173801L;
    private final ErrorEntity entity;
    private final Integer responseCode;

    public ArangoDBException(ErrorEntity errorEntity) {
        super(String.format("Response: %s, Error: %s - %s", errorEntity.getCode(), errorEntity.getErrorNum(), errorEntity.getErrorMessage()));
        this.entity = errorEntity;
        this.responseCode = null;
    }

    public ArangoDBException(String message) {
        super(message);
        this.entity = null;
        this.responseCode = null;
    }

    public ArangoDBException(String message, Integer responseCode) {
        super(message);
        this.entity = null;
        this.responseCode = responseCode;
    }

    public ArangoDBException(Throwable cause) {
        super(cause);
        this.entity = null;
        this.responseCode = null;
    }

    public String getErrorMessage() {
        return this.entity != null ? this.entity.getErrorMessage() : null;
    }

    public String getException() {
        return this.entity != null ? this.entity.getException() : null;
    }

    public Integer getResponseCode() {
        Integer entityResponseCode = this.entity != null ? Integer.valueOf(this.entity.getCode()) : null;
        return this.responseCode != null ? this.responseCode : entityResponseCode;
    }

    public Integer getErrorNum() {
        return this.entity != null ? Integer.valueOf(this.entity.getErrorNum()) : null;
    }
}

