/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.async.ArangoCollectionAsync;
import com.arangodb.async.ArangoCursorAsync;
import com.arangodb.async.ArangoDatabaseAsync;
import com.arangodb.async.ArangoGraphAsync;
import com.arangodb.async.ArangoRouteAsync;
import com.arangodb.async.ArangoSearchAsync;
import com.arangodb.async.ArangoViewAsync;
import com.arangodb.async.internal.ArangoCollectionAsyncImpl;
import com.arangodb.async.internal.ArangoCursorAsyncImpl;
import com.arangodb.async.internal.ArangoDBAsyncImpl;
import com.arangodb.async.internal.ArangoExecutorAsync;
import com.arangodb.async.internal.ArangoGraphAsyncImpl;
import com.arangodb.async.internal.ArangoRouteAsyncImpl;
import com.arangodb.async.internal.ArangoSearchAsyncImpl;
import com.arangodb.async.internal.ArangoViewAsyncImpl;
import com.arangodb.entity.AqlExecutionExplainEntity;
import com.arangodb.entity.AqlFunctionEntity;
import com.arangodb.entity.AqlParseEntity;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CursorEntity;
import com.arangodb.entity.DatabaseEntity;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryCachePropertiesEntity;
import com.arangodb.entity.QueryEntity;
import com.arangodb.entity.QueryTrackingPropertiesEntity;
import com.arangodb.entity.StreamTransactionEntity;
import com.arangodb.entity.TransactionEntity;
import com.arangodb.entity.TraversalEntity;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.AnalyzerEntity;
import com.arangodb.entity.arangosearch.analyzer.SearchAnalyzer;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlFunctionDeleteOptions;
import com.arangodb.model.AqlFunctionGetOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionsReadOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.StreamTransactionOptions;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.TraversalOptions;
import com.arangodb.model.arangosearch.AnalyzerDeleteOptions;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.velocypack.Type;
import com.arangodb.velocystream.Request;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class ArangoDatabaseAsyncImpl
extends InternalArangoDatabase<ArangoDBAsyncImpl, ArangoExecutorAsync>
implements ArangoDatabaseAsync {
    ArangoDatabaseAsyncImpl(ArangoDBAsyncImpl arangoDB, String name) {
        super(arangoDB, name);
    }

    @Override
    public CompletableFuture<ArangoDBVersion> getVersion() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getVersionRequest(), (java.lang.reflect.Type)((Object)ArangoDBVersion.class));
    }

    @Override
    public CompletableFuture<ArangoDBEngine> getEngine() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getEngineRequest(), (java.lang.reflect.Type)((Object)ArangoDBEngine.class));
    }

    @Override
    public CompletableFuture<Boolean> exists() {
        return ((CompletableFuture)this.getInfo().thenApply(Objects::nonNull)).exceptionally(Objects::isNull);
    }

    @Override
    public CompletableFuture<Collection<String>> getAccessibleDatabases() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getAccessibleDatabasesRequest(), this.getDatabaseResponseDeserializer());
    }

    @Override
    public ArangoCollectionAsync collection(String name) {
        return new ArangoCollectionAsyncImpl(this, name);
    }

    @Override
    public CompletableFuture<CollectionEntity> createCollection(String name) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createCollectionRequest(name, new CollectionCreateOptions()), (java.lang.reflect.Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> createCollection(String name, CollectionCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createCollectionRequest(name, options), (java.lang.reflect.Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<Collection<CollectionEntity>> getCollections() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getCollectionsRequest(new CollectionsReadOptions()), this.getCollectionsResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<CollectionEntity>> getCollections(CollectionsReadOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getCollectionsRequest(options), this.getCollectionsResponseDeserializer());
    }

    @Override
    public CompletableFuture<IndexEntity> getIndex(String id) {
        DocumentUtil.validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getIndex(split[1]);
    }

    @Override
    public CompletableFuture<String> deleteIndex(String id) {
        DocumentUtil.validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).deleteIndex(split[1]);
    }

    @Override
    public CompletableFuture<Boolean> create() {
        return ((ArangoDBAsyncImpl)this.arango()).createDatabase(this.name());
    }

    @Override
    public CompletableFuture<Boolean> drop() {
        return ((ArangoExecutorAsync)this.executor).execute(this.dropRequest(), this.createDropResponseDeserializer());
    }

    @Override
    public CompletableFuture<Void> grantAccess(String user, Permissions permissions) {
        return ((ArangoExecutorAsync)this.executor).execute(this.grantAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> grantAccess(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.grantAccessRequest(user, Permissions.RW), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> revokeAccess(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> resetAccess(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.resetAccessRequest(user), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> grantDefaultCollectionAccess(String user, Permissions permissions) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Permissions> getPermissions(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> query(String query, Map<String, Object> bindVars, AqlQueryOptions options, Class<T> type) {
        Request request = this.queryRequest(query, bindVars, options);
        HostHandle hostHandle = new HostHandle();
        CompletableFuture execution = ((ArangoExecutorAsync)this.executor).execute(request, (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
        return execution.thenApply(result -> this.createCursor((CursorEntity)result, type, options, hostHandle));
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> query(String query, AqlQueryOptions options, Class<T> type) {
        return this.query(query, null, options, type);
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> query(String query, Map<String, Object> bindVars, Class<T> type) {
        return this.query(query, bindVars, null, type);
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> query(String query, Class<T> type) {
        return this.query(query, null, null, type);
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> cursor(String cursorId, Class<T> type) {
        HostHandle hostHandle = new HostHandle();
        CompletableFuture execution = ((ArangoExecutorAsync)this.executor).execute(this.queryNextRequest(cursorId, null, null), (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
        return execution.thenApply(result -> this.createCursor((CursorEntity)result, type, null, hostHandle));
    }

    private <T> ArangoCursorAsync<T> createCursor(CursorEntity result, Class<T> type, final AqlQueryOptions options, final HostHandle hostHandle) {
        return new ArangoCursorAsyncImpl<T>(this, new ArangoCursorExecute(){

            @Override
            public CursorEntity next(String id, Map<String, String> meta) {
                CompletableFuture result = ((ArangoExecutorAsync)ArangoDatabaseAsyncImpl.this.executor).execute(ArangoDatabaseAsyncImpl.this.queryNextRequest(id, options, meta), (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
                try {
                    return (CursorEntity)result.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new ArangoDBException(e);
                }
            }

            @Override
            public void close(String id, Map<String, String> meta) {
                try {
                    ((ArangoExecutorAsync)ArangoDatabaseAsyncImpl.this.executor).execute(ArangoDatabaseAsyncImpl.this.queryCloseRequest(id, options, meta), (java.lang.reflect.Type)((Object)Void.class), hostHandle).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new ArangoDBException(e);
                }
            }
        }, type, result);
    }

    @Override
    public CompletableFuture<AqlExecutionExplainEntity> explainQuery(String query, Map<String, Object> bindVars, AqlQueryExplainOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.explainQueryRequest(query, bindVars, options), (java.lang.reflect.Type)((Object)AqlExecutionExplainEntity.class));
    }

    @Override
    public CompletableFuture<AqlParseEntity> parseQuery(String query) {
        return ((ArangoExecutorAsync)this.executor).execute(this.parseQueryRequest(query), (java.lang.reflect.Type)((Object)AqlParseEntity.class));
    }

    @Override
    public CompletableFuture<Void> clearQueryCache() {
        return ((ArangoExecutorAsync)this.executor).execute(this.clearQueryCacheRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<QueryCachePropertiesEntity> getQueryCacheProperties() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getQueryCachePropertiesRequest(), (java.lang.reflect.Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public CompletableFuture<QueryCachePropertiesEntity> setQueryCacheProperties(QueryCachePropertiesEntity properties) {
        return ((ArangoExecutorAsync)this.executor).execute(this.setQueryCachePropertiesRequest(properties), (java.lang.reflect.Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public CompletableFuture<QueryTrackingPropertiesEntity> getQueryTrackingProperties() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getQueryTrackingPropertiesRequest(), (java.lang.reflect.Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<QueryTrackingPropertiesEntity> setQueryTrackingProperties(QueryTrackingPropertiesEntity properties) {
        return ((ArangoExecutorAsync)this.executor).execute(this.setQueryTrackingPropertiesRequest(properties), (java.lang.reflect.Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<Collection<QueryEntity>> getCurrentlyRunningQueries() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getCurrentlyRunningQueriesRequest(), new Type<Collection<QueryEntity>>(){}.getType());
    }

    @Override
    public CompletableFuture<Collection<QueryEntity>> getSlowQueries() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getSlowQueriesRequest(), new Type<Collection<QueryEntity>>(){}.getType());
    }

    @Override
    public CompletableFuture<Void> clearSlowQueries() {
        return ((ArangoExecutorAsync)this.executor).execute(this.clearSlowQueriesRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> killQuery(String id) {
        return ((ArangoExecutorAsync)this.executor).execute(this.killQueryRequest(id), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> createAqlFunction(String name, String code, AqlFunctionCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createAqlFunctionRequest(name, code, options), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Integer> deleteAqlFunction(String name, AqlFunctionDeleteOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteAqlFunctionRequest(name, options), this.deleteAqlFunctionResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<AqlFunctionEntity>> getAqlFunctions(AqlFunctionGetOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getAqlFunctionsRequest(options), this.getAqlFunctionsResponseDeserializer());
    }

    @Override
    public ArangoGraphAsync graph(String name) {
        return new ArangoGraphAsyncImpl(this, name);
    }

    @Override
    public CompletableFuture<GraphEntity> createGraph(String name, Collection<EdgeDefinition> edgeDefinitions) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createGraphRequest(name, edgeDefinitions, new GraphCreateOptions()), this.createGraphResponseDeserializer());
    }

    @Override
    public CompletableFuture<GraphEntity> createGraph(String name, Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createGraphRequest(name, edgeDefinitions, options), this.createGraphResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<GraphEntity>> getGraphs() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getGraphsRequest(), this.getGraphsResponseDeserializer());
    }

    @Override
    public <T> CompletableFuture<T> transaction(String action, Class<T> type, TransactionOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.transactionRequest(action, options), this.transactionResponseDeserializer(type));
    }

    @Override
    public CompletableFuture<StreamTransactionEntity> beginStreamTransaction(StreamTransactionOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.beginStreamTransactionRequest(options), this.streamTransactionResponseDeserializer());
    }

    @Override
    public CompletableFuture<StreamTransactionEntity> abortStreamTransaction(String id) {
        return ((ArangoExecutorAsync)this.executor).execute(this.abortStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public CompletableFuture<StreamTransactionEntity> getStreamTransaction(String id) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<TransactionEntity>> getStreamTransactions() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getStreamTransactionsRequest(), this.transactionsResponseDeserializer());
    }

    @Override
    public CompletableFuture<StreamTransactionEntity> commitStreamTransaction(String id) {
        return ((ArangoExecutorAsync)this.executor).execute(this.commitStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public CompletableFuture<DatabaseEntity> getInfo() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    @Override
    public <V, E> CompletableFuture<TraversalEntity<V, E>> executeTraversal(Class<V> vertexClass, Class<E> edgeClass, TraversalOptions options) {
        Request request = this.executeTraversalRequest(options);
        return ((ArangoExecutorAsync)this.executor).execute(request, this.executeTraversalResponseDeserializer(vertexClass, edgeClass));
    }

    @Override
    public <T> CompletableFuture<T> getDocument(String id, Class<T> type) throws ArangoDBException {
        DocumentUtil.validateDocumentId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getDocument(split[1], type);
    }

    @Override
    public <T> CompletableFuture<T> getDocument(String id, Class<T> type, DocumentReadOptions options) throws ArangoDBException {
        DocumentUtil.validateDocumentId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getDocument(split[1], type, options);
    }

    @Override
    public CompletableFuture<Void> reloadRouting() {
        return ((ArangoExecutorAsync)this.executor).execute(this.reloadRoutingRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public ArangoRouteAsync route(String ... path) {
        return new ArangoRouteAsyncImpl(this, String.join((CharSequence)"/", path), Collections.emptyMap());
    }

    @Override
    public CompletableFuture<Collection<ViewEntity>> getViews() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getViewsRequest(), this.getViewsResponseDeserializer());
    }

    @Override
    public ArangoViewAsync view(String name) {
        return new ArangoViewAsyncImpl(this, name);
    }

    @Override
    public ArangoSearchAsync arangoSearch(String name) {
        return new ArangoSearchAsyncImpl(this, name);
    }

    @Override
    public CompletableFuture<ViewEntity> createView(String name, ViewType type) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createViewRequest(name, type), (java.lang.reflect.Type)((Object)ViewEntity.class));
    }

    @Override
    public CompletableFuture<ViewEntity> createArangoSearch(String name, ArangoSearchCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createArangoSearchRequest(name, options), (java.lang.reflect.Type)((Object)ViewEntity.class));
    }

    @Override
    public CompletableFuture<AnalyzerEntity> createAnalyzer(AnalyzerEntity options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createAnalyzerRequest(options), (java.lang.reflect.Type)((Object)AnalyzerEntity.class));
    }

    @Override
    public CompletableFuture<SearchAnalyzer> createSearchAnalyzer(SearchAnalyzer analyzer) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createAnalyzerRequest(analyzer), (java.lang.reflect.Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public CompletableFuture<AnalyzerEntity> getAnalyzer(String name) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getAnalyzerRequest(name), (java.lang.reflect.Type)((Object)AnalyzerEntity.class));
    }

    @Override
    public CompletableFuture<SearchAnalyzer> getSearchAnalyzer(String name) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getAnalyzerRequest(name), (java.lang.reflect.Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public CompletableFuture<Collection<AnalyzerEntity>> getAnalyzers() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getAnalyzersRequest(), this.getAnalyzersResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<SearchAnalyzer>> getSearchAnalyzers() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getAnalyzersRequest(), this.getSearchAnalyzersResponseDeserializer());
    }

    @Override
    public CompletableFuture<Void> deleteAnalyzer(String name) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteAnalyzerRequest(name, null), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> deleteAnalyzer(String name, AnalyzerDeleteOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteAnalyzerRequest(name, options), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> deleteSearchAnalyzer(String name) {
        return this.deleteAnalyzer(name);
    }

    @Override
    public CompletableFuture<Void> deleteSearchAnalyzer(String name, AnalyzerDeleteOptions options) {
        return this.deleteAnalyzer(name, options);
    }
}

