/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.cursor;

import com.arangodb.ArangoIterable;
import com.arangodb.Function;
import com.arangodb.Predicate;
import com.arangodb.internal.cursor.ArangoFilterIterable;
import com.arangodb.internal.cursor.ArangoMappingIterable;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractArangoIterable<T>
implements ArangoIterable<T> {
    @Override
    public <R> ArangoIterable<R> map(Function<? super T, ? extends R> mapper) {
        return new ArangoMappingIterable<T, R>(this, mapper);
    }

    @Override
    public ArangoIterable<T> filter(Predicate<? super T> predicate) {
        return new ArangoFilterIterable<T>(this, predicate);
    }

    @Override
    public T first() {
        Iterator iterator = this.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    @Override
    public long count() {
        long count = 0L;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        boolean match = false;
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            match = true;
            break;
        }
        return match;
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        Object t;
        boolean match = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && (match = predicate.test(t = iterator.next()))) {
        }
        return match;
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        Object t;
        boolean match = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && (match = !predicate.test(t = iterator.next()))) {
        }
        return match;
    }

    @Override
    public <R extends Collection<? super T>> R collectInto(R target) {
        for (Object t : this) {
            target.add(t);
        }
        return target;
    }
}

