/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static String toString(InputStream input) throws IOException {
        return IOUtils.toString(input, "utf-8");
    }

    public static String toString(InputStream input, String encode) throws IOException {
        try {
            int len;
            StringBuilder buffer = new StringBuilder(8012);
            InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(input), encode);
            char[] cbuf = new char[8012];
            while ((len = in.read(cbuf)) != -1) {
                buffer.append(cbuf, 0, len);
            }
            String string = buffer.toString();
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8012];
        while ((nRead = input.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

