/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.ViewRenameOptions;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;

public abstract class InternalArangoView<A extends InternalArangoDB<E>, D extends InternalArangoDatabase<A, E>, E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    protected static final String PATH_API_VIEW = "/_api/view";
    protected static final String PATH_API_ANALYZER = "/_api/analyzer";
    protected final D db;
    protected volatile String name;

    protected InternalArangoView(D db, String name) {
        super(((InternalArangoDatabase)db).executor, ((InternalArangoDatabase)db).util, ((InternalArangoDatabase)db).context);
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected Request dropRequest() {
        return this.request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, PATH_API_VIEW, this.name);
    }

    protected Request renameRequest(String newName) {
        Request request = this.request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, PATH_API_VIEW, this.name, "rename");
        request.setBody(this.util().serialize(OptionsBuilder.build(new ViewRenameOptions(), newName)));
        return request;
    }

    protected Request getInfoRequest() {
        return this.request(((InternalArangoDatabase)this.db).name(), RequestType.GET, PATH_API_VIEW, this.name);
    }
}

