/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.arangodb.commons;

import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.Request;
import com.arangodb.Response;
import com.arangodb.util.RawBytes;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.arangodb.commons.ArangoClient;
import org.apache.spark.sql.arangodb.commons.ArangoDBConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.runtime.BoxesRunTime;

public final class ArangoClient$
implements Logging {
    public static ArangoClient$ MODULE$;
    private final int INTERNAL_ERROR_CODE;
    private final int SHARDS_API_UNAVAILABLE_CODE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ArangoClient$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int INTERNAL_ERROR_CODE() {
        return this.INTERNAL_ERROR_CODE;
    }

    private int SHARDS_API_UNAVAILABLE_CODE() {
        return this.SHARDS_API_UNAVAILABLE_CODE;
    }

    public ArangoClient apply(ArangoDBConf options) {
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "creating db client");
        return new ArangoClient(options);
    }

    public String[] getCollectionShardIds(ArangoDBConf options) {
        String[] stringArray;
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "reading collection shards");
        ArangoClient client = this.apply(options);
        ArangoDB adb = client.arangoDB();
        try {
            Response res = adb.execute(new Request.Builder().db(options.readOptions().db()).method(Request.Method.GET).path(new StringBuilder(24).append("/_api/collection/").append(options.readOptions().collection().get()).append("/shards").toString()).build(), RawBytes.class);
            String[] shardIds = (String[])adb.getSerde().deserialize(((RawBytes)res.getBody()).get(), "/shards", String[].class);
            client.shutdown();
            stringArray = shardIds;
        }
        catch (ArangoDBException e) {
            client.shutdown();
            if (((Object)BoxesRunTime.boxToInteger((int)this.INTERNAL_ERROR_CODE())).equals(e.getErrorNum()) || ((Object)BoxesRunTime.boxToInteger((int)this.SHARDS_API_UNAVAILABLE_CODE())).equals(e.getErrorNum())) {
                stringArray = (String[])((Object[])new String[]{""});
            }
            throw e;
        }
        return stringArray;
    }

    public Iterable<String> acquireHostList(ArangoDBConf options) {
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "acquiring host list");
        ArangoClient client = this.apply(options);
        ArangoDB adb = client.arangoDB();
        Response response = adb.execute(new Request.Builder().method(Request.Method.GET).path("/_api/cluster/endpoints").build(), RawBytes.class);
        Seq res = (Seq)((TraversableLike)adb.getSerde().deserialize(((RawBytes)response.getBody()).get(), "/endpoints", Seq.class)).map((Function1 & java.io.Serializable & Serializable)it -> ((String)it.apply((Object)"endpoint")).replaceFirst(".*://", ""), Seq$.MODULE$.canBuildFrom());
        client.shutdown();
        return res;
    }

    private ArangoClient$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.INTERNAL_ERROR_CODE = 4;
        this.SHARDS_API_UNAVAILABLE_CODE = 9;
    }
}

