/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.arangodb.commons;

import com.arangodb.ArangoCursor;
import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.Request;
import com.arangodb.Response;
import com.arangodb.entity.ErrorEntity;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.serde.InternalSerdeProvider;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.serde.ArangoSerde;
import com.arangodb.shaded.fasterxml.jackson.databind.JsonNode;
import com.arangodb.util.RawBytes;
import com.arangodb.util.RawJson;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.arangodb.commons.ArangoClient$;
import org.apache.spark.sql.arangodb.commons.ArangoDBConf;
import org.apache.spark.sql.arangodb.commons.ContentType;
import org.apache.spark.sql.arangodb.commons.ContentType$JSON$;
import org.apache.spark.sql.arangodb.commons.ContentType$VPACK$;
import org.apache.spark.sql.arangodb.commons.PushdownUtils$;
import org.apache.spark.sql.arangodb.commons.exceptions.ArangoDBMultiException;
import org.apache.spark.sql.arangodb.commons.filter.PushableFilter;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\u000e\u001c\u0001!B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\u0006}\u0001!Ia\u0010\u0005\t\u0013\u0002A)\u0019!C\u0001\u0015\"Aq\n\u0001EC\u0002\u0013\u0005\u0001\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0003]\u0001\u0011\u0005Q\fC\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005U\u0001bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\u0007\u0003k\u0001A\u0011\u0001-\t\r\u0005]\u0002\u0001\"\u0002Y\u0011\u0019\t9\u0005\u0001C\u00011\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-saBA67!\u0005\u0011Q\u000e\u0004\u00075mA\t!a\u001c\t\ri\nB\u0011AA9\u0011%\t\u0019(\u0005b\u0001\n\u0013\t)\b\u0003\u0005\u0002~E\u0001\u000b\u0011BA<\u0011%\ty(\u0005b\u0001\n\u0013\t)\b\u0003\u0005\u0002\u0002F\u0001\u000b\u0011BA<\u0011\u001d\t\u0019)\u0005C\u0001\u0003\u000bCq!!#\u0012\t\u0003\tY\tC\u0004\u0002\u0012F!\t!a%\u0003\u0019\u0005\u0013\u0018M\\4p\u00072LWM\u001c;\u000b\u0005qi\u0012aB2p[6|gn\u001d\u0006\u0003=}\t\u0001\"\u0019:b]\u001e|GM\u0019\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0004\u0001%z\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021g5\t\u0011G\u0003\u00023C\u0005A\u0011N\u001c;fe:\fG.\u0003\u00025c\t9Aj\\4hS:<\u0017aB8qi&|gn\u001d\t\u0003oaj\u0011aG\u0005\u0003sm\u0011A\"\u0011:b]\u001e|GIQ\"p]\u001a\fa\u0001P5oSRtDC\u0001\u001f>!\t9\u0004\u0001C\u00036\u0005\u0001\u0007a'\u0001\u0006bc2|\u0005\u000f^5p]N$\u0012\u0001\u0011\t\u0003\u0003\u001ek\u0011A\u0011\u0006\u0003\u0007\u0012\u000bQ!\\8eK2T!AH#\u000b\u0003\u0019\u000b1aY8n\u0013\tA%IA\bBc2\fV/\u001a:z\u001fB$\u0018n\u001c8t\u0003!\t'/\u00198h_\u0012\u0013U#A&\u0011\u00051kU\"\u0001#\n\u00059#%\u0001C!sC:<w\u000e\u0012\"\u0002\u000bM,'\u000fZ3\u0016\u0003E\u0003\"AU+\u000e\u0003MS!a\u0014+\u000b\u0005I\"\u0015B\u0001,T\u00055Ie\u000e^3s]\u0006d7+\u001a:eK\u0006A1\u000f[;uI><h\u000eF\u0001Z!\tQ#,\u0003\u0002\\W\t!QK\\5u\u0003]\u0011X-\u00193D_2dWm\u0019;j_:\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003_OR|\bc\u0001'`C&\u0011\u0001\r\u0012\u0002\r\u0003J\fgnZ8DkJ\u001cxN\u001d\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\u0012\u000bA!\u001e;jY&\u0011am\u0019\u0002\t%\u0006<()\u001f;fg\")\u0001n\u0002a\u0001S\u000691\u000f[1sI&#\u0007C\u00016r\u001d\tYw\u000e\u0005\u0002mW5\tQN\u0003\u0002oO\u00051AH]8pizJ!\u0001]\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u00118O\u0001\u0004TiJLgn\u001a\u0006\u0003a.BQ!^\u0004A\u0002Y\fqAZ5mi\u0016\u00148\u000fE\u0002+ofL!\u0001_\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ilX\"A>\u000b\u0005q\\\u0012A\u00024jYR,'/\u0003\u0002\u007fw\nq\u0001+^:iC\ndWMR5mi\u0016\u0014\bbBA\u0001\u000f\u0001\u0007\u00111A\u0001\u0007g\u000eDW-\\1\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003 \u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti!a\u0002\u0003\u0015M#(/^2u)f\u0004X-A\u0005sK\u0006$\u0017+^3ssR\ta,\u0001\u000bsK\u0006$7i\u001c7mK\u000e$\u0018n\u001c8TC6\u0004H.\u001a\u000b\u0003\u0003/\u0001R!!\u0007\u0002$%tA!a\u0007\u0002 9\u0019A.!\b\n\u00031J1!!\t,\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\n\u0002(\t\u00191+Z9\u000b\u0007\u0005\u00052&A\bsK\u0006$\u0017+^3ssN\u000bW\u000e\u001d7f\u0003A\u0019w\u000e\u001c7fGRLwN\\#ySN$8\u000f\u0006\u0002\u00020A\u0019!&!\r\n\u0007\u0005M2FA\u0004C_>dW-\u00198\u0002!\r\u0014X-\u0019;f\u0007>dG.Z2uS>t\u0017\u0001\u0003;sk:\u001c\u0017\r^3)\u00075\tY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\teK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA#\u0003\u007f\u0011q\u0001^1jYJ,7-\u0001\u0003ee>\u0004\u0018!D:bm\u0016$unY;nK:$8\u000fF\u0002Z\u0003\u001bBa!a\u0014\u0010\u0001\u0004\t\u0017\u0001\u00023bi\u0006Ds\u0001AA*\u0003G\n)\u0007\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0003;\nAA[1wC&!\u0011\u0011MA,\u0005A\u0019V\u000f\u001d9sKN\u001cx+\u0019:oS:<7/A\u0003wC2,X\r\f\u0002\u0002h\u0005\u0012\u0011\u0011N\u0001\n\u001fB$\u0018n\u001c8HKR\fA\"\u0011:b]\u001e|7\t\\5f]R\u0004\"aN\t\u0014\u0007EIs\u0006\u0006\u0002\u0002n\u0005\u0019\u0012J\u0014+F%:\u000bEjX#S%>\u0013vlQ(E\u000bV\u0011\u0011q\u000f\t\u0004U\u0005e\u0014bAA>W\t\u0019\u0011J\u001c;\u0002)%sE+\u0012*O\u00032{VI\u0015*P%~\u001bu\nR#!\u0003m\u0019\u0006*\u0011*E'~\u000b\u0005+S0V\u001d\u00063\u0016)\u0013'B\u00052+ulQ(E\u000b\u0006a2\u000bS!S\tN{\u0016\tU%`+:\u000be+Q%M\u0003\ncUiX\"P\t\u0016\u0003\u0013!B1qa2LHc\u0001\u001f\u0002\b\")Qg\u0006a\u0001m\u0005)r-\u001a;D_2dWm\u0019;j_:\u001c\u0006.\u0019:e\u0013\u0012\u001cH\u0003BAG\u0003\u001f\u00032AK<j\u0011\u0015)\u0004\u00041\u00017\u0003=\t7-];je\u0016Dun\u001d;MSN$H\u0003BAK\u00037\u0003R!!\u0007\u0002\u0018&LA!!'\u0002(\tA\u0011\n^3sC\ndW\rC\u000363\u0001\u0007a\u0007K\u0004\u0012\u0003'\n\u0019'a(-\u0005\u0005\u001d\u0004f\u0002\t\u0002T\u0005\r\u0014q\u0014")
public class ArangoClient
implements Logging {
    private ArangoDB arangoDB;
    private InternalSerde serde;
    private final ArangoDBConf options;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Iterable<String> acquireHostList(ArangoDBConf arangoDBConf) {
        return ArangoClient$.MODULE$.acquireHostList(arangoDBConf);
    }

    public static String[] getCollectionShardIds(ArangoDBConf arangoDBConf) {
        return ArangoClient$.MODULE$.getCollectionShardIds(arangoDBConf);
    }

    public static ArangoClient apply(ArangoDBConf arangoDBConf) {
        return ArangoClient$.MODULE$.apply(arangoDBConf);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private AqlQueryOptions aqlOptions() {
        void var1_1;
        AqlQueryOptions opt = new AqlQueryOptions().stream(Predef$.MODULE$.boolean2Boolean(this.options.readOptions().stream())).fillBlockCache(Predef$.MODULE$.boolean2Boolean(this.options.readOptions().fillBlockCache())).batchSize(Predef$.MODULE$.int2Integer(this.options.readOptions().batchSize()));
        return var1_1;
    }

    private ArangoDB arangoDB$lzycompute() {
        ArangoClient arangoClient = this;
        synchronized (arangoClient) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                com.arangodb.ContentType contentType;
                ContentType contentType2 = this.options.driverOptions().contentType();
                if (ContentType$JSON$.MODULE$.equals(contentType2)) {
                    contentType = com.arangodb.ContentType.JSON;
                } else if (ContentType$VPACK$.MODULE$.equals(contentType2)) {
                    contentType = com.arangodb.ContentType.VPACK;
                } else {
                    throw new MatchError((Object)contentType2);
                }
                InternalSerde serde = new InternalSerdeProvider(contentType).create();
                this.arangoDB = ((ArangoDB.Builder)this.options.driverOptions().builder().serde((ArangoSerde)serde)).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.arangoDB;
    }

    public ArangoDB arangoDB() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.arangoDB$lzycompute() : this.arangoDB;
    }

    private InternalSerde serde$lzycompute() {
        ArangoClient arangoClient = this;
        synchronized (arangoClient) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.serde = this.arangoDB().getSerde();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.serde;
    }

    public InternalSerde serde() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.serde$lzycompute() : this.serde;
    }

    public void shutdown() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "closing db client");
        this.arangoDB().shutdown();
    }

    public ArangoCursor<RawBytes> readCollectionPartition(String shardId, PushableFilter[] filters, StructType schema) {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(54).append("\n         |FOR d IN @@col\n         |").append(PushdownUtils$.MODULE$.generateFilterClause(filters)).append("\n         |RETURN ").append(PushdownUtils$.MODULE$.generateColumnsFilter(schema, "d")).toString())).stripMargin().replaceAll("\n", " ");
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@col"), this.options.readOptions().collection().get())}));
        AqlQueryOptions opts = this.aqlOptions().shardIds(new String[]{shardId});
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Executing AQL query: \n\t").append(query).append(" ").append((Object)(params.nonEmpty() ? new StringBuilder(16).append("\n\t with params: ").append(params).toString() : "")).toString());
        return this.arangoDB().db(this.options.readOptions().db()).query(query, RawBytes.class, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)params).asJava(), opts);
    }

    public ArangoCursor<RawBytes> readQuery() {
        String query = (String)this.options.readOptions().query().get();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Executing AQL query: \n\t").append(query).toString());
        return this.arangoDB().db(this.options.readOptions().db()).query(query, RawBytes.class, this.aqlOptions());
    }

    public Seq<String> readCollectionSample() {
        String query = "FOR d IN @@col LIMIT @size RETURN d";
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@col"), this.options.readOptions().collection().get()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)Predef$.MODULE$.int2Integer(this.options.readOptions().sampleSize()))}));
        AqlQueryOptions opts = this.aqlOptions();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Executing AQL query: \n\t").append(query).append(" ").append((Object)(params.nonEmpty() ? new StringBuilder(16).append("\n\t with params: ").append(params).toString() : "")).toString());
        return (Seq)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.arangoDB().db(this.options.readOptions().db()).query(query, RawJson.class, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)params).asJava(), opts).asListRemaining()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> readQuerySample() {
        String query = (String)this.options.readOptions().query().get();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Executing AQL query: \n\t").append(query).toString());
        ArangoCursor cursor = this.arangoDB().db(this.options.readOptions().db()).query(query, RawJson.class, this.aqlOptions());
        return (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)cursor).asScala()).take(this.options.readOptions().sampleSize()).toSeq().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(), Seq$.MODULE$.canBuildFrom());
    }

    public boolean collectionExists() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "checking collection");
        return this.arangoDB().db(this.options.writeOptions().db()).collection(this.options.writeOptions().collection()).exists();
    }

    public void createCollection() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "creating collection");
        CollectionCreateOptions opts = new CollectionCreateOptions().numberOfShards(Predef$.MODULE$.int2Integer(this.options.writeOptions().numberOfShards())).type(this.options.writeOptions().collectionType());
        this.arangoDB().db(this.options.writeOptions().db()).collection(this.options.writeOptions().collection()).create(opts);
    }

    public final void truncate() {
        while (true) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "truncating collection");
            try {
                this.arangoDB().db(this.options.writeOptions().db()).collection(this.options.writeOptions().collection()).truncate();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "truncated collection");
            }
            catch (ArangoDBException e) {
                if (e.getCause() instanceof TimeoutException) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got TimeoutException while truncating collection, retrying...");
                    continue;
                }
                throw e;
            }
            catch (Throwable t) {
                throw t;
            }
            break;
        }
    }

    public void drop() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "dropping collection");
        this.arangoDB().db(this.options.writeOptions().db()).collection(this.options.writeOptions().collection()).drop();
    }

    public void saveDocuments(RawBytes data) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "saving batch");
        Request request = new Request.Builder().db(this.options.writeOptions().db()).method(Request.Method.POST).path(new StringBuilder(15).append("/_api/document/").append(this.options.writeOptions().collection()).toString()).queryParam("waitForSync", Boolean.toString(this.options.writeOptions().waitForSync())).queryParam("overwriteMode", this.options.writeOptions().overwriteMode().getValue()).queryParam("keepNull", Boolean.toString(this.options.writeOptions().keepNull())).queryParam("mergeObjects", Boolean.toString(this.options.writeOptions().mergeObjects())).header("x-arango-spark-request-id", UUID.randomUUID().toString()).body((Object)RawBytes.of((byte[])data.get())).build();
        Response response = this.arangoDB().execute(request, RawBytes.class);
        Tuple2[] errors = (Tuple2[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.serde().parse(((RawBytes)response.getBody()).get()).iterator()).asScala()).zip((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.serde().parse(data.get()).iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArangoClient.$anonfun$saveDocuments$2(x$3))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ArangoClient.$anonfun$saveDocuments$3(x$4))).map((Function1 & Serializable & scala.Serializable)it -> new Tuple2(this.serde().deserialize((JsonNode)it._1(), ErrorEntity.class), (Object)it._2().toString())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])errors)).nonEmpty()) {
            throw new ArangoDBMultiException(errors);
        }
    }

    public static final /* synthetic */ boolean $anonfun$saveDocuments$2(Tuple2 x$3) {
        return ((JsonNode)x$3._1()).has("error");
    }

    public static final /* synthetic */ boolean $anonfun$saveDocuments$3(Tuple2 x$4) {
        return ((JsonNode)x$4._1()).get("error").booleanValue();
    }

    public ArangoClient(ArangoDBConf options) {
        this.options = options;
        Logging.$init$((Logging)this);
    }
}

