/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.arangodb.commons;

import com.arangodb.ArangoDB;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.spark.sql.arangodb.commons.ArangoDBConf;
import org.apache.spark.sql.arangodb.commons.ArangoDBConf$;
import org.apache.spark.sql.arangodb.commons.ContentType;
import org.apache.spark.sql.arangodb.commons.ContentType$;
import org.apache.spark.sql.arangodb.commons.ContentType$JSON$;
import org.apache.spark.sql.arangodb.commons.ContentType$VPACK$;
import org.apache.spark.sql.arangodb.commons.Protocol;
import org.apache.spark.sql.arangodb.commons.Protocol$;
import org.apache.spark.sql.arangodb.commons.Protocol$HTTP$;
import org.apache.spark.sql.arangodb.commons.Protocol$VST$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0011#\u0001=B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006\u000b\u0002!\tA\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019Y\u0005\u0001)A\u0005\u0005\"9A\n\u0001b\u0001\n\u0003i\u0005B\u0002*\u0001A\u0003%a\nC\u0004T\u0001\t\u0007I\u0011\u0001+\t\ra\u0003\u0001\u0015!\u0003V\u0011\u001dI\u0006A1A\u0005\u0002iCaA\u0018\u0001!\u0002\u0013Y\u0006bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007I\u0002\u0001\u000b\u0011B1\t\u000f\u0015\u0004!\u0019!C\u0001M\"1!\u000e\u0001Q\u0001\n\u001dDqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004u\u0001\u0001\u0006I!\u001c\u0005\bk\u0002\u0011\r\u0011\"\u0001[\u0011\u00191\b\u0001)A\u00057\"9q\u000f\u0001b\u0001\n\u0003i\u0005B\u0002=\u0001A\u0003%a\nC\u0004z\u0001\t\u0007I\u0011\u0001&\t\ri\u0004\u0001\u0015!\u0003C\u0011\u001dY\bA1A\u0005\u0002)Ca\u0001 \u0001!\u0002\u0013\u0011\u0005bB?\u0001\u0005\u0004%\tA\u0013\u0005\u0007}\u0002\u0001\u000b\u0011\u0002\"\t\u000f}\u0004!\u0019!C\u0001\u0015\"9\u0011\u0011\u0001\u0001!\u0002\u0013\u0011\u0005\u0002CA\u0002\u0001\t\u0007I\u0011\u0001&\t\u000f\u0005\u0015\u0001\u0001)A\u0005\u0005\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0002\u0013\u0003J\fgnZ8E\u0005\u0012\u0013\u0018N^3s\u0007>tgM\u0003\u0002$I\u000591m\\7n_:\u001c(BA\u0013'\u0003!\t'/\u00198h_\u0012\u0014'BA\u0014)\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003S)\nQa\u001d9be.T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO\u000e\u00011C\u0001\u00011!\t\t$'D\u0001#\u0013\t\u0019$E\u0001\u0007Be\u0006twm\u001c#C\u0007>tg-\u0001\u0003paR\u001c\b\u0003\u0002\u001c@\u0005\ns!aN\u001f\u0011\u0005aZT\"A\u001d\u000b\u0005ir\u0013A\u0002\u001fs_>$hHC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u00131!T1q\u0015\tq4\b\u0005\u00027\u0007&\u0011A)\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002\rqJg.\u001b;?)\t9\u0005\n\u0005\u00022\u0001!)AG\u0001a\u0001k\u0005!Qo]3s+\u0005\u0011\u0015!B;tKJ\u0004\u0013\u0001\u00039bgN<xN\u001d3\u0016\u00039\u00032a\u0014)C\u001b\u0005Y\u0014BA)<\u0005\u0019y\u0005\u000f^5p]\u0006I\u0001/Y:to>\u0014H\rI\u0001\nK:$\u0007o\\5oiN,\u0012!\u0016\t\u0004\u001fZ\u0013\u0015BA,<\u0005\u0015\t%O]1z\u0003))g\u000e\u001a9pS:$8\u000fI\u0001\u0010C\u000e\fX/\u001b:f\u0011>\u001cH\u000fT5tiV\t1\f\u0005\u0002P9&\u0011Ql\u000f\u0002\b\u0005>|G.Z1o\u0003A\t7-];je\u0016Dun\u001d;MSN$\b%A\u0006d_:$XM\u001c;UsB,W#A1\u0011\u0005E\u0012\u0017BA2#\u0005-\u0019uN\u001c;f]R$\u0016\u0010]3\u0002\u0019\r|g\u000e^3oiRK\b/\u001a\u0011\u0002\u000fQLW.Z8viV\tq\r\u0005\u0002PQ&\u0011\u0011n\u000f\u0002\u0004\u0013:$\u0018\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\u0002\u001d\u0005\u0014\u0018M\\4p!J|Go\\2pYV\tQ\u000e\u0005\u0002oe6\tqN\u0003\u0002&a*\t\u0011/A\u0002d_6L!a]8\u0003\u0011A\u0013x\u000e^8d_2\fq\"\u0019:b]\u001e|\u0007K]8u_\u000e|G\u000eI\u0001\u000bgNdWI\\1cY\u0016$\u0017aC:tY\u0016s\u0017M\u00197fI\u0002\nAb]:m\u0007\u0016\u0014HOV1mk\u0016\fQb]:m\u0007\u0016\u0014HOV1mk\u0016\u0004\u0013aC:tY\u000e+'\u000f\u001e+za\u0016\fAb]:m\u0007\u0016\u0014H\u000fV=qK\u0002\nAb]:m\u0007\u0016\u0014H/\u00117jCN\fQb]:m\u0007\u0016\u0014H/\u00117jCN\u0004\u0013\u0001D:tY\u0006cwm\u001c:ji\"l\u0017!D:tY\u0006cwm\u001c:ji\"l\u0007%A\btg2\\U-_:u_J,G+\u001f9f\u0003A\u00198\u000f\\&fsN$xN]3UsB,\u0007%A\u0006tg2\u0004&o\u001c;pG>d\u0017\u0001D:tYB\u0013x\u000e^8d_2\u0004\u0013a\u00022vS2$WM\u001d\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00149\u0019a.a\u0004\n\u0007\u0005Eq.\u0001\u0005Be\u0006twm\u001c#C\u0013\u0011\t)\"a\u0006\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0019\u0011\u0011C8\u0002\u001b\u001d,GoU:m\u0007>tG/\u001a=u+\t\ti\u0002\u0005\u0003\u0002 \u00055RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u0007M\u001cHN\u0003\u0003\u0002(\u0005%\u0012a\u00018fi*\u0011\u00111F\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003_\t\tC\u0001\u0006T'2\u001buN\u001c;fqR\u0004")
public class ArangoDBDriverConf
extends ArangoDBConf {
    private final String user;
    private final Option<String> password;
    private final String[] endpoints;
    private final boolean acquireHostList;
    private final ContentType contentType;
    private final int timeout;
    private final com.arangodb.Protocol arangoProtocol;
    private final boolean sslEnabled;
    private final Option<String> sslCertValue;
    private final String sslCertType;
    private final String sslCertAlias;
    private final String sslAlgorithm;
    private final String sslKeystoreType;
    private final String sslProtocol;

    public String user() {
        return this.user;
    }

    public Option<String> password() {
        return this.password;
    }

    public String[] endpoints() {
        return this.endpoints;
    }

    public boolean acquireHostList() {
        return this.acquireHostList;
    }

    public ContentType contentType() {
        return this.contentType;
    }

    public int timeout() {
        return this.timeout;
    }

    private com.arangodb.Protocol arangoProtocol() {
        return this.arangoProtocol;
    }

    public boolean sslEnabled() {
        return this.sslEnabled;
    }

    public Option<String> sslCertValue() {
        return this.sslCertValue;
    }

    public String sslCertType() {
        return this.sslCertType;
    }

    public String sslCertAlias() {
        return this.sslCertAlias;
    }

    public String sslAlgorithm() {
        return this.sslAlgorithm;
    }

    public String sslKeystoreType() {
        return this.sslKeystoreType;
    }

    public String sslProtocol() {
        return this.sslProtocol;
    }

    /*
     * WARNING - void declaration
     */
    public ArangoDB.Builder builder() {
        void var1_1;
        ArangoDB.Builder builder = (ArangoDB.Builder)new ArangoDB.Builder().protocol(this.arangoProtocol()).timeout(Predef$.MODULE$.int2Integer(this.timeout())).user(this.user()).maxConnections(Predef$.MODULE$.int2Integer(1));
        this.password().foreach((Function1 & Serializable & scala.Serializable)x$1 -> (ArangoDB.Builder)builder.password(x$1));
        Object object = this.sslEnabled() ? builder.useSsl(Predef$.MODULE$.boolean2Boolean(true)).sslContext(this.getSslContext()) : BoxedUnit.UNIT;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.endpoints())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(":"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).foreach((Function1 & Serializable & scala.Serializable)host -> (ArangoDB.Builder)builder.host(host[0], new StringOps(Predef$.MODULE$.augmentString(host[1])).toInt()));
        return var1_1;
    }

    public SSLContext getSslContext() {
        SSLContext sSLContext;
        Option<String> option = this.sslCertValue();
        if (option instanceof Some) {
            Some some = (Some)option;
            String b64cert = (String)some.value();
            ByteArrayInputStream is = new ByteArrayInputStream(Base64.getDecoder().decode(b64cert));
            Certificate cert = CertificateFactory.getInstance(this.sslCertType()).generateCertificate(is);
            KeyStore ks = KeyStore.getInstance(this.sslKeystoreType());
            ks.load(null);
            ks.setCertificateEntry(this.sslCertAlias(), cert);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.sslAlgorithm());
            tmf.init(ks);
            SSLContext sc = SSLContext.getInstance(this.sslProtocol());
            sc.init(null, tmf.getTrustManagers(), null);
            sSLContext = sc;
        } else if (None$.MODULE$.equals(option)) {
            sSLContext = SSLContext.getDefault();
        } else {
            throw new MatchError(option);
        }
        return sSLContext;
    }

    /*
     * Unable to fully structure code
     */
    public ArangoDBDriverConf(Map<String, String> opts) {
        block5: {
            block6: {
                block4: {
                    super(opts);
                    this.user = this.getConf(ArangoDBConf$.MODULE$.userConf());
                    this.password = this.getConf(ArangoDBConf$.MODULE$.passwordConf());
                    this.endpoints = this.getRequiredConf(ArangoDBConf$.MODULE$.endpointsConf()).split(",");
                    this.acquireHostList = BoxesRunTime.unboxToBoolean((Object)this.getConf(ArangoDBConf$.MODULE$.acquireHostListConf()));
                    this.contentType = ContentType$.MODULE$.apply(this.getConf(ArangoDBConf$.MODULE$.contentTypeConf()));
                    this.timeout = BoxesRunTime.unboxToInt((Object)this.getConf(ArangoDBConf$.MODULE$.timeoutConf()));
                    var3_2 = new Tuple2((Object)Protocol$.MODULE$.apply(this.getConf(ArangoDBConf$.MODULE$.protocolConf())), (Object)this.contentType());
                    if (var3_2 == null) break block4;
                    var4_3 = (Protocol)var3_2._1();
                    var5_4 = (ContentType)var3_2._2();
                    if (!Protocol$VST$.MODULE$.equals(var4_3) || !ContentType$VPACK$.MODULE$.equals(var5_4)) break block4;
                    var2_5 = com.arangodb.Protocol.VST;
                    break block5;
                }
                if (var3_2 != null) {
                    var6_6 = (Protocol)var3_2._1();
                    var7_7 = (ContentType)var3_2._2();
                    if (Protocol$VST$.MODULE$.equals(var6_6) && ContentType$JSON$.MODULE$.equals(var7_7)) {
                        throw new IllegalArgumentException("Json over VST is not supported");
                    }
                }
                if (var3_2 == null) break block6;
                var8_8 = (Protocol)var3_2._1();
                var9_9 = (ContentType)var3_2._2();
                if (!Protocol$HTTP$.MODULE$.equals(var8_8) || !ContentType$VPACK$.MODULE$.equals(var9_9)) break block6;
                var2_5 = com.arangodb.Protocol.HTTP_VPACK;
                break block5;
            }
            if (var3_2 == null) ** GOTO lbl-1000
            var10_10 = (Protocol)var3_2._1();
            var11_11 = (ContentType)var3_2._2();
            if (Protocol$HTTP$.MODULE$.equals(var10_10) && ContentType$JSON$.MODULE$.equals(var11_11)) {
                var2_5 = com.arangodb.Protocol.HTTP_JSON;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var3_2);
            }
        }
        this.arangoProtocol = var2_5;
        this.sslEnabled = BoxesRunTime.unboxToBoolean((Object)this.getConf(ArangoDBConf$.MODULE$.sslEnabledConf()));
        this.sslCertValue = this.getConf(ArangoDBConf$.MODULE$.sslCertValueConf());
        this.sslCertType = this.getConf(ArangoDBConf$.MODULE$.sslCertTypeConf());
        this.sslCertAlias = this.getConf(ArangoDBConf$.MODULE$.sslCertAliasConf());
        this.sslAlgorithm = this.getConf(ArangoDBConf$.MODULE$.sslAlgorithmConf());
        this.sslKeystoreType = this.getConf(ArangoDBConf$.MODULE$.sslKeystoreTypeConf());
        this.sslProtocol = this.getConf(ArangoDBConf$.MODULE$.sslProtocolConf());
    }
}

