/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.arangodb.commons.filter;

import org.apache.spark.sql.arangodb.commons.filter.AndFilter;
import org.apache.spark.sql.arangodb.commons.filter.EqualToFilter;
import org.apache.spark.sql.arangodb.commons.filter.FilterSupport;
import org.apache.spark.sql.arangodb.commons.filter.FilterSupport$NONE$;
import org.apache.spark.sql.arangodb.commons.filter.GreaterThanFilter;
import org.apache.spark.sql.arangodb.commons.filter.GreaterThanOrEqualFilter;
import org.apache.spark.sql.arangodb.commons.filter.InFilter;
import org.apache.spark.sql.arangodb.commons.filter.IsNotNullFilter;
import org.apache.spark.sql.arangodb.commons.filter.IsNullFilter;
import org.apache.spark.sql.arangodb.commons.filter.LessThanFilter;
import org.apache.spark.sql.arangodb.commons.filter.LessThanOrEqualFilter;
import org.apache.spark.sql.arangodb.commons.filter.NotFilter;
import org.apache.spark.sql.arangodb.commons.filter.OrFilter;
import org.apache.spark.sql.arangodb.commons.filter.PushableFilter;
import org.apache.spark.sql.arangodb.commons.filter.StringContainsFilter;
import org.apache.spark.sql.arangodb.commons.filter.StringEndsWithFilter;
import org.apache.spark.sql.arangodb.commons.filter.StringStartsWithFilter;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.StructType;
import scala.NotImplementedError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;

public final class PushableFilter$
implements Serializable {
    public static PushableFilter$ MODULE$;

    static {
        new PushableFilter$();
    }

    public PushableFilter apply(Filter filter, StructType schema) {
        PushableFilter pushableFilter;
        Filter filter2 = filter;
        if (filter2 instanceof And) {
            And and = (And)filter2;
            pushableFilter = new AndFilter((Seq<PushableFilter>)Predef$.MODULE$.wrapRefArray((Object[])new PushableFilter[]{this.apply(and.left(), schema), this.apply(and.right(), schema)}));
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            pushableFilter = new OrFilter((Seq<PushableFilter>)Predef$.MODULE$.wrapRefArray((Object[])new PushableFilter[]{this.apply(or.left(), schema), this.apply(or.right(), schema)}));
        } else if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            pushableFilter = new NotFilter(this.apply(not.child(), schema));
        } else if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            pushableFilter = new EqualToFilter(equalTo.attribute(), equalTo.value(), schema);
        } else if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            pushableFilter = new EqualToFilter(equalNullSafe.attribute(), equalNullSafe.value(), schema);
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            pushableFilter = new IsNullFilter(isNull.attribute());
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            pushableFilter = new IsNotNullFilter(isNotNull.attribute());
        } else if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            pushableFilter = new GreaterThanFilter(greaterThan.attribute(), greaterThan.value(), schema);
        } else if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            pushableFilter = new GreaterThanOrEqualFilter(greaterThanOrEqual.attribute(), greaterThanOrEqual.value(), schema);
        } else if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            pushableFilter = new LessThanFilter(lessThan.attribute(), lessThan.value(), schema);
        } else if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            pushableFilter = new LessThanOrEqualFilter(lessThanOrEqual.attribute(), lessThanOrEqual.value(), schema);
        } else if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            pushableFilter = new StringStartsWithFilter(stringStartsWith.attribute(), stringStartsWith.value(), schema);
        } else if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            pushableFilter = new StringEndsWithFilter(stringEndsWith.attribute(), stringEndsWith.value(), schema);
        } else if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            pushableFilter = new StringContainsFilter(stringContains.attribute(), stringContains.value(), schema);
        } else if (filter2 instanceof In) {
            In in = (In)filter2;
            pushableFilter = new InFilter(in.attribute(), in.values(), schema);
        } else {
            pushableFilter = new PushableFilter(){

                public FilterSupport support() {
                    return FilterSupport$NONE$.MODULE$;
                }

                public String aql(String documentVariable) {
                    throw new NotImplementedError();
                }
            };
        }
        return pushableFilter;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PushableFilter$() {
        MODULE$ = this;
    }
}

