/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.arangodb.datasource.mapping.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.arangodb.datasource.mapping.json.JSONOptions;
import org.apache.spark.sql.arangodb.datasource.mapping.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf!B\u000b\u0017\u0001y1\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u000bY\u0002A\u0011A\u001c\t\u000fi\u0002!\u0019!C\u0005w!1!\u000b\u0001Q\u0001\nqBqa\u0015\u0001C\u0002\u0013%A\u000b\u0003\u0004^\u0001\u0001\u0006I!\u0016\u0005\u0006=\u0002!\ta\u0018\u0005\b\u00037\u0001A\u0011AA\u000f\u0011!\tI\u0003\u0001C\u0001-\u0005-raBA\u001d-!\u0005\u00111\b\u0004\u0007+YA\t!!\u0010\t\rYZA\u0011AA \u0011%\t\te\u0003b\u0001\n\u0003\t\u0019\u0005\u0003\u0005\u0002L-\u0001\u000b\u0011BA#\u0011\u001d\tIg\u0003C\u0001\u0003WBq!! \f\t\u0003\ty\bC\u0004\u0002\u0018.!\t!!'\t\u0011\u0005\u00056\u0002)A\u0005\u0003oBq!a)\f\t\u0003\t)\u000bC\u0005\u00020.\t\t\u0011\"\u0003\u00022\ny!j]8o\u0013:4WM]*dQ\u0016l\u0017M\u0003\u0002\u00181\u0005!!n]8o\u0015\tI\"$A\u0004nCB\u0004\u0018N\\4\u000b\u0005ma\u0012A\u00033bi\u0006\u001cx.\u001e:dK*\u0011QDH\u0001\tCJ\fgnZ8eE*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003Q9J!aL\u0015\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000f=\u0004H/[8og\u000e\u0001\u0001CA\u001a5\u001b\u00051\u0012BA\u001b\u0017\u0005-Q5k\u0014(PaRLwN\\:\u0002\rqJg.\u001b;?)\tA\u0014\b\u0005\u00024\u0001!)\u0001G\u0001a\u0001e\u0005iA-Z2j[\u0006d\u0007+\u0019:tKJ,\u0012\u0001\u0010\t\u0005Quz$*\u0003\u0002?S\tIa)\u001e8di&|g.\r\t\u0003\u0001\u001es!!Q#\u0011\u0005\tKS\"A\"\u000b\u0005\u0011\u000b\u0014A\u0002\u001fs_>$h(\u0003\u0002GS\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1\u0015\u0006\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006!Q.\u0019;i\u0015\u0005y\u0015\u0001\u00026bm\u0006L!!\u0015'\u0003\u0015\tKw\rR3dS6\fG.\u0001\beK\u000eLW.\u00197QCJ\u001cXM\u001d\u0011\u0002%QLW.Z:uC6\u0004hi\u001c:nCR$XM]\u000b\u0002+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0005kRLGN\u0003\u0002[=\u0005A1-\u0019;bYf\u001cH/\u0003\u0002]/\n\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0003M!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:!\u0003\u0015IgNZ3s+\t\u0001\u0007\u000fF\u0002bOf\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0010\u0002\u000bQL\b/Z:\n\u0005\u0019\u001c'AC*ueV\u001cG\u000fV=qK\")qc\u0002a\u0001QB\u0019\u0011\u000e\u001c8\u000e\u0003)T!a\u001b\u0011\u0002\u0007I$G-\u0003\u0002nU\n\u0019!\u000b\u0012#\u0011\u0005=\u0004H\u0002\u0001\u0003\u0006c\u001e\u0011\rA\u001d\u0002\u0002)F\u00111O\u001e\t\u0003QQL!!^\u0015\u0003\u000f9{G\u000f[5oOB\u0011\u0001f^\u0005\u0003q&\u00121!\u00118z\u0011\u0015Qx\u00011\u0001|\u00031\u0019'/Z1uKB\u000b'o]3s!\u0019ACP 8\u0002\u0016%\u0011Q0\u000b\u0002\n\rVt7\r^5p]J\u00022a`A\t\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001B2pe\u0016TA!a\u0002\u0002\n\u00059!.Y2lg>t'\u0002BA\u0006\u0003\u001b\t\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0005\u0005=\u0011aA2p[&!\u00111CA\u0001\u0005-Q5o\u001c8GC\u000e$xN]=\u0011\u0007}\f9\"\u0003\u0003\u0002\u001a\u0005\u0005!A\u0003&t_:\u0004\u0016M]:fe\u0006Q\u0011N\u001c4fe\u001aKW\r\u001c3\u0015\t\u0005}\u0011Q\u0005\t\u0004E\u0006\u0005\u0012bAA\u0012G\nAA)\u0019;b)f\u0004X\rC\u0004\u0002(!\u0001\r!!\u0006\u0002\rA\f'o]3s\u0003A\u0019\u0017M\\8oS\u000e\fG.\u001b>f)f\u0004X\r\u0006\u0004\u0002.\u0005M\u0012q\u0007\t\u0006Q\u0005=\u0012qD\u0005\u0004\u0003cI#AB(qi&|g\u000eC\u0004\u00026%\u0001\r!a\b\u0002\u0007Q\u0004X\rC\u00031\u0013\u0001\u0007!'A\bKg>t\u0017J\u001c4feN\u001b\u0007.Z7b!\t\u00194bE\u0002\fO5\"\"!a\u000f\u0002+M$(/^2u\r&,G\u000eZ\"p[B\f'/\u0019;peV\u0011\u0011Q\t\n\u0007\u0003\u000f\ni%!\u0017\u0007\r\u0005%c\u0002AA#\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003Y\u0019HO];di\u001aKW\r\u001c3D_6\u0004\u0018M]1u_J\u0004\u0003\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005Mc*\u0001\u0003mC:<\u0017\u0002BA,\u0003#\u0012aa\u00142kK\u000e$\bCBA.\u0003?\n\u0019'\u0004\u0002\u0002^)\u0011\u0001LT\u0005\u0005\u0003C\niF\u0001\u0006D_6\u0004\u0018M]1u_J\u00042AYA3\u0013\r\t9g\u0019\u0002\f'R\u0014Xo\u0019;GS\u0016dG-\u0001\u0005jgN{'\u000f^3e)\u0011\ti'a\u001d\u0011\u0007!\ny'C\u0002\u0002r%\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002v=\u0001\r!a\u001e\u0002\u0007\u0005\u0014(\u000fE\u0003)\u0003s\n\u0019'C\u0002\u0002|%\u0012Q!\u0011:sCf\f\u0001c^5uQ\u000e{'O];qi\u001aKW\r\u001c3\u0015\u0013\u0005\f\t)!\"\u0002\n\u00065\u0005BBAB!\u0001\u0007\u0011-\u0001\u0004tiJ,8\r\u001e\u0005\b\u0003\u000f\u0003\u0002\u0019AA\u0010\u0003\u0015yG\u000f[3s\u0011\u0019\tY\t\u0005a\u0001\u007f\u0005Q2m\u001c7v[:t\u0015-\\3PM\u000e{'O];qiJ+7m\u001c:eg\"9\u0011q\u0012\tA\u0002\u0005E\u0015!\u00039beN,Wj\u001c3f!\r1\u00161S\u0005\u0004\u0003+;&!\u0003)beN,Wj\u001c3f\u0003I\u0019w.\u001c9bi&\u0014G.\u001a*p_R$\u0016\u0010]3\u0015\r\u0005m\u0015QTAP!!AC0a\b\u0002 \u0005}\u0001BBAF#\u0001\u0007q\bC\u0004\u0002\u0010F\u0001\r!!%\u0002+\u0015l\u0007\u000f^=TiJ,8\r\u001e$jK2$\u0017I\u001d:bs\u0006q1m\\7qCRL'\r\\3UsB,GCBA\u0010\u0003O\u000bY\u000bC\u0004\u0002*N\u0001\r!a\b\u0002\u0005Q\f\u0004bBAW'\u0001\u0007\u0011qD\u0001\u0003iJ\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\n")
public class JsonInferSchema
implements scala.Serializable {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;

    public static DataType compatibleType(DataType dataType, DataType dataType2) {
        return JsonInferSchema$.MODULE$.compatibleType(dataType, dataType2);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(string, parseMode);
    }

    public static StructType withCorruptField(StructType structType, DataType dataType, String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(structType, dataType, string, parseMode);
    }

    public static boolean isSorted(StructField[] structFieldArray) {
        return JsonInferSchema$.MODULE$.isSorted(structFieldArray);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser) {
        ParseMode parseMode = this.options.parseMode();
        String columnNameOfCorruptRecord = this.options.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JsonFactory factory = $this.options.buildJsonFactory();
            return Option$.MODULE$.option2Iterable(iter.flatMap((Function1 & Serializable & scala.Serializable)row -> {
                Iterable iterable;
                try {
                    iterable = Option$.MODULE$.option2Iterable((Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable & scala.Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    }));
                    return iterable;
                }
                catch (Throwable throwable) {
                    Iterable iterable2;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof RuntimeException ? true : throwable2 instanceof JsonProcessingException;
                    if (!bl) throw throwable;
                    ParseMode parseMode = parseMode;
                    if (PermissiveMode$.MODULE$.equals(parseMode)) {
                        iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField(columnNameOfCorruptRecord, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                    } else if (DropMalformedMode$.MODULE$.equals(parseMode)) {
                        iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    } else {
                        if (!FailFastMode$.MODULE$.equals(parseMode)) throw new MatchError((Object)parseMode);
                        throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(throwable2);
                    }
                    Iterable iterable3 = iterable2;
                    iterable = iterable3;
                }
                return iterable;
            }).reduceOption(typeMerger)).toIterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        Function1 & Serializable & scala.Serializable foldPartition = (Function1 & Serializable & scala.Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$), typeMerger);
        Function2 & Serializable & scala.Serializable mergeResult = (Function2 & Serializable & scala.Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable & scala.Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$8(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType inferField(JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        boolean bl2 = jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2);
        if (bl2) {
            return NullType$.MODULE$;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            return this.inferField(parser);
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                return NullType$.MODULE$;
            }
        }
        if (bl) {
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            return this.options.prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined() ? (DataType)this.decimalTry$1(decimalTry$lzy, field).get() : (this.options.inferTimestamp() && Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.timestampFormatter().parse(field)).isDefined() ? TimestampType$.MODULE$ : StringType$.MODULE$);
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
            StructField[] fields = (StructField[])builder.result();
            Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
            return new StructType(fields);
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            NullType$ elementType = NullType$.MODULE$;
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                elementType = JsonInferSchema$.MODULE$.compatibleType((DataType)elementType, this.inferField(parser));
            }
            return ArrayType$.MODULE$.apply((DataType)elementType);
        }
        boolean bl3 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl3 && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        boolean bl4 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (bl4 && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        boolean bl5 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl5) {
            LongType$ longType$;
            JsonParser.NumberType numberType = parser.getNumberType();
            boolean bl6 = JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType);
            if (bl6) {
                longType$ = LongType$.MODULE$;
                return longType$;
            } else {
                boolean bl7 = JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType);
                if (bl7) {
                    BigDecimal v = parser.getDecimalValue();
                    longType$ = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                    return longType$;
                } else {
                    boolean bl8 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                    if (bl8 && this.options.prefersDecimal()) {
                        BigDecimal v = parser.getDecimalValue();
                        longType$ = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                        return longType$;
                    } else {
                        boolean bl9 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                        if (!bl9) throw new MatchError((Object)numberType);
                        longType$ = DoubleType$.MODULE$;
                    }
                }
            }
            return longType$;
        }
        boolean bl10 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (!bl10) throw QueryExecutionErrors$.MODULE$.malformedJSONError();
        return BooleanType$.MODULE$;
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        Object object;
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            object = this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable & scala.Serializable)t -> arrayType.copy(t, arrayType.copy$default$2()));
        } else {
            StructType structType;
            StructField[] fields;
            StructField[] canonicalFields;
            object = dataType instanceof StructType ? (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(canonicalFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields()))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$canonicalizeType$2(x$2))))).flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable & scala.Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))))).isEmpty() ? None$.MODULE$ : new Some((Object)new StructType(canonicalFields))) : (NullType$.MODULE$.equals(dataType) ? (options.dropFieldIfAllNull() ? None$.MODULE$ : new Some((Object)StringType$.MODULE$)) : new Some((Object)dataType));
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$infer$8(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        return decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public static final /* synthetic */ boolean $anonfun$canonicalizeType$2(StructField x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.name())).nonEmpty();
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormat(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
    }
}

