/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.arangodb.datasource.writer;

import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.arangodb.commons.ArangoClient;
import org.apache.spark.sql.arangodb.commons.ArangoClient$;
import org.apache.spark.sql.arangodb.commons.ArangoDBConf;
import org.apache.spark.sql.arangodb.commons.exceptions.DataWriteAbortException;
import org.apache.spark.sql.arangodb.datasource.writer.ArangoDataWriterFactory;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00014A\u0001C\u0005\u00011!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!9\u0004A!A!\u0002\u0013A\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"B\"\u0001\t\u0003\"\u0005\"B'\u0001\t\u0003r\u0005\"B/\u0001\t\u0003r&!E!sC:<wNQ1uG\"<&/\u001b;fe*\u0011!bC\u0001\u0007oJLG/\u001a:\u000b\u00051i\u0011A\u00033bi\u0006\u001cx.\u001e:dK*\u0011abD\u0001\tCJ\fgnZ8eE*\u0011\u0001#E\u0001\u0004gFd'B\u0001\n\u0014\u0003\u0015\u0019\b/\u0019:l\u0015\t!R#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!G\u0011\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012\u0001\u00027b]\u001eT\u0011AH\u0001\u0005U\u00064\u0018-\u0003\u0002!7\t1qJ\u00196fGR\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\u000b]\u0014\u0018\u000e^3\u000b\u0005\u0019z\u0011!C2p]:,7\r^8s\u0013\tA3E\u0001\u0006CCR\u001c\u0007n\u0016:ji\u0016\faa]2iK6\f\u0007CA\u0016/\u001b\u0005a#BA\u0017\u0010\u0003\u0015!\u0018\u0010]3t\u0013\tyCF\u0001\u0006TiJ,8\r\u001e+za\u0016\fqa\u001c9uS>t7\u000f\u0005\u00023k5\t1G\u0003\u00025\u001b\u000591m\\7n_:\u001c\u0018B\u0001\u001c4\u00051\t%/\u00198h_\u0012\u00135i\u001c8g\u0003\u0011iw\u000eZ3\u0011\u0005eRT\"A\b\n\u0005mz!\u0001C*bm\u0016lu\u000eZ3\u0002\rqJg.\u001b;?)\u0011q\u0004)\u0011\"\u0011\u0005}\u0002Q\"A\u0005\t\u000b%\"\u0001\u0019\u0001\u0016\t\u000bA\"\u0001\u0019A\u0019\t\u000b]\"\u0001\u0019\u0001\u001d\u00021\r\u0014X-\u0019;f\u0005\u0006$8\r[,sSR,'OR1di>\u0014\u0018\u0010\u0006\u0002F\u0011B\u0011!ER\u0005\u0003\u000f\u000e\u0012\u0011\u0003R1uC^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015IU\u00011\u0001K\u0003\u0011IgNZ8\u0011\u0005\tZ\u0015B\u0001'$\u0005E\u0001\u0006._:jG\u0006dwK]5uK&sgm\\\u0001\u0007G>lW.\u001b;\u0015\u0005=+\u0006C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&\u0001B+oSRDQA\u0016\u0004A\u0002]\u000b\u0001\"\\3tg\u0006<Wm\u001d\t\u0004!bS\u0016BA-R\u0005\u0015\t%O]1z!\t\u00113,\u0003\u0002]G\t\u0019rK]5uKJ\u001cu.\\7ji6+7o]1hK\u0006)\u0011MY8siR\u0011qj\u0018\u0005\u0006-\u001e\u0001\ra\u0016")
public class ArangoBatchWriter
implements BatchWrite {
    private final StructType schema;
    private final ArangoDBConf options;
    private final SaveMode mode;

    public boolean useCommitCoordinator() {
        return super.useCommitCoordinator();
    }

    public void onDataWriterCommit(WriterCommitMessage x$1) {
        super.onDataWriterCommit(x$1);
    }

    public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
        return new ArangoDataWriterFactory(this.schema, this.options);
    }

    public void commit(WriterCommitMessage[] messages) {
    }

    public void abort(WriterCommitMessage[] messages) {
        ArangoClient client = ArangoClient$.MODULE$.apply(this.options);
        SaveMode saveMode = this.mode;
        if (SaveMode.Append.equals(saveMode)) {
            throw new DataWriteAbortException("Cannot abort with SaveMode.Append: the underlying data source may require manual cleanup.");
        }
        if (!SaveMode.Overwrite.equals(saveMode)) {
            if (SaveMode.ErrorIfExists.equals(saveMode)) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
            if (SaveMode.Ignore.equals(saveMode)) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
            throw new MatchError((Object)saveMode);
        }
        client.truncate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        client.shutdown();
    }

    public ArangoBatchWriter(StructType schema, ArangoDBConf options, SaveMode mode) {
        this.schema = schema;
        this.options = options;
        this.mode = mode;
    }
}

