/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.arangodb.datasource.writer;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDBMultipleException;
import com.arangodb.util.RawBytes;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.arangodb.commons.ArangoClient;
import org.apache.spark.sql.arangodb.commons.ArangoClient$;
import org.apache.spark.sql.arangodb.commons.ArangoDBConf;
import org.apache.spark.sql.arangodb.commons.ArangoDBConf$;
import org.apache.spark.sql.arangodb.commons.exceptions.ArangoDBDataWriterException;
import org.apache.spark.sql.arangodb.commons.exceptions.DataWriteAbortException;
import org.apache.spark.sql.arangodb.commons.mapping.ArangoGenerator;
import org.apache.spark.sql.arangodb.commons.mapping.ArangoGeneratorProvider$;
import org.apache.spark.sql.arangodb.datasource.writer.ArangoDataWriter$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001\u0002\u00192\u0001\u0001C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A1\u000e\u0001B\u0001B\u0003%A\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0002>\t\u000fm\u0004\u0001\u0019!C\u0005y\"9\u0011Q\u0001\u0001!B\u0013a\u0007\"CA\u0004\u0001\u0001\u0007I\u0011BA\u0005\u0011%\tI\u0003\u0001a\u0001\n\u0013\tY\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0015BA\u0006\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019\u0004C\u0005\u0002<\u0001\u0001\r\u0011\"\u0003\u0002>!A\u0011\u0011\t\u0001!B\u0013\t)\u0004\u0003\u0005\u0002D\u0001\u0001\r\u0011\"\u0003{\u0011%\t)\u0005\u0001a\u0001\n\u0013\t9\u0005C\u0004\u0002L\u0001\u0001\u000b\u0015\u00027\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0003\u0002CA9\u0001\u0001\u0006I!!\u0015\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0004\u0002CAB\u0001\u0001\u0006I!a\u001e\t\u0013\u0005\u0015\u0005\u00011A\u0005\n\u0005\u001d\u0005\"CAH\u0001\u0001\u0007I\u0011BAI\u0011!\t)\n\u0001Q!\n\u0005%\u0005BCAL\u0001\u0001\u0007\t\u0019!C\u0005u\"Y\u0011\u0011\u0014\u0001A\u0002\u0003\u0007I\u0011BAN\u0011)\ty\n\u0001a\u0001\u0002\u0003\u0006K\u0001\u001c\u0005\f\u0003C\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019\u000bC\u0006\u00022\u0002\u0001\r\u00111A\u0005\n\u0005M\u0006bCA\\\u0001\u0001\u0007\t\u0011)Q\u0005\u0003KC1\"!/\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<\"Y\u0011\u0011\u001a\u0001A\u0002\u0003\u0007I\u0011BAf\u0011-\ty\r\u0001a\u0001\u0002\u0003\u0006K!!0\t\r1\u0003A\u0011IAi\u0011\u001d\t9\u000e\u0001C!\u00033Dq!!9\u0001\t\u0003\n\u0019\u000fC\u0004\u0002f\u0002!\t%a9\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"9\u00111\u001e\u0001\u0005\n\u00055\bbBA{\u0001\u0011%\u00111\u001d\u0005\b\u0003o\u0004A\u0011BAr\u0011\u001d\tI\u0010\u0001C\u0005\u0003wDqAa\b\u0001\t\u0013\u0011\t\u0003C\u0004\u0003$\u0001!IA!\n\b\u000f\tE\u0012\u0007#\u0001\u00034\u00191\u0001'\rE\u0001\u0005kAaA]\u0017\u0005\u0002\tu\u0002bBAv[\u0011\u0005!q\b\u0002\u0011\u0003J\fgnZ8ECR\fwK]5uKJT!AM\u001a\u0002\r]\u0014\u0018\u000e^3s\u0015\t!T'\u0001\u0006eCR\f7o\\;sG\u0016T!AN\u001c\u0002\u0011\u0005\u0014\u0018M\\4pI\nT!\u0001O\u001d\u0002\u0007M\fHN\u0003\u0002;w\u0005)1\u000f]1sW*\u0011A(P\u0001\u0007CB\f7\r[3\u000b\u0003y\n1a\u001c:h\u0007\u0001\u0019B\u0001A!J/B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005Y\u0006twMC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%AB(cU\u0016\u001cG\u000fE\u0002K\u001fFk\u0011a\u0013\u0006\u0003\u00196\u000bQa\u001e:ji\u0016T!AT\u001c\u0002\u0013\r|gN\\3di>\u0014\u0018B\u0001)L\u0005)!\u0015\r^1Xe&$XM\u001d\t\u0003%Vk\u0011a\u0015\u0006\u0003)^\n\u0001bY1uC2L8\u000f^\u0005\u0003-N\u00131\"\u00138uKJt\u0017\r\u001c*poB\u0011\u0001lW\u0007\u00023*\u0011!,O\u0001\tS:$XM\u001d8bY&\u0011A,\u0017\u0002\b\u0019><w-\u001b8h\u0003\u0019\u00198\r[3nCB\u0011qLY\u0007\u0002A*\u0011\u0011mN\u0001\u0006if\u0004Xm]\u0005\u0003G\u0002\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003\u001dy\u0007\u000f^5p]N\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u001b\u0002\u000f\r|W.\\8og&\u0011!n\u001a\u0002\r\u0003J\fgnZ8E\u0005\u000e{gNZ\u0001\fa\u0006\u0014H/\u001b;j_:LE\r\u0005\u0002na6\taNC\u0001p\u0003\u0015\u00198-\u00197b\u0013\t\thNA\u0002J]R\fa\u0001P5oSRtD\u0003\u0002;wob\u0004\"!\u001e\u0001\u000e\u0003EBQ!\u0018\u0003A\u0002yCQ\u0001\u001a\u0003A\u0002\u0015DQa\u001b\u0003A\u00021\f\u0001BZ1jYV\u0014Xm]\u000b\u0002Y\u0006aa-Y5mkJ,7o\u0018\u0013fcR\u0019Q0!\u0001\u0011\u00055t\u0018BA@o\u0005\u0011)f.\u001b;\t\u0011\u0005\ra!!AA\u00021\f1\u0001\u001f\u00132\u0003%1\u0017-\u001b7ve\u0016\u001c\b%\u0001\u0006fq\u000e,\u0007\u000f^5p]N,\"!a\u0003\u0011\r\u00055\u0011QDA\u0012\u001d\u0011\ty!!\u0007\u000f\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006@\u0003\u0019a$o\\8u}%\tq.C\u0002\u0002\u001c9\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002 \u0005\u0005\"\u0001\u0002'jgRT1!a\u0007o!\u0011\ti!!\n\n\t\u0005\u001d\u0012\u0011\u0005\u0002\n\u000bb\u001cW\r\u001d;j_:\fa\"\u001a=dKB$\u0018n\u001c8t?\u0012*\u0017\u000fF\u0002~\u0003[A\u0011\"a\u0001\n\u0003\u0003\u0005\r!a\u0003\u0002\u0017\u0015D8-\u001a9uS>t7\u000fI\u0001\re\u0016\fX/Z:u\u0007>,h\u000e^\u000b\u0003\u0003k\u00012!\\A\u001c\u0013\r\tID\u001c\u0002\u0005\u0019>tw-\u0001\tsKF,Xm\u001d;D_VtGo\u0018\u0013fcR\u0019Q0a\u0010\t\u0013\u0005\rA\"!AA\u0002\u0005U\u0012!\u0004:fcV,7\u000f^\"pk:$\b%A\u0006f]\u0012\u0004x.\u001b8u\u0013\u0012D\u0018aD3oIB|\u0017N\u001c;JIb|F%Z9\u0015\u0007u\fI\u0005\u0003\u0005\u0002\u0004=\t\t\u00111\u0001m\u00031)g\u000e\u001a9pS:$\u0018\n\u001a=!\u0003%)g\u000e\u001a9pS:$8/\u0006\u0002\u0002RA1\u00111KA/\u0003Cj!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\nS6lW\u000f^1cY\u0016T1!a\u0017o\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\n)F\u0001\u0004TiJ,\u0017-\u001c\t\u0005\u0003G\nYG\u0004\u0003\u0002f\u0005\u001d\u0004cAA\t]&\u0019\u0011\u0011\u000e8\u0002\rA\u0013X\rZ3g\u0013\u0011\ti'a\u001c\u0003\rM#(/\u001b8h\u0015\r\tIG\\\u0001\u000bK:$\u0007o\\5oiN\u0004\u0013a\u0001:oIV\u0011\u0011q\u000f\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011Q\u00108\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0004SC:$w.\\\u0001\u0005e:$\u0007%\u0001\u0004dY&,g\u000e^\u000b\u0003\u0003\u0013\u00032AZAF\u0013\r\tii\u001a\u0002\r\u0003J\fgnZ8DY&,g\u000e^\u0001\u000bG2LWM\u001c;`I\u0015\fHcA?\u0002\u0014\"I\u00111\u0001\f\u0002\u0002\u0003\u0007\u0011\u0011R\u0001\bG2LWM\u001c;!\u0003)\u0011\u0017\r^2i\u0007>,h\u000e^\u0001\u000fE\u0006$8\r[\"pk:$x\fJ3r)\ri\u0018Q\u0014\u0005\t\u0003\u0007I\u0012\u0011!a\u0001Y\u0006Y!-\u0019;dQ\u000e{WO\u001c;!\u0003%yW\u000f^*ue\u0016\fW.\u0006\u0002\u0002&B!\u0011qUAW\u001b\t\tIKC\u0002\u0002,\u0016\u000b!![8\n\t\u0005=\u0016\u0011\u0016\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u00035yW\u000f^*ue\u0016\fWn\u0018\u0013fcR\u0019Q0!.\t\u0013\u0005\rA$!AA\u0002\u0005\u0015\u0016AC8viN#(/Z1nA\u0005qa\u000f]1dW\u001e+g.\u001a:bi>\u0014XCAA_!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAbO\u00069Q.\u00199qS:<\u0017\u0002BAd\u0003\u0003\u0014q\"\u0011:b]\u001e|w)\u001a8fe\u0006$xN]\u0001\u0013mB\f7m[$f]\u0016\u0014\u0018\r^8s?\u0012*\u0017\u000fF\u0002~\u0003\u001bD\u0011\"a\u0001 \u0003\u0003\u0005\r!!0\u0002\u001fY\u0004\u0018mY6HK:,'/\u0019;pe\u0002\"2!`Aj\u0011\u0019\t).\ta\u0001#\u00061!/Z2pe\u0012\faaY8n[&$HCAAn!\rQ\u0015Q\\\u0005\u0004\u0003?\\%aE,sSR,'oQ8n[&$X*Z:tC\u001e,\u0017!B1c_J$H#A?\u0002\u000b\rdwn]3\u0002\u0019\r\u0014X-\u0019;f\u00072LWM\u001c;\u0015\u0005\u0005%\u0015\u0001C2b]J+GO]=\u0016\u0005\u0005=\bcA7\u0002r&\u0019\u00111\u001f8\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011N\\5u\u0005\u0006$8\r[\u0001\u000bM2,8\u000f\u001b\"bi\u000eD\u0017!D:bm\u0016$unY;nK:$8\u000fF\u0002~\u0003{Dq!a@*\u0001\u0004\u0011\t!A\u0004qCfdw.\u00193\u0011\t\t\r!QB\u0007\u0003\u0005\u000bQA!! \u0003\b)\u0019aG!\u0003\u000b\u0005\t-\u0011aA2p[&!!q\u0002B\u0003\u0005!\u0011\u0016m\u001e\"zi\u0016\u001c\bfA\u0015\u0003\u0014A!!Q\u0003B\u000e\u001b\t\u00119BC\u0002\u0003\u001a9\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iBa\u0006\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006a1m\\7qkR,G)\u001a7bsR\tA.A\u000bjg\u000e{gN\\3di&|g.\u0012=dKB$\u0018n\u001c8\u0015\t\u0005=(q\u0005\u0005\b\u0005SY\u0003\u0019\u0001B\u0016\u0003\u0005)\u0007\u0003BA\u0007\u0005[IAAa\f\u0002\"\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0011\u0003J\fgnZ8ECR\fwK]5uKJ\u0004\"!^\u0017\u0014\u00075\u00129\u0004E\u0002n\u0005sI1Aa\u000fo\u0005\u0019\te.\u001f*fMR\u0011!1\u0007\u000b\u0007\u0003_\u0014\tEa\u0011\t\u000bu{\u0003\u0019\u00010\t\u000b\u0011|\u0003\u0019A3")
public class ArangoDataWriter
implements DataWriter<InternalRow>,
Logging {
    private final StructType schema;
    private final ArangoDBConf options;
    private final int partitionId;
    private int failures;
    private List<Exception> exceptions;
    private long requestCount;
    private int endpointIdx;
    private final Stream<String> endpoints;
    private final Random rnd;
    private ArangoClient client;
    private int batchCount;
    private ByteArrayOutputStream outStream;
    private ArangoGenerator vpackGenerator;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int failures() {
        return this.failures;
    }

    private void failures_$eq(int x$1) {
        this.failures = x$1;
    }

    private List<Exception> exceptions() {
        return this.exceptions;
    }

    private void exceptions_$eq(List<Exception> x$1) {
        this.exceptions = x$1;
    }

    private long requestCount() {
        return this.requestCount;
    }

    private void requestCount_$eq(long x$1) {
        this.requestCount = x$1;
    }

    private int endpointIdx() {
        return this.endpointIdx;
    }

    private void endpointIdx_$eq(int x$1) {
        this.endpointIdx = x$1;
    }

    private Stream<String> endpoints() {
        return this.endpoints;
    }

    private Random rnd() {
        return this.rnd;
    }

    private ArangoClient client() {
        return this.client;
    }

    private void client_$eq(ArangoClient x$1) {
        this.client = x$1;
    }

    private int batchCount() {
        return this.batchCount;
    }

    private void batchCount_$eq(int x$1) {
        this.batchCount = x$1;
    }

    private ByteArrayOutputStream outStream() {
        return this.outStream;
    }

    private void outStream_$eq(ByteArrayOutputStream x$1) {
        this.outStream = x$1;
    }

    private ArangoGenerator vpackGenerator() {
        return this.vpackGenerator;
    }

    private void vpackGenerator_$eq(ArangoGenerator x$1) {
        this.vpackGenerator = x$1;
    }

    public void write(InternalRow record) {
        block0: {
            this.vpackGenerator().write(record);
            this.vpackGenerator().flush();
            this.batchCount_$eq(this.batchCount() + 1);
            if (this.batchCount() != this.options.writeOptions().batchSize() && this.outStream().size() <= this.options.writeOptions().byteBatchSize()) break block0;
            this.flushBatch();
            this.initBatch();
        }
    }

    public WriterCommitMessage commit() {
        this.flushBatch();
        return null;
    }

    public void abort() {
        if (!this.canRetry()) {
            this.client().shutdown();
            throw new DataWriteAbortException("Task cannot be retried. To make batch writes idempotent, so that they can be retried, consider using 'keep.null=true' (default) and 'overwrite.mode=(ignore|replace|update)'.");
        }
    }

    public void close() {
        this.client().shutdown();
    }

    private ArangoClient createClient() {
        return ArangoClient$.MODULE$.apply(this.options.updated(new Tuple2((Object)ArangoDBConf$.MODULE$.ENDPOINTS(), this.endpoints().apply(this.endpointIdx()))));
    }

    private boolean canRetry() {
        return ArangoDataWriter$.MODULE$.canRetry(this.schema, this.options);
    }

    private void initBatch() {
        this.batchCount_$eq(0);
        this.outStream_$eq(new ByteArrayOutputStream());
        this.vpackGenerator_$eq(ArangoGeneratorProvider$.MODULE$.apply().of(this.options.driverOptions().contentType(), this.schema, (OutputStream)this.outStream(), this.options));
        this.vpackGenerator().writeStartArray();
    }

    private void flushBatch() {
        this.vpackGenerator().writeEndArray();
        this.vpackGenerator().close();
        this.vpackGenerator().flush();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("flushBatch(), bufferSize: ").append(this.outStream().size()).toString());
        this.saveDocuments(RawBytes.of((byte[])this.outStream().toByteArray()));
    }

    private void saveDocuments(RawBytes payload) {
        while (true) {
            try {
                this.requestCount_$eq(this.requestCount() + 1L);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Sending request #").append(this.requestCount()).append(" for partition ").append($this.partitionId).toString());
                this.client().saveDocuments(payload);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Received response #").append(this.requestCount()).append(" for partition ").append($this.partitionId).toString());
                this.failures_$eq(0);
                this.exceptions_$eq((List<Exception>)Nil$.MODULE$);
            }
            catch (Exception e) {
                this.client().shutdown();
                this.failures_$eq(this.failures() + 1);
                Exception exception = e;
                this.exceptions_$eq((List<Exception>)this.exceptions().$colon$colon((Object)exception));
                this.endpointIdx_$eq(this.endpointIdx() + 1);
                if ((this.canRetry() || this.isConnectionException(e)) && this.failures() < this.options.writeOptions().maxAttempts()) {
                    int delay = this.computeDelay();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Got exception while saving documents, retrying in ").append(delay).append(" ms:").toString(), e);
                    Thread.sleep(delay);
                    this.client_$eq(this.createClient());
                    continue;
                }
                throw new ArangoDBDataWriterException((Exception[])this.exceptions().reverse().toArray(ClassTag$.MODULE$.apply(Exception.class)));
            }
            break;
        }
    }

    private int computeDelay() {
        int min = this.options.writeOptions().minRetryDelay();
        int max = this.options.writeOptions().maxRetryDelay();
        int diff = max - min;
        int delta = diff <= 0 ? 0 : this.rnd().nextInt(diff);
        return min + delta;
    }

    private boolean isConnectionException(Throwable e2) {
        boolean bl;
        Throwable throwable;
        while ((throwable = e2) instanceof ArangoDBException) {
            ArangoDBException arangoDBException = (ArangoDBException)throwable;
            e2 = arangoDBException.getCause();
        }
        if (throwable instanceof ArangoDBMultipleException) {
            ArangoDBMultipleException arangoDBMultipleException = (ArangoDBMultipleException)throwable;
            bl = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)arangoDBMultipleException.getExceptions()).asScala()).forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)this.isConnectionException(e)));
        } else {
            bl = throwable instanceof ConnectException ? true : throwable instanceof UnknownHostException;
        }
        return bl;
    }

    public ArangoDataWriter(StructType schema, ArangoDBConf options, int partitionId) {
        this.schema = schema;
        this.options = options;
        this.partitionId = partitionId;
        Logging.$init$((Logging)this);
        this.failures = 0;
        this.exceptions = Nil$.MODULE$;
        this.requestCount = 0L;
        this.endpointIdx = partitionId;
        this.endpoints = package$.MODULE$.Stream().continually((Function0 & Serializable & scala.Serializable)() -> $this.options.driverOptions().endpoints()).flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)));
        this.rnd = new Random();
        this.client = this.createClient();
        this.initBatch();
    }
}

