/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.arangodb.datasource.writer;

import com.arangodb.entity.CollectionType;
import com.arangodb.model.OverwriteMode;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.arangodb.commons.ArangoClient;
import org.apache.spark.sql.arangodb.commons.ArangoClient$;
import org.apache.spark.sql.arangodb.commons.ArangoDBConf;
import org.apache.spark.sql.arangodb.commons.ArangoDBConf$;
import org.apache.spark.sql.arangodb.commons.ContentType;
import org.apache.spark.sql.arangodb.datasource.writer.ArangoBatchWriter;
import org.apache.spark.sql.arangodb.datasource.writer.ArangoDataWriter$;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.SupportsTruncate;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154A\u0001D\u0007\u00019!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dQ\u0005\u00011A\u0005\n-Cq\u0001\u0015\u0001A\u0002\u0013%\u0011\u000b\u0003\u0004[\u0001\u0001\u0006K\u0001\u0014\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006A\u0002!\t%\u0019\u0005\u0006E\u0002!Ia\u0019\u0005\u0006I\u0002!I!\u001a\u0005\u0006S\u0002!IA\u001b\u0002\u0014\u0003J\fgnZ8Xe&$XM\u001d\"vS2$WM\u001d\u0006\u0003\u001d=\taa\u001e:ji\u0016\u0014(B\u0001\t\u0012\u0003)!\u0017\r^1t_V\u00148-\u001a\u0006\u0003%M\t\u0001\"\u0019:b]\u001e|GM\u0019\u0006\u0003)U\t1a]9m\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0006\u0001u)S\u0006\r\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\nA\u0001\\1oO*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013 \u0005\u0019y%M[3diB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0006oJLG/\u001a\u0006\u0003UM\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u00051:#\u0001D,sSR,')^5mI\u0016\u0014\bC\u0001\u0014/\u0013\tysE\u0001\tTkB\u0004xN\u001d;t)J,hnY1uKB\u0011\u0011\u0007N\u0007\u0002e)\u00111'F\u0001\tS:$XM\u001d8bY&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u0003\u0019\u00198\r[3nCB\u0011\u0001hO\u0007\u0002s)\u0011!hE\u0001\u0006if\u0004Xm]\u0005\u0003ye\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003\u001dy\u0007\u000f^5p]N\u0004\"a\u0010\"\u000e\u0003\u0001S!!Q\t\u0002\u000f\r|W.\\8og&\u00111\t\u0011\u0002\r\u0003J\fgnZ8E\u0005\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019C\u0015\n\u0005\u0002H\u00015\tQ\u0002C\u00037\u0007\u0001\u0007q\u0007C\u0003>\u0007\u0001\u0007a(\u0001\u0003n_\u0012,W#\u0001'\u0011\u00055sU\"A\n\n\u0005=\u001b\"\u0001C*bm\u0016lu\u000eZ3\u0002\u00115|G-Z0%KF$\"A\u0015-\u0011\u0005M3V\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\tUs\u0017\u000e\u001e\u0005\b3\u0016\t\t\u00111\u0001M\u0003\rAH%M\u0001\u0006[>$W\rI\u0001\u000eEVLG\u000e\u001a$pe\n\u000bGo\u00195\u0015\u0003u\u0003\"A\n0\n\u0005};#A\u0003\"bi\u000eDwK]5uK\u0006AAO];oG\u0006$X\rF\u0001&\u000391\u0018\r\\5eCR,7i\u001c8gS\u001e$\u0012AU\u0001\u0015Q\u0006\u001cH)Z2j[\u0006dG+\u001f9f\r&,G\u000eZ:\u0016\u0003\u0019\u0004\"aU4\n\u0005!$&a\u0002\"p_2,\u0017M\\\u0001\u000bY><7+^7nCJLHC\u0001*l\u0011\u0015a7\u00021\u0001?\u00039)\b\u000fZ1uK\u0012|\u0005\u000f^5p]N\u0004")
public class ArangoWriterBuilder
implements WriteBuilder,
SupportsTruncate,
Logging {
    private final StructType schema;
    private final ArangoDBConf options;
    private SaveMode mode;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Write build() {
        return super.build();
    }

    @Deprecated
    public StreamingWrite buildForStreaming() {
        return super.buildForStreaming();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    public BatchWrite buildForBatch() {
        ArangoClient client = ArangoClient$.MODULE$.apply(this.options);
        if (!client.collectionExists()) {
            client.createCollection();
        }
        client.shutdown();
        SaveMode saveMode = this.mode();
        String string = SaveMode.Append.equals(saveMode) ? this.options.writeOptions().overwriteMode().getValue() : OverwriteMode.ignore.getValue();
        ArangoDBConf updatedOptions = this.options.updated(new Tuple2((Object)ArangoDBConf$.MODULE$.OVERWRITE_MODE(), (Object)string));
        this.logSummary(updatedOptions);
        return new ArangoBatchWriter(this.schema, updatedOptions, this.mode());
    }

    public WriteBuilder truncate() {
        ArangoClient client;
        this.mode_$eq(SaveMode.Overwrite);
        if (this.options.writeOptions().confirmTruncate()) {
            client = ArangoClient$.MODULE$.apply(this.options);
            if (client.collectionExists()) {
                client.truncate();
            } else {
                client.createCollection();
            }
        } else {
            throw new AnalysisException(new StringBuilder(255).append("You are attempting to use overwrite mode which will truncate this collection prior to inserting data. If you just want to change data already in the collection set save mode 'append' and ").append("'overwrite.mode=(replace|update)'. To actually truncate set '").append(ArangoDBConf$.MODULE$.CONFIRM_TRUNCATE()).append("=true'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        client.shutdown();
        return this;
    }

    private void validateConfig() {
        ContentType contentType = this.options.driverOptions().contentType();
        ContentType.JSON$ jSON$ = ContentType.JSON$.MODULE$;
        if (!(contentType != null ? !contentType.equals(jSON$) : jSON$ != null) && this.hasDecimalTypeFields()) {
            throw new UnsupportedOperationException("Cannot write DecimalType when using contentType=json");
        }
        CollectionType collectionType = this.options.writeOptions().collectionType();
        CollectionType collectionType2 = CollectionType.EDGES;
        if (!(collectionType != null ? !collectionType.equals(collectionType2) : collectionType2 != null) && !this.schema.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ArangoWriterBuilder.$anonfun$validateConfig$1(p)))) {
            throw new IllegalArgumentException("Writing edge collection requires non nullable string field named _from.");
        }
        CollectionType collectionType3 = this.options.writeOptions().collectionType();
        CollectionType collectionType4 = CollectionType.EDGES;
        if (!(collectionType3 != null ? !collectionType3.equals(collectionType4) : collectionType4 != null) && !this.schema.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ArangoWriterBuilder.$anonfun$validateConfig$2(p)))) {
            throw new IllegalArgumentException("Writing edge collection requires non nullable string field named _to.");
        }
    }

    private boolean hasDecimalTypeFields() {
        return this.schema.existsRecursively((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ArangoWriterBuilder.$anonfun$hasDecimalTypeFields$1(x0$1)));
    }

    private void logSummary(ArangoDBConf updatedOptions) {
        block0: {
            boolean canRetry = ArangoDataWriter$.MODULE$.canRetry(this.schema, updatedOptions);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Using save mode: ").append(this.mode()).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Using write configuration: ").append(updatedOptions.writeOptions()).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Using mapping configuration: ").append(updatedOptions.mappingOptions()).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Can retry: ").append(canRetry).toString());
            if (canRetry) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("The provided configuration does not allow idempotent requests: write failures will not be retried and lead\n          |to task failure. Speculative task executions could fail or write incorrect data.")).stripMargin().replaceAll("\n", ""));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateConfig$1(StructField p) {
        String string = p.name();
        String string2 = "_from";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        DataType dataType = p.dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType == null) {
            if (stringType$ != null) {
                return false;
            }
        } else if (!dataType.equals(stringType$)) return false;
        if (p.nullable()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateConfig$2(StructField p) {
        String string = p.name();
        String string2 = "_to";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        DataType dataType = p.dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType == null) {
            if (stringType$ != null) {
                return false;
            }
        } else if (!dataType.equals(stringType$)) return false;
        if (p.nullable()) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$hasDecimalTypeFields$1(DataType x0$1) {
        DataType dataType = x0$1;
        boolean bl = dataType instanceof DecimalType;
        return bl;
    }

    public ArangoWriterBuilder(StructType schema, ArangoDBConf options) {
        this.schema = schema;
        this.options = options;
        Logging.$init$((Logging)this);
        this.mode = SaveMode.Append;
        this.validateConfig();
    }
}

