/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.config;

import com.arangodb.springframework.annotation.EnableArangoAuditing;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import com.arangodb.springframework.core.mapping.event.AuditingEventListener;
import java.lang.annotation.Annotation;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public class ArangoAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    protected Class<? extends Annotation> getAnnotation() {
        return EnableArangoAuditing.class;
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, (String)"BeanDefinition must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        BeanDefinitionBuilder listenerBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(AuditingEventListener.class);
        listenerBeanDefinitionBuilder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), (Object)registry));
        this.registerInfrastructureBeanWithId(listenerBeanDefinitionBuilder.getBeanDefinition(), AuditingEventListener.class.getName(), registry);
    }

    protected String getAuditingHandlerBeanName() {
        return "arangoAuditingHandler";
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class);
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(ArangoMappingContextLookup.class);
        definition.setAutowireMode(3);
        builder.addConstructorArgValue((Object)definition.getBeanDefinition());
        return this.configureDefaultAuditHandlerAttributes(configuration, builder);
    }

    static class ArangoMappingContextLookup
    implements FactoryBean<MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty>> {
        private final MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> context;

        public ArangoMappingContextLookup(MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> context) {
            this.context = context;
        }

        public MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> getObject() throws Exception {
            return this.context;
        }

        public Class<?> getObjectType() {
            return MappingContext.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

