/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.springframework.annotation.Document;
import com.arangodb.springframework.annotation.Edge;
import com.arangodb.springframework.annotation.From;
import com.arangodb.springframework.annotation.Ref;
import com.arangodb.springframework.annotation.Relations;
import com.arangodb.springframework.annotation.To;
import com.arangodb.springframework.core.convert.ArangoConverter;
import com.arangodb.springframework.core.convert.ArangoTypeMapper;
import com.arangodb.springframework.core.convert.DBDocumentEntity;
import com.arangodb.springframework.core.convert.JavaTimeUtil;
import com.arangodb.springframework.core.convert.resolver.LazyLoadingProxy;
import com.arangodb.springframework.core.convert.resolver.ReferenceResolver;
import com.arangodb.springframework.core.convert.resolver.RelationResolver;
import com.arangodb.springframework.core.convert.resolver.ResolverFactory;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import com.arangodb.springframework.core.mapping.ArangoSimpleTypes;
import com.arangodb.springframework.core.util.MetadataUtils;
import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.internal.util.DateUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Base64Utils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class DefaultArangoConverter
implements ArangoConverter {
    private static final String _ID = "_id";
    private static final String _KEY = "_key";
    private static final String _REV = "_rev";
    private static final String _FROM = "_from";
    private static final String _TO = "_to";
    private final MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> context;
    private final CustomConversions conversions;
    private final GenericConversionService conversionService;
    private final EntityInstantiators instantiators;
    private final ResolverFactory resolverFactory;
    private final ArangoTypeMapper typeMapper;

    public DefaultArangoConverter(MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> context, CustomConversions conversions, ResolverFactory resolverFactory, ArangoTypeMapper typeMapper) {
        this.context = context;
        this.conversions = conversions;
        this.resolverFactory = resolverFactory;
        this.typeMapper = typeMapper;
        this.conversionService = new DefaultConversionService();
        conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
        this.instantiators = new EntityInstantiators();
    }

    @Override
    public MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> getMappingContext() {
        return this.context;
    }

    @Override
    public ArangoTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public <R> R read(Class<R> type, VPackSlice source) {
        return (R)this.readInternal((TypeInformation<?>)ClassTypeInformation.from(type), source);
    }

    private Object readInternal(TypeInformation<?> type, VPackSlice source) {
        if (source == null) {
            return null;
        }
        if (VPackSlice.class.isAssignableFrom(type.getType())) {
            return source;
        }
        TypeInformation<?> typeToUse = source.isArray() || source.isObject() ? this.typeMapper.readType(source, type) : type;
        Class rawTypeToUse = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(VPackSlice.class, typeToUse.getType())) {
            return this.conversionService.convert((Object)source, rawTypeToUse);
        }
        if (this.conversions.hasCustomReadTarget(DBDocumentEntity.class, typeToUse.getType())) {
            return this.conversionService.convert(this.readSimple(DBDocumentEntity.class, source), rawTypeToUse);
        }
        if (!source.isArray() && !source.isObject()) {
            return this.convertIfNecessary(this.readSimple(rawTypeToUse, source), rawTypeToUse);
        }
        if (DBDocumentEntity.class.isAssignableFrom(rawTypeToUse)) {
            return this.readSimple(rawTypeToUse, source);
        }
        if (BaseDocument.class.isAssignableFrom(rawTypeToUse)) {
            return this.readBaseDocument(rawTypeToUse, source);
        }
        if (typeToUse.isMap()) {
            return this.readMap(typeToUse, source);
        }
        if (!source.isArray() && ClassTypeInformation.OBJECT.equals(typeToUse)) {
            return this.readMap((TypeInformation<?>)ClassTypeInformation.MAP, source);
        }
        if (typeToUse.getType().isArray()) {
            return this.readArray(typeToUse, source);
        }
        if (typeToUse.isCollectionLike()) {
            return this.readCollection(typeToUse, source);
        }
        if (ClassTypeInformation.OBJECT.equals(typeToUse)) {
            return this.readCollection((TypeInformation<?>)ClassTypeInformation.COLLECTION, source);
        }
        ArangoPersistentEntity entity = (ArangoPersistentEntity)this.context.getRequiredPersistentEntity(rawTypeToUse);
        return this.readEntity(typeToUse, source, entity);
    }

    private Object readEntity(TypeInformation<?> type, VPackSlice source, ArangoPersistentEntity<?> entity) {
        if (!source.isObject()) {
            throw new MappingException(String.format("Can't read entity type %s from VPack type %s!", type, source.getType()));
        }
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        ParameterValueProvider<ArangoPersistentProperty> provider = this.getParameterProvider(entity, source);
        Object instance = instantiator.createInstance(entity, provider);
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
        String id = source.get(_ID).isString() ? source.get(_ID).getAsString() : null;
        entity.doWithProperties(property -> {
            if (!entity.isConstructorArgument(property)) {
                VPackSlice value = source.get(property.getFieldName());
                this.readProperty(entity, id, (PersistentPropertyAccessor<?>)accessor, value, (ArangoPersistentProperty)property);
            }
        });
        entity.doWithAssociations(association -> {
            ArangoPersistentProperty property = (ArangoPersistentProperty)association.getInverse();
            if (!entity.isConstructorArgument(property)) {
                VPackSlice value = source.get(property.getFieldName());
                this.readProperty(entity, id, accessor, value, property);
            }
        });
        return instance;
    }

    private void readProperty(ArangoPersistentEntity<?> entity, String parentId, PersistentPropertyAccessor<?> accessor, VPackSlice source, ArangoPersistentProperty property) {
        Object propertyValue = this.readPropertyValue(entity, parentId, source, property);
        if (propertyValue != null || !property.getType().isPrimitive()) {
            accessor.setProperty((PersistentProperty)property, propertyValue);
        }
    }

    private Object readPropertyValue(ArangoPersistentEntity<?> entity, String parentId, VPackSlice source, ArangoPersistentProperty property) {
        Optional<Ref> ref = property.getRef();
        if (ref.isPresent()) {
            return this.readReference(source, property, ref.get()).orElse(null);
        }
        Optional<Relations> relations = property.getRelations();
        if (relations.isPresent()) {
            return this.readRelation(entity, parentId, source, property, (Annotation)relations.get()).orElse(null);
        }
        Optional<From> from = property.getFrom();
        if (from.isPresent()) {
            return this.readRelation(entity, parentId, source, property, (Annotation)from.get()).orElse(null);
        }
        Optional<To> to = property.getTo();
        if (to.isPresent()) {
            return this.readRelation(entity, parentId, source, property, (Annotation)to.get()).orElse(null);
        }
        return this.readInternal(property.getTypeInformation(), source);
    }

    private Object readMap(TypeInformation<?> type, VPackSlice source) {
        if (!source.isObject()) {
            throw new MappingException(String.format("Can't read map type %s from VPack type %s!", type, source.getType()));
        }
        Class keyType = this.getNonNullComponentType(type).getType();
        TypeInformation<?> valueType = this.getNonNullMapValueType(type);
        Map map = CollectionFactory.createMap((Class)type.getType(), (Class)keyType, (int)source.size());
        Iterator iterator = source.objectIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (this.typeMapper.isTypeKey((String)entry.getKey())) continue;
            Object key = this.convertIfNecessary(entry.getKey(), keyType);
            VPackSlice value = (VPackSlice)entry.getValue();
            map.put(key, this.readInternal(valueType, value));
        }
        return map;
    }

    private Collection<?> readCollection(TypeInformation<?> type, VPackSlice source) {
        if (!source.isArray()) {
            throw new MappingException(String.format("Can't read collection type %s from VPack type %s!", type, source.getType()));
        }
        TypeInformation<?> componentType = this.getNonNullComponentType(type);
        Class collectionType = Iterable.class.equals((Object)type.getType()) ? Collection.class : type.getType();
        ArrayList<Object> collection = Collection.class == collectionType || List.class == collectionType ? new ArrayList<Object>(source.getLength()) : CollectionFactory.createCollection((Class)collectionType, (Class)componentType.getType(), (int)source.getLength());
        Iterator iterator = source.arrayIterator();
        while (iterator.hasNext()) {
            VPackSlice elem = (VPackSlice)iterator.next();
            collection.add(this.readInternal(componentType, elem));
        }
        return collection;
    }

    private Object readArray(TypeInformation<?> type, VPackSlice source) {
        if (!source.isArray()) {
            throw new MappingException(String.format("Can't read array type %s from VPack type %s!", type, source.getType()));
        }
        TypeInformation<?> componentType = this.getNonNullComponentType(type);
        int length = source.getLength();
        Object array = Array.newInstance(componentType.getType(), length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.readInternal(componentType, source.get(i)));
        }
        return array;
    }

    private Optional<Object> readReference(VPackSlice source, ArangoPersistentProperty property, Annotation annotation) {
        Optional<ReferenceResolver<Annotation>> resolver = this.resolverFactory.getReferenceResolver(annotation);
        if (!resolver.isPresent() || source.isNone()) {
            return Optional.empty();
        }
        if (property.isCollectionLike()) {
            Collection<?> ids;
            try {
                ids = this.readCollection((TypeInformation<?>)ClassTypeInformation.COLLECTION, source);
            }
            catch (ClassCastException e) {
                throw new MappingException("All references must be of type String!", (Throwable)e);
            }
            return resolver.map(res -> res.resolveMultiple(ids, property.getTypeInformation(), annotation));
        }
        if (!source.isString()) {
            throw new MappingException(String.format("A reference must be of type String, but got VPack type %s!", source.getType()));
        }
        return resolver.map(res -> res.resolveOne(source.getAsString(), property.getTypeInformation(), annotation));
    }

    private <A extends Annotation> Optional<Object> readRelation(ArangoPersistentEntity<?> entity, String parentId, VPackSlice source, ArangoPersistentProperty property, A annotation) {
        Class collectionType = entity.findAnnotation(Edge.class) != null ? Edge.class : Document.class;
        Optional<RelationResolver<A>> resolver = this.resolverFactory.getRelationResolver(annotation, collectionType);
        if (!resolver.isPresent()) {
            return Optional.empty();
        }
        if (property.isCollectionLike()) {
            if (parentId == null) {
                return Optional.empty();
            }
            return resolver.map(res -> res.resolveMultiple(parentId, property.getTypeInformation(), annotation));
        }
        if (source.isString()) {
            return resolver.map(res -> res.resolveOne(source.getAsString(), property.getTypeInformation(), annotation));
        }
        return resolver.map(res -> res.resolveOne(parentId, property.getTypeInformation(), annotation));
    }

    private Object readSimple(Class<?> type, VPackSlice source) {
        if (source.isNone() || source.isNull()) {
            return null;
        }
        if (source.isBoolean()) {
            return source.getAsBoolean();
        }
        if (source.isNumber()) {
            if (Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
                return source.getAsByte();
            }
            if (Short.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type)) {
                return source.getAsShort();
            }
            if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
                return source.getAsInt();
            }
            if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
                return source.getAsLong();
            }
            if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
                return Float.valueOf(source.getAsFloat());
            }
            if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
                return source.getAsDouble();
            }
            if (BigInteger.class.isAssignableFrom(type) && (source.isSmallInt() || source.isInt() || source.isUInt())) {
                return source.getAsBigInteger();
            }
            if (BigDecimal.class.isAssignableFrom(type) && source.isDouble()) {
                return source.getAsBigDecimal();
            }
            return source.getAsNumber();
        }
        if (source.isString()) {
            if (Class.class.isAssignableFrom(type)) {
                try {
                    return Class.forName(source.getAsString());
                }
                catch (ClassNotFoundException e) {
                    throw new MappingException(String.format("Could not load type %s!", source.getAsString()), (Throwable)e);
                }
            }
            if (Enum.class.isAssignableFrom(type)) {
                Object e = Enum.valueOf(type, source.getAsString());
                return e;
            }
            if (byte[].class.isAssignableFrom(type)) {
                return Base64Utils.decodeFromString((String)source.getAsString());
            }
            if (Date.class.isAssignableFrom(type)) {
                return new Date(this.parseDate(source.getAsString()).getTime());
            }
            if (Timestamp.class.isAssignableFrom(type)) {
                return new Timestamp(this.parseDate(source.getAsString()).getTime());
            }
            if (java.util.Date.class.isAssignableFrom(type)) {
                return this.parseDate(source.getAsString());
            }
            if (BigInteger.class.isAssignableFrom(type)) {
                return source.getAsBigInteger();
            }
            if (BigDecimal.class.isAssignableFrom(type)) {
                return source.getAsBigDecimal();
            }
            if (Instant.class.isAssignableFrom(type)) {
                return JavaTimeUtil.parseInstant(source.getAsString());
            }
            if (LocalDate.class.isAssignableFrom(type)) {
                return JavaTimeUtil.parseLocalDate(source.getAsString());
            }
            if (LocalDateTime.class.isAssignableFrom(type)) {
                return JavaTimeUtil.parseLocalDateTime(source.getAsString());
            }
            if (OffsetDateTime.class.isAssignableFrom(type)) {
                return JavaTimeUtil.parseOffsetDateTime(source.getAsString());
            }
            if (ZonedDateTime.class.isAssignableFrom(type)) {
                return JavaTimeUtil.parseZonedDateTime(source.getAsString());
            }
            return source.getAsString();
        }
        if (source.isObject() && DBDocumentEntity.class.isAssignableFrom(type)) {
            return this.readDBDocumentEntity(source);
        }
        throw new MappingException(String.format("Can't read type %s from VPack type %s!", type, source.getType()));
    }

    private BaseDocument readBaseDocument(Class<?> type, VPackSlice source) {
        Map properties = (Map)this.readMap((TypeInformation<?>)ClassTypeInformation.MAP, source);
        if (BaseDocument.class.equals(type)) {
            return new BaseDocument(properties);
        }
        if (BaseEdgeDocument.class.equals(type)) {
            return new BaseEdgeDocument(properties);
        }
        throw new MappingException(String.format("Can't read type %s as %s!", type, BaseDocument.class));
    }

    private DBDocumentEntity readDBDocumentEntity(VPackSlice source) {
        return new DBDocumentEntity((Map)this.readMap((TypeInformation<?>)ClassTypeInformation.MAP, source));
    }

    private ParameterValueProvider<ArangoPersistentProperty> getParameterProvider(ArangoPersistentEntity<?> entity, VPackSlice source) {
        ArangoPropertyValueProvider provider = new ArangoPropertyValueProvider(entity, source);
        return new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, null);
    }

    public void write(Object source, VPackBuilder sink) {
        if (source == null) {
            this.writeSimple(null, null, sink);
            return;
        }
        Object entity = source instanceof LazyLoadingProxy ? ((LazyLoadingProxy)source).getEntity() : source;
        this.writeInternal(null, entity, sink, (TypeInformation<?>)ClassTypeInformation.OBJECT);
    }

    private void writeInternal(String attribute, Object source, VPackBuilder sink, TypeInformation<?> definedType) {
        Class<?> rawType = source.getClass();
        ClassTypeInformation type = ClassTypeInformation.from(rawType);
        if (this.conversions.isSimpleType(rawType)) {
            Optional customWriteTarget = this.conversions.getCustomWriteTarget(rawType);
            Class<?> targetType = customWriteTarget.orElse(rawType);
            this.writeSimple(attribute, this.conversionService.convert(source, targetType), sink);
        } else if (BaseDocument.class.equals(rawType)) {
            this.writeBaseDocument(attribute, (BaseDocument)source, sink, definedType);
        } else if (BaseEdgeDocument.class.equals(rawType)) {
            this.writeBaseEdgeDocument(attribute, (BaseEdgeDocument)source, sink, definedType);
        } else if (type.isMap()) {
            this.writeMap(attribute, (Map)source, sink, definedType);
        } else if (type.getType().isArray()) {
            this.writeArray(attribute, source, sink, definedType);
        } else if (type.isCollectionLike()) {
            this.writeCollection(attribute, source, sink, definedType);
        } else {
            ArangoPersistentEntity entity = (ArangoPersistentEntity)this.context.getRequiredPersistentEntity(source.getClass());
            this.writeEntity(attribute, source, sink, entity, definedType);
        }
    }

    private void writeEntity(String attribute, Object source, VPackBuilder sink, ArangoPersistentEntity<?> entity, TypeInformation<?> definedType) {
        sink.add(attribute, ValueType.OBJECT);
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        entity.doWithProperties(property -> {
            if (!property.isWritable()) {
                return;
            }
            if (property.isIdProperty()) {
                Object id = entity.getIdentifierAccessor(source).getIdentifier();
                if (id != null) {
                    sink.add(_KEY, this.convertId(id));
                }
                return;
            }
            Object value = accessor.getProperty(property);
            if (value != null) {
                this.writeProperty(value, sink, (ArangoPersistentProperty)property);
            }
        });
        entity.doWithAssociations(association -> {
            ArangoPersistentProperty inverse = (ArangoPersistentProperty)association.getInverse();
            Object value = accessor.getProperty((PersistentProperty)inverse);
            if (value != null) {
                this.writeProperty(value, sink, inverse);
            }
        });
        this.addKeyIfNecessary(entity, source, sink);
        this.addTypeKeyIfNecessary(definedType, source, sink);
        sink.close();
    }

    private void addKeyIfNecessary(ArangoPersistentEntity<?> entity, Object source, VPackBuilder sink) {
        Object id;
        if (!(entity.hasIdProperty() && entity.getIdentifierAccessor(source).getIdentifier() != null || (id = entity.getArangoIdAccessor(source).getIdentifier()) == null)) {
            sink.add(_KEY, MetadataUtils.determineDocumentKeyFromId((String)id));
        }
    }

    private void writeProperty(Object source, VPackBuilder sink, ArangoPersistentProperty property) {
        if (source == null) {
            return;
        }
        ClassTypeInformation sourceType = ClassTypeInformation.from(source.getClass());
        String fieldName = property.getFieldName();
        if (property.getRef().isPresent()) {
            if (sourceType.isCollectionLike()) {
                this.writeReferences(fieldName, source, sink, property.getRef().get());
            } else {
                this.writeReference(fieldName, source, sink, property.getRef().get());
            }
        } else if (!property.getRelations().isPresent()) {
            if (property.getFrom().isPresent() || property.getTo().isPresent()) {
                if (!sourceType.isCollectionLike()) {
                    this.writeReference(fieldName, source, sink, null);
                }
            } else {
                Object entity = source instanceof LazyLoadingProxy ? ((LazyLoadingProxy)source).getEntity() : source;
                this.writeInternal(fieldName, entity, sink, property.getTypeInformation());
            }
        }
    }

    private void writeMap(String attribute, Map<? extends Object, ? extends Object> source, VPackBuilder sink, TypeInformation<?> definedType) {
        sink.add(attribute, ValueType.OBJECT);
        for (Map.Entry<? extends Object, ? extends Object> entry : source.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            String convertedKey = this.convertId(key);
            if (value == null) continue;
            this.writeInternal(convertedKey, value, sink, this.getNonNullMapValueType(definedType));
        }
        sink.close();
    }

    private void writeCollection(String attribute, Object source, VPackBuilder sink, TypeInformation<?> definedType) {
        sink.add(attribute, ValueType.ARRAY);
        for (Object entry : DefaultArangoConverter.asCollection(source)) {
            if (entry == null) {
                this.writeSimple(null, null, sink);
                continue;
            }
            this.writeInternal(null, entry, sink, this.getNonNullComponentType(definedType));
        }
        sink.close();
    }

    private void writeArray(String attribute, Object source, VPackBuilder sink, TypeInformation<?> definedType) {
        if (byte[].class.equals(source.getClass())) {
            sink.add(attribute, Base64Utils.encodeToString((byte[])((byte[])source)));
        } else {
            sink.add(attribute, ValueType.ARRAY);
            for (int i = 0; i < Array.getLength(source); ++i) {
                Object element = Array.get(source, i);
                if (element == null) {
                    this.writeSimple(null, null, sink);
                    continue;
                }
                this.writeInternal(null, element, sink, this.getNonNullComponentType(definedType));
            }
            sink.close();
        }
    }

    private void writeReferences(String attribute, Object source, VPackBuilder sink, Ref annotation) {
        sink.add(attribute, ValueType.ARRAY);
        if (source.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(source); ++i) {
                Object element = Array.get(source, i);
                this.writeReference(null, element, sink, annotation);
            }
        } else {
            for (Object element : DefaultArangoConverter.asCollection(source)) {
                this.writeReference(null, element, sink, annotation);
            }
        }
        sink.close();
    }

    private void writeReference(String attribute, Object source, VPackBuilder sink, Ref annotation) {
        this.getRefId(source, annotation).ifPresent(id -> sink.add(attribute, id));
    }

    private void writeSimple(String attribute, Object source, VPackBuilder sink) {
        if (source == null) {
            sink.add(ValueType.NULL);
        } else if (source instanceof VPackSlice) {
            sink.add(attribute, (VPackSlice)source);
        } else if (source instanceof DBDocumentEntity) {
            this.writeMap(attribute, (Map)source, sink, (TypeInformation<?>)ClassTypeInformation.MAP);
        } else if (source instanceof Boolean) {
            sink.add(attribute, (Boolean)source);
        } else if (source instanceof Byte) {
            sink.add(attribute, (Byte)source);
        } else if (source instanceof Character) {
            sink.add(attribute, (Character)source);
        } else if (source instanceof Short) {
            sink.add(attribute, (Short)source);
        } else if (source instanceof Integer) {
            sink.add(attribute, (Integer)source);
        } else if (source instanceof Long) {
            sink.add(attribute, (Long)source);
        } else if (source instanceof Float) {
            sink.add(attribute, (Float)source);
        } else if (source instanceof Double) {
            sink.add(attribute, (Double)source);
        } else if (source instanceof String) {
            sink.add(attribute, (String)source);
        } else if (source instanceof Class) {
            sink.add(attribute, ((Class)source).getName());
        } else if (source instanceof Enum) {
            sink.add(attribute, ((Enum)source).name());
        } else if (ClassUtils.isPrimitiveArray(source.getClass())) {
            this.writeArray(attribute, source, sink, (TypeInformation<?>)ClassTypeInformation.OBJECT);
        } else if (source instanceof java.util.Date) {
            sink.add(attribute, DateUtil.format((java.util.Date)((java.util.Date)source)));
        } else if (source instanceof BigInteger) {
            sink.add(attribute, (BigInteger)source);
        } else if (source instanceof BigDecimal) {
            sink.add(attribute, (BigDecimal)source);
        } else if (source instanceof Instant) {
            sink.add(attribute, JavaTimeUtil.format((Instant)source));
        } else if (source instanceof LocalDate) {
            sink.add(attribute, JavaTimeUtil.format((LocalDate)source));
        } else if (source instanceof LocalDateTime) {
            sink.add(attribute, JavaTimeUtil.format((LocalDateTime)source));
        } else if (source instanceof OffsetDateTime) {
            sink.add(attribute, JavaTimeUtil.format((OffsetDateTime)source));
        } else if (source instanceof ZonedDateTime) {
            sink.add(attribute, JavaTimeUtil.format((ZonedDateTime)source));
        } else {
            throw new MappingException(String.format("Type %s is not a simple type!", source.getClass()));
        }
    }

    private void writeBaseDocument(String attribute, BaseDocument source, VPackBuilder sink, TypeInformation<?> definedType) {
        VPackBuilder builder = new VPackBuilder();
        this.writeMap(attribute, source.getProperties(), builder, definedType);
        builder.add(_ID, source.getId());
        builder.add(_KEY, source.getKey());
        builder.add(_REV, source.getRevision());
        sink.add(attribute, builder.slice());
    }

    private void writeBaseEdgeDocument(String attribute, BaseEdgeDocument source, VPackBuilder sink, TypeInformation<?> definedType) {
        VPackBuilder builder = new VPackBuilder();
        this.writeMap(attribute, source.getProperties(), builder, definedType);
        builder.add(_ID, source.getId());
        builder.add(_KEY, source.getKey());
        builder.add(_REV, source.getRevision());
        builder.add(_FROM, source.getFrom());
        builder.add(_TO, source.getTo());
        sink.add(attribute, builder.slice());
    }

    private Optional<String> getRefId(Object source, Ref annotation) {
        return this.getRefId(source, (ArangoPersistentEntity)this.context.getPersistentEntity(source.getClass()), annotation);
    }

    private Optional<String> getRefId(Object source, ArangoPersistentEntity<?> entity, Ref annotation) {
        if (source instanceof LazyLoadingProxy) {
            return Optional.of(((LazyLoadingProxy)source).getRefId());
        }
        Optional<Object> id = Optional.ofNullable(entity.getIdentifierAccessor(source).getIdentifier());
        if (id.isPresent()) {
            if (annotation != null) {
                Optional<ReferenceResolver<Ref>> resolver = this.resolverFactory.getReferenceResolver(annotation);
                return id.map(key -> ((ReferenceResolver)resolver.get()).write(source, entity, this.convertId(key), annotation));
            }
            return id.map(key -> MetadataUtils.createIdFromCollectionAndKey(entity.getCollection(), this.convertId(key)));
        }
        return Optional.ofNullable((String)entity.getArangoIdAccessor(source).getIdentifier());
    }

    private static Collection<?> asCollection(Object source) {
        return source instanceof Collection ? (Set<Object>)Collection.class.cast(source) : (source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source));
    }

    private boolean isSimpleType(Class<?> type) {
        return ArangoSimpleTypes.HOLDER.isSimpleType(type);
    }

    @Override
    public boolean isCollectionType(Class<?> type) {
        return type.isArray() || Iterable.class.equals(type) || Collection.class.isAssignableFrom(type);
    }

    private boolean isMapType(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    public GenericConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public boolean isEntityType(Class<?> type) {
        return !this.isSimpleType(type) && !this.isMapType(type) && !this.isCollectionType(type);
    }

    private <T> T convertIfNecessary(Object source, Class<T> type) {
        return (T)(source == null ? source : (type.isAssignableFrom(source.getClass()) ? source : this.conversionService.convert(source, type)));
    }

    private void addTypeKeyIfNecessary(TypeInformation<?> definedType, Object value, VPackBuilder sink) {
        Class referenceType = definedType != null ? definedType.getType() : Object.class;
        Class valueType = ClassUtils.getUserClass(value.getClass());
        if (!valueType.equals(referenceType)) {
            this.typeMapper.writeType(valueType, sink);
        }
    }

    private boolean isValidId(Object key) {
        if (key == null) {
            return false;
        }
        Class<?> type = key.getClass();
        if (DBDocumentEntity.class.isAssignableFrom(type)) {
            return false;
        }
        if (VPackSlice.class.isAssignableFrom(type)) {
            return false;
        }
        if (type.isArray() && type.getComponentType() != Byte.TYPE) {
            return false;
        }
        if (this.isSimpleType(type)) {
            return true;
        }
        return this.conversions.hasCustomWriteTarget(key.getClass(), String.class);
    }

    @Override
    public String convertId(Object id) {
        if (!this.isValidId(id)) {
            throw new MappingException(String.format("Type %s is not a valid id type!", id != null ? id.getClass() : "null"));
        }
        if (id instanceof String) {
            return id.toString();
        }
        boolean hasCustomConverter = this.conversions.hasCustomWriteTarget(id.getClass(), String.class);
        return hasCustomConverter ? (String)this.conversionService.convert(id, String.class) : id.toString();
    }

    private TypeInformation<?> getNonNullComponentType(TypeInformation<?> type) {
        TypeInformation compType = type.getComponentType();
        return compType != null ? compType : ClassTypeInformation.OBJECT;
    }

    private TypeInformation<?> getNonNullMapValueType(TypeInformation<?> type) {
        TypeInformation valueType = type.getMapValueType();
        return valueType != null ? valueType : ClassTypeInformation.OBJECT;
    }

    private java.util.Date parseDate(String source) {
        try {
            return DateUtil.parse((String)source);
        }
        catch (ParseException e) {
            throw new MappingException(String.format("Can't parse java.util.Date from String %s!", source), (Throwable)e);
        }
    }

    private class ArangoPropertyValueProvider
    implements PropertyValueProvider<ArangoPersistentProperty> {
        private final ArangoPersistentEntity<?> entity;
        private final VPackSlice source;
        private final String id;

        public ArangoPropertyValueProvider(ArangoPersistentEntity<?> entity, VPackSlice source) {
            this.entity = entity;
            this.source = source;
            this.id = source.get(DefaultArangoConverter._ID).isString() ? source.get(DefaultArangoConverter._ID).getAsString() : null;
        }

        public <T> T getPropertyValue(ArangoPersistentProperty property) {
            VPackSlice value = this.source.get(property.getFieldName());
            return (T)DefaultArangoConverter.this.readPropertyValue(this.entity, this.id, value, property);
        }
    }
}

