/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert;

import com.arangodb.springframework.core.convert.ArangoTypeAliasAccessor;
import com.arangodb.springframework.core.convert.ArangoTypeMapper;
import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackSlice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.convert.MappingContextTypeInformationMapper;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class DefaultArangoTypeMapper
implements ArangoTypeMapper {
    public static final String DEFAULT_TYPE_KEY = "_class";
    private final String typeKey;
    private final ArangoTypeAliasAccessor accessor;
    private final List<? extends TypeInformationMapper> mappers;
    private final Map<Alias, Optional<TypeInformation<?>>> typeCache;

    public DefaultArangoTypeMapper() {
        this(DEFAULT_TYPE_KEY);
    }

    public DefaultArangoTypeMapper(String typeKey) {
        this(typeKey, Arrays.asList(new SimpleTypeInformationMapper()));
    }

    public DefaultArangoTypeMapper(String typeKey, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext) {
        this(typeKey, new DefaultTypeAliasAccessor(typeKey), mappingContext, Arrays.asList(new SimpleTypeInformationMapper()));
    }

    public DefaultArangoTypeMapper(String typeKey, List<? extends TypeInformationMapper> mappers) {
        this(typeKey, new DefaultTypeAliasAccessor(typeKey), null, mappers);
    }

    private DefaultArangoTypeMapper(String typeKey, ArangoTypeAliasAccessor accessor, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext, List<? extends TypeInformationMapper> additionalMappers) {
        Assert.notNull((Object)accessor, (String)"Accessor must not be null!");
        Assert.notNull(additionalMappers, (String)"AdditionalMappers must not be null!");
        ArrayList<Object> mappers = new ArrayList<Object>(additionalMappers.size() + 1);
        if (mappingContext != null) {
            mappers.add(new MappingContextTypeInformationMapper(mappingContext));
        }
        mappers.addAll(additionalMappers);
        this.mappers = Collections.unmodifiableList(mappers);
        this.accessor = accessor;
        this.typeCache = new ConcurrentHashMap(16, 0.75f, 4);
        this.typeKey = typeKey;
    }

    @Override
    public TypeInformation<?> readType(VPackSlice source) {
        Assert.notNull((Object)source, (String)"Source must not be null!");
        return this.getFromCacheOrCreate(this.accessor.readAliasFrom(source));
    }

    @Override
    public <T> TypeInformation<? extends T> readType(VPackSlice source, TypeInformation<T> basicType) {
        boolean isMoreConcreteCustomType;
        Assert.notNull((Object)source, (String)"Source must not be null!");
        Assert.notNull(basicType, (String)"Basic type must not be null!");
        TypeInformation<?> documentsTargetType = this.readType(source);
        if (documentsTargetType == null) {
            return basicType;
        }
        Class rawType = basicType.getType();
        boolean bl = isMoreConcreteCustomType = rawType == null || rawType.isAssignableFrom(documentsTargetType.getType()) && !rawType.equals(documentsTargetType);
        if (!isMoreConcreteCustomType) {
            return basicType;
        }
        ClassTypeInformation targetType = ClassTypeInformation.from((Class)documentsTargetType.getType());
        return basicType.specialize(targetType);
    }

    @Override
    public void writeType(Class<?> type, VPackBuilder sink) {
        this.writeType((TypeInformation<?>)ClassTypeInformation.from(type), sink);
    }

    @Override
    public void writeType(TypeInformation<?> info, VPackBuilder sink) {
        Assert.notNull(info, (String)"TypeInformation must not be null!");
        Alias alias = this.getAliasFor(info);
        if (alias.isPresent()) {
            this.accessor.writeTypeTo(sink, alias.getValue());
        }
    }

    @Override
    public boolean isTypeKey(String key) {
        return this.typeKey == null ? false : this.typeKey.equals(key);
    }

    protected final Alias getAliasFor(TypeInformation<?> info) {
        Assert.notNull(info, (String)"TypeInformation must not be null!");
        for (TypeInformationMapper typeInformationMapper : this.mappers) {
            Alias alias = typeInformationMapper.createAliasFor(info);
            if (!alias.isPresent()) continue;
            return alias;
        }
        return Alias.NONE;
    }

    private TypeInformation<?> getFromCacheOrCreate(Alias alias) {
        return this.typeCache.computeIfAbsent(alias, key -> {
            for (TypeInformationMapper typeInformationMapper : this.mappers) {
                TypeInformation typeInformation = typeInformationMapper.resolveTypeFrom(key);
                if (typeInformation == null) continue;
                return Optional.of(typeInformation);
            }
            return Optional.empty();
        }).orElse(null);
    }

    public static final class DefaultTypeAliasAccessor
    implements ArangoTypeAliasAccessor {
        private final String typeKey;

        public DefaultTypeAliasAccessor(String typeKey) {
            this.typeKey = typeKey;
        }

        @Override
        public Alias readAliasFrom(VPackSlice source) {
            if (source.isArray()) {
                return Alias.NONE;
            }
            if (source.isObject()) {
                VPackSlice typeKey = source.get(this.typeKey);
                return Alias.ofNullable((Object)(typeKey.isString() ? typeKey.getAsString() : null));
            }
            throw new IllegalArgumentException("Cannot read alias from VPack type " + source.getType());
        }

        @Override
        public void writeTypeTo(VPackBuilder sink, Object alias) {
            if (this.typeKey != null) {
                sink.add(this.typeKey, alias.toString());
            }
        }
    }
}

