/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert.resolver;

import com.arangodb.springframework.core.convert.resolver.LazyLoadingProxy;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractResolver<A extends Annotation> {
    private static final Method GET_ENTITY_METHOD;
    private static final Method GET_REF_ID_METHOD;
    private final ObjenesisStd objenesis;
    private final ConversionService conversionService;

    protected AbstractResolver(ConversionService conversionService) {
        this.conversionService = conversionService;
        this.objenesis = new ObjenesisStd(true);
    }

    protected Object proxy(String id, TypeInformation<?> type, A annotation, ResolverCallback<A> callback) {
        ProxyInterceptor<A> interceptor = new ProxyInterceptor<A>(id, type, annotation, callback, this.conversionService);
        if (type.getType().isInterface()) {
            ProxyFactory proxyFactory = new ProxyFactory(new Class[]{type.getType()});
            for (Class<?> interf : type.getType().getInterfaces()) {
                proxyFactory.addInterface(interf);
            }
            proxyFactory.addInterface(LazyLoadingProxy.class);
            proxyFactory.addAdvice(interceptor);
            return proxyFactory.getProxy();
        }
        Factory factory = (Factory)this.objenesis.newInstance(this.enhancedTypeFor(type.getType()));
        factory.setCallbacks(new Callback[]{interceptor});
        return factory;
    }

    private Class<?> enhancedTypeFor(Class<?> type) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setCallbackType(MethodInterceptor.class);
        enhancer.setInterfaces(new Class[]{LazyLoadingProxy.class});
        return enhancer.createClass();
    }

    protected static TypeInformation<?> getNonNullComponentType(TypeInformation<?> type) {
        TypeInformation compType = type.getComponentType();
        return compType != null ? compType : ClassTypeInformation.OBJECT;
    }

    static {
        try {
            GET_ENTITY_METHOD = LazyLoadingProxy.class.getMethod("getEntity", new Class[0]);
            GET_REF_ID_METHOD = LazyLoadingProxy.class.getMethod("getRefId", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class ProxyInterceptor<A extends Annotation>
    implements Serializable,
    MethodInterceptor,
    org.aopalliance.intercept.MethodInterceptor {
        private static final long serialVersionUID = -6722757823918987065L;
        private final String id;
        final TypeInformation<?> type;
        private final A annotation;
        private final ResolverCallback<A> callback;
        private volatile boolean resolved;
        private Object result;
        private final ConversionService conversionService;

        public ProxyInterceptor(String id, TypeInformation<?> type, A annotation, ResolverCallback<A> callback, ConversionService conversionService) {
            this.id = id;
            this.type = type;
            this.annotation = annotation;
            this.callback = callback;
            this.conversionService = conversionService;
            this.result = null;
            this.resolved = false;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object result;
            if (GET_ENTITY_METHOD.equals(method)) {
                return this.ensureResolved();
            }
            if (GET_REF_ID_METHOD.equals(method)) {
                return this.id;
            }
            if (ReflectionUtils.isObjectMethod((Method)method)) {
                if (ReflectionUtils.isToStringMethod((Method)method)) {
                    return this.proxyToString();
                }
                if (ReflectionUtils.isEqualsMethod((Method)method)) {
                    return this.proxyEquals(proxy, args[0]);
                }
                if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                    return this.proxyHashCode();
                }
            }
            return (result = this.ensureResolved()) == null ? null : method.invoke(result, args);
        }

        private Object ensureResolved() {
            if (!this.resolved) {
                this.result = this.resolve();
                this.resolved = true;
            }
            return this.result;
        }

        private synchronized Object resolve() {
            if (!this.resolved) {
                return this.convertIfNecessary(this.callback.resolve(this.id, this.type, this.annotation), this.type.getType());
            }
            return this.result;
        }

        private String proxyToString() {
            StringBuilder str = new StringBuilder();
            str.append(LazyLoadingProxy.class.getSimpleName());
            str.append(" [");
            str.append(this.id);
            str.append("]");
            return str.toString();
        }

        private int proxyHashCode() {
            return this.proxyToString().hashCode();
        }

        private boolean proxyEquals(Object proxy, Object obj) {
            if (!(obj instanceof LazyLoadingProxy)) {
                return false;
            }
            if (obj == proxy) {
                return true;
            }
            return this.proxyToString().equals(obj.toString());
        }

        private <T> T convertIfNecessary(@Nullable Object source, Class<T> type) {
            return (T)(source == null ? null : (type.isAssignableFrom(source.getClass()) ? source : this.conversionService.convert(source, type)));
        }
    }

    public static interface ResolverCallback<A extends Annotation> {
        public Object resolve(String var1, TypeInformation<?> var2, A var3);
    }
}

