/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert.resolver;

import com.arangodb.ArangoCursor;
import com.arangodb.springframework.annotation.Relations;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.core.convert.resolver.AbstractResolver;
import com.arangodb.springframework.core.convert.resolver.RelationResolver;
import com.arangodb.util.MapBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.util.TypeInformation;

public class RelationsResolver
extends AbstractResolver<Relations>
implements RelationResolver<Relations> {
    private final ArangoOperations template;

    public RelationsResolver(ArangoOperations template) {
        super(template.getConverter().getConversionService());
        this.template = template;
    }

    @Override
    public Object resolveOne(String id, TypeInformation<?> type, Relations annotation) {
        return annotation.lazy() ? this.proxy(id, type, annotation, (i, t, a) -> this._resolveOne(i, (TypeInformation<?>)t, (Relations)a)) : this._resolveOne(id, type, annotation);
    }

    @Override
    public Object resolveMultiple(String id, TypeInformation<?> type, Relations annotation) {
        return annotation.lazy() ? this.proxy(id, type, annotation, (i, t, a) -> this._resolveMultiple(i, (TypeInformation<?>)t, (Relations)a)) : this._resolveMultiple(id, type, annotation);
    }

    private Object _resolveOne(String id, TypeInformation<?> type, Relations annotation) {
        return this._resolve(id, type.getType(), annotation, true).first();
    }

    private Object _resolveMultiple(String id, TypeInformation<?> type, Relations annotation) {
        return this._resolve(id, RelationsResolver.getNonNullComponentType(type).getType(), annotation, false).asListRemaining();
    }

    private ArangoCursor<?> _resolve(String id, Class<?> type, Relations annotation, boolean limit) {
        String edges = Arrays.stream(annotation.edges()).map(e -> this.template.collection((Class<?>)e).name()).collect(Collectors.joining(","));
        String query = String.format("WITH @@vertex FOR v IN %d .. %d %s @start %s OPTIONS {bfs: true, uniqueVertices: \"global\"} %s RETURN v", new Object[]{Math.max(1, annotation.minDepth()), Math.max(1, annotation.maxDepth()), annotation.direction(), edges, limit ? "LIMIT 1" : ""});
        Map bindVars = new MapBuilder().put("start", (Object)id).put("@vertex", type).get();
        return this.template.query(query, bindVars, type);
    }
}

