/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.mapping;

import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import java.util.Optional;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.TargetAwareIdentifierAccessor;
import org.springframework.util.Assert;

public class ArangoIdPropertyIdentifierAccessor
extends TargetAwareIdentifierAccessor {
    private final ArangoPersistentProperty arangoIdProperty;
    private final PersistentPropertyAccessor<?> accessor;

    public ArangoIdPropertyIdentifierAccessor(ArangoPersistentEntity<?> entity, Object target) {
        super(target);
        Assert.notNull(entity, (String)"PersistentEntity must not be null!");
        Optional<ArangoPersistentProperty> aip = entity.getArangoIdProperty();
        Assert.isTrue((boolean)aip.isPresent(), (String)"PersistentEntity must have an arango identifier property!");
        Assert.notNull((Object)target, (String)"Target bean must not be null!");
        this.arangoIdProperty = aip.get();
        this.accessor = entity.getPropertyAccessor(target);
    }

    public Object getIdentifier() {
        return this.accessor.getProperty((PersistentProperty)this.arangoIdProperty);
    }
}

