/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.mapping;

import com.arangodb.springframework.annotation.ArangoId;
import com.arangodb.springframework.annotation.Field;
import com.arangodb.springframework.annotation.From;
import com.arangodb.springframework.annotation.FulltextIndexed;
import com.arangodb.springframework.annotation.GeoIndexed;
import com.arangodb.springframework.annotation.HashIndexed;
import com.arangodb.springframework.annotation.PersistentIndexed;
import com.arangodb.springframework.annotation.Ref;
import com.arangodb.springframework.annotation.Relations;
import com.arangodb.springframework.annotation.Rev;
import com.arangodb.springframework.annotation.SkiplistIndexed;
import com.arangodb.springframework.annotation.To;
import com.arangodb.springframework.annotation.TtlIndexed;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import java.util.Optional;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.StringUtils;

public class DefaultArangoPersistentProperty
extends AnnotationBasedPersistentProperty<ArangoPersistentProperty>
implements ArangoPersistentProperty {
    private final FieldNamingStrategy fieldNamingStrategy;

    public DefaultArangoPersistentProperty(Property property, PersistentEntity<?, ArangoPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.fieldNamingStrategy = fieldNamingStrategy != null ? fieldNamingStrategy : PropertyNameFieldNamingStrategy.INSTANCE;
    }

    protected Association<ArangoPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public boolean isArangoIdProperty() {
        return this.findAnnotation(ArangoId.class) != null;
    }

    @Override
    public boolean isRevProperty() {
        return this.findAnnotation(Rev.class) != null;
    }

    @Override
    public Optional<Ref> getRef() {
        return Optional.ofNullable(this.findAnnotation(Ref.class));
    }

    @Override
    public Optional<Relations> getRelations() {
        return Optional.ofNullable(this.findAnnotation(Relations.class));
    }

    @Override
    public Optional<From> getFrom() {
        return Optional.ofNullable(this.findAnnotation(From.class));
    }

    @Override
    public Optional<To> getTo() {
        return Optional.ofNullable(this.findAnnotation(To.class));
    }

    @Override
    public String getFieldName() {
        String fieldName = this.isArangoIdProperty() ? "_id" : (this.isIdProperty() ? "_key" : (this.isRevProperty() ? "_rev" : (this.getFrom().isPresent() ? "_from" : (this.getTo().isPresent() ? "_to" : this.getAnnotatedFieldName().orElse(this.fieldNamingStrategy.getFieldName((PersistentProperty)this))))));
        return fieldName;
    }

    private Optional<String> getAnnotatedFieldName() {
        return Optional.ofNullable(this.findAnnotation(Field.class)).map(f -> StringUtils.hasText((String)f.value()) ? f.value() : null);
    }

    @Override
    public Optional<HashIndexed> getHashIndexed() {
        return Optional.ofNullable(this.findAnnotation(HashIndexed.class));
    }

    @Override
    public Optional<SkiplistIndexed> getSkiplistIndexed() {
        return Optional.ofNullable(this.findAnnotation(SkiplistIndexed.class));
    }

    @Override
    public Optional<PersistentIndexed> getPersistentIndexed() {
        return Optional.ofNullable(this.findAnnotation(PersistentIndexed.class));
    }

    @Override
    public Optional<GeoIndexed> getGeoIndexed() {
        return Optional.ofNullable(this.findAnnotation(GeoIndexed.class));
    }

    @Override
    public Optional<FulltextIndexed> getFulltextIndexed() {
        return Optional.ofNullable(this.findAnnotation(FulltextIndexed.class));
    }

    @Override
    public Optional<TtlIndexed> getTtlIndexed() {
        return Optional.ofNullable(this.findAnnotation(TtlIndexed.class));
    }
}

