/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.template;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDBException;
import com.arangodb.entity.CollectionPropertiesEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.HashIndexOptions;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.SkiplistIndexOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.springframework.core.CollectionOperations;
import com.arangodb.springframework.core.template.CollectionCacheKey;
import com.arangodb.springframework.core.template.CollectionCacheValue;
import java.util.Collection;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class DefaultCollectionOperations
implements CollectionOperations {
    private final ArangoCollection collection;
    private final Map<CollectionCacheKey, CollectionCacheValue> collectionCache;
    private final PersistenceExceptionTranslator exceptionTranslator;

    protected DefaultCollectionOperations(ArangoCollection collection, Map<CollectionCacheKey, CollectionCacheValue> collectionCache, PersistenceExceptionTranslator exceptionTranslator) {
        this.collection = collection;
        this.collectionCache = collectionCache;
        this.exceptionTranslator = exceptionTranslator;
    }

    private DataAccessException translateExceptionIfPossible(RuntimeException exception) {
        return this.exceptionTranslator.translateExceptionIfPossible(exception);
    }

    @Override
    public String name() {
        return this.collection.name();
    }

    @Override
    public void drop() throws DataAccessException {
        this.collectionCache.remove(new CollectionCacheKey(this.collection.db().name(), this.collection.name()));
        try {
            this.collection.drop();
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void truncate() throws DataAccessException {
        try {
            this.collection.truncate();
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public long count() throws DataAccessException {
        try {
            Long count = this.collection.count().getCount();
            return count != null ? count : -1L;
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public CollectionPropertiesEntity getProperties() throws DataAccessException {
        try {
            return this.collection.getProperties();
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public Collection<IndexEntity> getIndexes() throws DataAccessException {
        try {
            return this.collection.getIndexes();
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public IndexEntity ensureHashIndex(Iterable<String> fields, HashIndexOptions options) throws DataAccessException {
        try {
            return this.collection.ensureHashIndex(fields, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public IndexEntity ensureSkiplistIndex(Iterable<String> fields, SkiplistIndexOptions options) throws DataAccessException {
        try {
            return this.collection.ensureSkiplistIndex(fields, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public IndexEntity ensurePersistentIndex(Iterable<String> fields, PersistentIndexOptions options) throws DataAccessException {
        try {
            return this.collection.ensurePersistentIndex(fields, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public IndexEntity ensureGeoIndex(Iterable<String> fields, GeoIndexOptions options) throws DataAccessException {
        try {
            return this.collection.ensureGeoIndex(fields, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public IndexEntity ensureFulltextIndex(Iterable<String> fields, FulltextIndexOptions options) throws DataAccessException {
        try {
            return this.collection.ensureFulltextIndex(fields, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public IndexEntity ensureTtlIndex(Iterable<String> fields, TtlIndexOptions options) throws DataAccessException {
        try {
            return this.collection.ensureTtlIndex(fields, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void dropIndex(String id) throws DataAccessException {
        try {
            this.collection.deleteIndex(id);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void grantAccess(String username, Permissions permissions) {
        try {
            this.collection.grantAccess(username, permissions);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void resetAccess(String username) {
        try {
            this.collection.resetAccess(username);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public Permissions getPermissions(String username) throws DataAccessException {
        try {
            return this.collection.getPermissions(username);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }
}

